/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.analyzer;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.currency.CurrencyUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.analyzer.FieldAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="labelFieldAnalyzer")
public class LabelFieldAnalyzer
implements FieldAnalyzer<String> {
    private static final Logger logger = LoggerFactory.getLogger(LabelFieldAnalyzer.class);
    public static final String FIELD_TYPE = "LABEL";
    private static final String FIELD_LABEL_VALUE_TEMPLATE = "%s: %s";
    private static final String FIELD_VALUE_TEMPLATE = "%s";
    private static final String FIELD_TYPE_CHECK_ERROR_MSG = String.format("Only %s type field can be anaylyzed", "LABEL");

    public String analyze(UiBotLayout uiBotLayout, JSONObject data, UiBotPageData pageData, Boolean valueOnly) {
        Assert.notNull((Object)uiBotLayout, (String)"uiBotField must not be null");
        String title = uiBotLayout.getTitle();
        String schema = uiBotLayout.getSchema();
        String type = uiBotLayout.getType();
        Boolean thousandthPercentile = uiBotLayout.getThousandthPercentile();
        if (null == data || data.isEmpty()) {
            if (valueOnly.booleanValue()) {
                return String.format(FIELD_VALUE_TEMPLATE, "\u2014");
            }
            return String.format(FIELD_LABEL_VALUE_TEMPLATE, "\u2014");
        }
        String value = data.getString(schema);
        if (null != thousandthPercentile && thousandthPercentile.booleanValue() && "AMOUNT".equalsIgnoreCase(type)) {
            String localCurrency;
            value = CurrencyUtil.fmtMicrometer((String)value);
            Map uibotGlobalParameter = (Map)pageData.get((Object)"uibot__global_parameter");
            if (uibotGlobalParameter != null && null != (localCurrency = (String)uibotGlobalParameter.get("local_currency")) && localCurrency.trim().length() > 0) {
                value = localCurrency + value;
            }
        }
        if (valueOnly.booleanValue()) {
            return String.format(FIELD_VALUE_TEMPLATE, value);
        }
        return String.format(FIELD_LABEL_VALUE_TEMPLATE, title, value);
    }
}

