/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmServiceInvokeType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.BpmTaskParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service(value="bpmUserTaskParser")
public class BpmUserTaskParser
implements BpmTaskParser {
    public String getRelativeUrl(BpmServiceInvokeType invokeType) {
        if (invokeType.equals((Object)BpmServiceInvokeType.Dispatch)) {
            return "/v1/process-engine/workitems/dispatch-workitem";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.Agree)) {
            return "/v1/process-engine/workitems/dispatch-workitem";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.Reject)) {
            return "/v1/process-engine/tasks/terminate-user-task";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.ReAssign)) {
            return "/v1/process-engine/workitems/reassign-workitem";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.ReExecute) || invokeType.equals((Object)BpmServiceInvokeType.ReApprove)) {
            return "/v1/process-engine/tasks/reexecute-task";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.TerminateProcess)) {
            return "/v1/process-engine/process-instances/terminate-process";
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.AddTask)) {
            return "/v1/process-engine/tasks/add-task";
        }
        return null;
    }

    public Map<String, Object> getParameter(DigiwinAtmcTaskWithBacklogData taskData, DigiwinAtmcBacklogData backlogData, BpmServiceInvokeType invokeType) {
        String performerId = ((Map)backlogData.getWorkitemList().get(0)).get("performerId").toString();
        String performerName = ((Map)backlogData.getWorkitemList().get(0)).get("performerName").toString();
        String workitemId = ((Map)backlogData.getWorkitemList().get(0)).get("workitemId").toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processSerialNumber", taskData.getProcessSerialNumber());
        map.put("taskId", taskData.getBpmActivityId());
        map.put("performerId", performerId);
        map.put("comment", "");
        map.put("locale", AppRequestContext.getContextEntity().getLocale());
        if (!Objects.equals(performerId, AppRequestContext.getContextEntity().getUserId())) {
            map.put("performerType", 1);
            map.put("agentPerformerId", AppRequestContext.getContextEntity().getUserId());
        }
        if (invokeType.equals((Object)BpmServiceInvokeType.Agree)) {
            map.remove("taskId");
            map.put("workitemId", workitemId);
        } else if (invokeType.equals((Object)BpmServiceInvokeType.ReAssign)) {
            map.put("newPerformerId", "");
            map.put("workitemId", workitemId);
        } else if (invokeType.equals((Object)BpmServiceInvokeType.ReExecute) || invokeType.equals((Object)BpmServiceInvokeType.ReApprove)) {
            map.remove("performerId");
            map.put("taskId", "");
            map.put("reexecuteType", "FOLLOW_THE_DEFINITION");
            map.put("reexecuteUserId", performerId);
            map.put("workitemId", workitemId);
        } else if (invokeType.equals((Object)BpmServiceInvokeType.TerminateProcess)) {
            map.put("workitemId", workitemId);
            map.put("comment", "\u5206\u6279\u63d0\u4ea4\u6700\u540e\u4e00\u6279\u6570\u636e\u7ec8\u6b62\u6d41\u7a0b");
        } else if (invokeType.equals((Object)BpmServiceInvokeType.AddTask)) {
            map.remove("taskId");
            map.put("workitemId", workitemId);
            map.put("addType", "BackwardDispatch");
            HashMap<String, String> taskMap = new HashMap<String, String>();
            taskMap.put("taskName", performerName + " \u52a0\u7b7e");
            taskMap.put("performMode", "FIREST_GET_FIRST_WIN");
            taskMap.put("performType", "NORMAL");
            taskMap.put("performers", "");
            ArrayList<HashMap<String, String>> taskList = new ArrayList<HashMap<String, String>>();
            taskList.add(taskMap);
            map.put("taskList", taskList);
        }
        return map;
    }
}

