/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotApiMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotMetadataField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotOperationDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotShowMetadata;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.tag.PcUiBotTaggingData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.ShowFieldService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.SignTagService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.ConditionPageTemplate;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.GeneralPageTemplate;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotApiMetadataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotDefaultTagUtils;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPropertyPlaceholderUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotUnEditableTagUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PropertyPlaceholderHelper;

@Component
public class ConditionPageTemplate
extends GeneralPageTemplate<PcUiBotPageDefine> {
    private static final Logger log = LoggerFactory.getLogger(ConditionPageTemplate.class);
    private static final String SUPPORT_KEY = "webplatform-statement-general-page-template";
    private static final String RESID = "STATEMENT__resid";
    private static final String SCHEMA_KEY = "UIBOT__schema";
    private static final DateTimePlaceHolderResolver dateTimePlaceHolderResolver = new DateTimePlaceHolderResolver(null);
    @Autowired
    private PcRuleService pcRuleService;
    @Autowired
    private SignTagService signTagService;
    @Autowired
    private ShowFieldService showFieldService;

    public String supportKey() {
        return SUPPORT_KEY;
    }

    public QueryResultSet BuildDataSource(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine, UiBotModel dynamicForm, ApiRequest apiRequest) {
        return null;
    }

    protected void BuildLayout(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, QueryResultSet queryResultSet, PcUiBotPageDefine pageDefine, List<PcUiBotPageDefine> pageDefines, UiBotModel dynamicForm) {
        UiBotPageData pageData = dynamicForm.getPageData();
        this.putExtendedFieldToPageData((Map)pageData, pageDefine.getExtendedFields());
        pageData.put("UIBOT__activityName", pageDefine.getSubTitle());
    }

    private void putExtendedFieldToPageData(Map<String, Object> pageData, Map<String, Object> extendedFields) {
        if (MapUtils.isEmpty(extendedFields)) {
            return;
        }
        String locale = AppRequestContext.getContextEntity().getLocale();
        String targetResid = "STATEMENT__resid_" + locale;
        String finalResid = RESID;
        Set<Map.Entry<String, Object>> entries = extendedFields.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)entry.getKey(), (CharSequence)targetResid)) continue;
            finalResid = entry.getKey();
            break;
        }
        entries = extendedFields.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (StringUtils.startsWith((CharSequence)entry.getKey(), (CharSequence)RESID)) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)entry.getKey(), (CharSequence)finalResid)) continue;
                pageData.put(RESID, entry.getValue());
                continue;
            }
            pageData.put(entry.getKey(), entry.getValue());
        }
    }

    protected String getActionId(PcUiBotPageDefine mainQueryDTO) {
        return Optional.ofNullable(mainQueryDTO.getSubmitActions()).map(submitActions -> {
            if (CollectionUtils.isNotEmpty((Collection)submitActions)) {
                return ((PcUiBotSubmitAction)submitActions.get(0)).getActionId();
            }
            return "";
        }).orElse("");
    }

    protected void createDynamicForm(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotPageDefine mainQueryDTO, UiBotModel dynamicForm) {
        String actionId = this.getActionId(mainQueryDTO);
        if (StringUtils.isBlank((CharSequence)actionId)) {
            return;
        }
        PcUiBotApiMetadata apiMetadata = ((QueryActionCreateService)SpringContextHolder.getBean(QueryActionCreateService.class)).getMetadata(executeContext, actionId);
        this.handleAttachActions(mainQueryDTO, executeContext);
        this.appendEocMetadataField(executeContext, mainQueryDTO, apiMetadata);
        PcUiBotApiMetadataUtil.flatMetaData((PcUiBotApiMetadata)apiMetadata);
        PcUiBotTaggingData taggingData = this.getMetadataTags(mainQueryDTO, executeContext, actionId);
        this.signTagService.sinTagToMetadata(taggingData, apiMetadata);
        this.tagFieldCanEdit(apiMetadata.getRequestFields());
        List rules = this.pcRuleService.buildRuleOfKm(executeContext.getRelationTag().getActivityId(), apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        mainQueryDTO.setRules((List)JsonUtil.objectToJavaObject((Object)rules, List.class));
        List notShowWords = this.showFieldService.getWordsByAbility(executeContext, (List)Lists.newArrayList(), null, mainQueryDTO);
        rules = (List)JsonUtil.objectToJavaObject((Object)mainQueryDTO.getRules(), List.class);
        this.showFieldService.removeWordHiddenRule(rules);
        PcUiBotShowMetadata showMetadata = this.getRequestShowFields(apiMetadata, notShowWords);
        PcUiBotUnEditableTagUtils.analysisTag((List)showMetadata.getShowFields());
        this.createConditionPage(executeContext, showMetadata, mainQueryDTO, dynamicForm, apiMetadata, rules);
    }

    private void handleAttachActions(PcUiBotPageDefine mainQueryDTO, PcUiBotExecuteContext executeContext) {
        List attachActions = ((PcUiBotSubmitAction)mainQueryDTO.getSubmitActions().get(0)).getAttachActions();
        if (CollectionUtils.isEmpty((Collection)attachActions)) {
            return;
        }
        for (PcUiBotSubmitAction attachAction : attachActions) {
            if (StringUtils.isBlank((CharSequence)attachAction.getActionId())) continue;
            if (null == attachAction.getExtendParas()) {
                attachAction.executeExtendParas(new HashMap(), executeContext);
            }
            if (attachAction.getExtendParas().containsKey(SCHEMA_KEY)) continue;
            PcUiBotApiMetadata apiMetadata = ((QueryActionCreateService)SpringContextHolder.getBean(QueryActionCreateService.class)).getMetadata(executeContext, attachAction.getActionId());
            String schema = ((PcUiBotMetadataField)apiMetadata.getRequestFields().get(0)).getName();
            attachAction.getExtendParas().put(SCHEMA_KEY, schema);
        }
    }

    private void appendEocMetadataField(PcUiBotExecuteContext executeContext, PcUiBotPageDefine mainQueryDTO, PcUiBotApiMetadata apiMetadata) {
        Optional<Map> optional = Optional.ofNullable(mainQueryDTO.getExtendedFields()).map(extendedFields -> (Map)extendedFields.get("UIBOT__appendEocFields"));
        if (!optional.isPresent()) {
            return;
        }
        Map appendEocFields = optional.get();
        if (MapUtils.isEmpty((Map)appendEocFields)) {
            return;
        }
        Set entrySet = appendEocFields.entrySet();
        for (Map.Entry entry : entrySet) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey())) || CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            for (PcUiBotMetadataField requestField : apiMetadata.getRequestFields()) {
                if (!"object".equals(requestField.getDataType()) || !requestField.getName().equals(entry.getKey())) continue;
                List eocFields = this.createEocMetadataFields((List)entry.getValue());
                requestField.getSubFields().addAll(eocFields);
            }
        }
    }

    private List<PcUiBotMetadataField> createEocMetadataFields(List<Object> fieldObjects) {
        ArrayList<PcUiBotMetadataField> eocFields = new ArrayList<PcUiBotMetadataField>(fieldObjects.size());
        for (Object fieldObject : fieldObjects) {
            PcUiBotMetadataField metadataField = new PcUiBotMetadataField();
            try {
                metadataField = (PcUiBotMetadataField)JsonUtil.objectToJavaObject((Object)fieldObject, PcUiBotMetadataField.class);
                String description = this.parseDescriptionByLang(fieldObject);
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    metadataField.setDescription(description);
                }
                metadataField.setCanEdit(true);
            }
            catch (Exception ex) {
                log.error("[ConditionPageTemplate] create eoc field throw exception: ", (Throwable)ex);
                continue;
            }
            eocFields.add(metadataField);
        }
        return eocFields;
    }

    private String parseDescriptionByLang(Object fieldObj) {
        Map descJsonObj;
        Map langJsonObj;
        if (null == fieldObj) {
            return null;
        }
        String locale = AppRequestContext.getContextEntity().getLocale();
        Map fieldJsonObj = (Map)JsonUtil.objectToJavaObject((Object)fieldObj, Map.class);
        if (null != fieldJsonObj && fieldJsonObj.containsKey("language") && null != (langJsonObj = (Map)JsonUtil.objectToJavaObject(fieldJsonObj.get("language"), Map.class)) && langJsonObj.containsKey("description") && null != (descJsonObj = (Map)JsonUtil.objectToJavaObject(langJsonObj.get("description"), Map.class)) && !descJsonObj.isEmpty() && descJsonObj.containsKey(locale)) {
            return StringUtil.valueOf(descJsonObj.get(locale));
        }
        return null;
    }

    private void createConditionPage(PcUiBotExecuteContext executeContext, PcUiBotShowMetadata showMetadata, PcUiBotPageDefine pageDefine, UiBotModel dynamicForm, PcUiBotApiMetadata apiMetadata, List<UiBotRule> rules) {
        this.setActionOperations(executeContext, pageDefine);
        String formSchema = this.parseFormSchema(showMetadata.getShowFields());
        dynamicForm.setPageData(this.initConditionPageData(formSchema, pageDefine, apiMetadata.getRequestFields()));
    }

    private String parseFormSchema(List<PcUiBotMetadataField> showFields) {
        if (CollectionUtils.isNotEmpty(showFields)) {
            for (PcUiBotMetadataField showField : showFields) {
                if (!"object".equals(showField.getDataType()) || !showField.isArray()) continue;
                return showField.getName();
            }
            return Optional.ofNullable(showFields.get(0).getName()).orElse("");
        }
        return "";
    }

    protected UiBotPageData initConditionPageData(String submitVariableName, PcUiBotPageDefine pageDefine, List<PcUiBotMetadataField> showMetadataList) {
        Map pageData = this.initConditionPageData(showMetadataList, 1);
        UiBotPageData pageDataResult = new UiBotPageData();
        if (MapUtils.isNotEmpty((Map)pageData)) {
            for (Map.Entry entry : pageData.entrySet()) {
                pageDataResult.put(entry.getKey(), entry.getValue());
                pageDataResult.put((Object)SCHEMA_KEY, entry.getKey());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)submitVariableName)) {
            pageDataResult.put((Object)SCHEMA_KEY, (Object)submitVariableName);
        }
        this.parseConstantSubmitActionParams(pageDefine.getSubmitActions(), (Map)pageDataResult);
        return pageDataResult;
    }

    private void parseConstantSubmitActionParams(List<PcUiBotSubmitAction> submitActions, Map<String, Object> pageData) {
        if (CollectionUtils.isEmpty(submitActions) || MapUtils.isEmpty(pageData)) {
            return;
        }
        List actionParamList = submitActions.get(0).getActionParams();
        if (CollectionUtils.isEmpty((Collection)actionParamList)) {
            return;
        }
        String schema = String.valueOf(pageData.get(SCHEMA_KEY));
        Map dataSrcMap = (Map)((Object[])pageData.get(schema))[0];
        for (PcUiBotActionParameterMapping actionParamMapping : actionParamList) {
            if (!"CONSTANT".equals(actionParamMapping.getType())) continue;
            String[] namePathList = actionParamMapping.getName().split("\\.");
            int start = 1;
            if (namePathList.length <= 1) {
                start = 0;
            }
            for (int idx = start; idx < namePathList.length; ++idx) {
                this.parseConstantSubmitActionParams(dataSrcMap, namePathList, idx, actionParamMapping);
            }
        }
    }

    private void parseConstantSubmitActionParams(Map<String, Object> dataSrcMap, String[] namePathList, int idx, PcUiBotActionParameterMapping actionParamMapping) {
        String name = namePathList[idx];
        if (idx < namePathList.length - 1) {
            HashMap valueMap = (HashMap)dataSrcMap.get(name);
            if (null == valueMap) {
                valueMap = new HashMap();
            }
            this.parseConstantSubmitActionParams(valueMap, namePathList, idx++, actionParamMapping);
        } else {
            String value = this.parseValueConfig(actionParamMapping.getValue());
            dataSrcMap.put(name, value);
        }
    }

    private String parseValueConfig(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        String actualValue = PcUiBotPropertyPlaceholderUtil.HELPER.replacePlaceholders(value, (PropertyPlaceholderHelper.PlaceholderResolver)dateTimePlaceHolderResolver);
        return actualValue;
    }

    private Map<String, Object> initConditionPageData(List<PcUiBotMetadataField> showMetadataList, int level) {
        HashMap<String, Object> pageData = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(showMetadataList)) {
            return pageData;
        }
        for (PcUiBotMetadataField showField : showMetadataList) {
            Object[] objects;
            if (1 == level) {
                if (!showField.isArray()) continue;
                objects = new Object[1];
                if (showField.getDataType().equals("object")) {
                    objects[0] = this.initConditionPageData(showField.getSubFields(), level + 1);
                    pageData.put(showField.getName(), objects);
                    continue;
                }
                objects[0] = PcUiBotDefaultTagUtils.genPrimitiveTypeDefaultValue((PcUiBotMetadataField)showField);
                pageData.put(showField.getName(), objects);
                continue;
            }
            if (showField.isArray()) {
                objects = new Object[]{};
                pageData.put(showField.getName(), objects);
                continue;
            }
            if ("object".equals(showField.getDataType())) {
                pageData.put(showField.getName(), new HashMap());
                continue;
            }
            pageData.put(showField.getName(), PcUiBotDefaultTagUtils.genPrimitiveTypeDefaultValue((PcUiBotMetadataField)showField));
        }
        return pageData;
    }

    private void setActionOperations(PcUiBotExecuteContext executeContext, PcUiBotPageDefine pageDefine) {
        List operations = pageDefine.getOperations();
        if (CollectionUtils.isNotEmpty((Collection)operations)) {
            for (PcUiBotOperationDTO operation : operations) {
                operation.setRelationTag(executeContext.getRelationTag());
                operation.setPageCode(executeContext.getPageCode());
            }
        }
    }

    private void tagFieldCanEdit(List<PcUiBotMetadataField> requestFields) {
        for (PcUiBotMetadataField metadataField : requestFields) {
            metadataField.setCanEdit(true);
            if (!"object".equals(metadataField.getDataType())) continue;
            this.tagFieldCanEdit(metadataField.getSubFields());
        }
    }

    private PcUiBotShowMetadata getRequestShowFields(PcUiBotApiMetadata masterMetadata, List<String> notShowFields) {
        PcUiBotShowMetadata showMetadata = new PcUiBotShowMetadata();
        if (masterMetadata == null) {
            return showMetadata;
        }
        showMetadata.setActionId(masterMetadata.getActionId());
        showMetadata.setServiceName(masterMetadata.getServiceName());
        List requestFields = masterMetadata.getRequestFields();
        showMetadata.setShowFields(new ArrayList());
        List tagMetadata = this.showFields(requestFields, notShowFields);
        if (CollectionUtils.isNotEmpty((Collection)tagMetadata)) {
            showMetadata.getShowFields().addAll(tagMetadata);
        } else {
            showMetadata.getShowFields().addAll(requestFields);
        }
        return showMetadata;
    }

    private List<PcUiBotMetadataField> showFields(List<PcUiBotMetadataField> metadataFields, List<String> noShowFields) {
        ArrayList<PcUiBotMetadataField> showFields = new ArrayList<PcUiBotMetadataField>();
        for (PcUiBotMetadataField metadataField : metadataFields) {
            List sonTagFields;
            if ("object".equals(metadataField.getDataType()) && (CollectionUtils.isNotEmpty((Collection)(sonTagFields = this.showFields(metadataField.getSubFields(), noShowFields))) || CollectionUtils.isNotEmpty((Collection)metadataField.getTagDefinitions())) && !noShowFields.contains(metadataField.getName())) {
                PcUiBotMetadataField newMetadataField = this.createMetadataField(metadataField, sonTagFields);
                showFields.add(newMetadataField);
            }
            if (!CollectionUtils.isNotEmpty((Collection)metadataField.getTagDefinitions()) || "object".equals(metadataField.getDataType()) || noShowFields.contains(metadataField.getName())) continue;
            showFields.add(metadataField);
        }
        return showFields;
    }

    private PcUiBotMetadataField createMetadataField(PcUiBotMetadataField metadataField, List<PcUiBotMetadataField> sonTagFields) {
        PcUiBotMetadataField newMetadataField = new PcUiBotMetadataField();
        newMetadataField.setDataType(metadataField.getDataType());
        newMetadataField.setDataKey(metadataField.getDataKey());
        newMetadataField.setRemark(metadataField.getRemark());
        newMetadataField.setDescription(metadataField.getDescription());
        newMetadataField.setRequired(metadataField.isRequired());
        newMetadataField.setName(metadataField.getName());
        newMetadataField.setArray(metadataField.isArray());
        newMetadataField.setCanEdit(metadataField.isCanEdit());
        newMetadataField.setTagDefinitions(metadataField.getTagDefinitions());
        newMetadataField.setFieldType(metadataField.getFieldType());
        newMetadataField.setSubFields(sonTagFields);
        return newMetadataField;
    }

    private PcUiBotTaggingData getMetadataTags(PcUiBotPageDefine mainQueryDTO, PcUiBotExecuteContext executeContext, String actionId) {
        return null;
    }

    public UiBotModel createTaskPage(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, PcUiBotPageDefine mainAction, List<PcUiBotPageDefine> pageDefines) {
        UiBotModel uiBotModel = super.createTaskPage(apiRequest, executeContext, mainAction, pageDefines);
        if (ObjectUtils.isEmpty((Object)uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        uiBotModel.setRawUiBotPageData((UiBotPageData)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData(), UiBotPageData.class));
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext((UiBotExecuteContext)JsonUtil.objectToJavaObject((Object)executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.isNotBlank((CharSequence)uiBotModel.getPageBackgroudColor()) ? uiBotModel.getPageBackgroudColor() : BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }
}

