/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionVariable;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotSubmitAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.QueryResultSet;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

public class PcUiBotBuilderUtils {
    private static final String UIBOT_VARIABLES = "uiBot__variables";

    public static void BuildVariables(UiBotModel dynamicForm) {
        ArrayList<PcUiBotActionVariable> variables = new ArrayList<PcUiBotActionVariable>();
        List actions = (List)JsonUtil.objectToJavaObject((Object)dynamicForm.getActions(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtils.isEmpty((Collection)actions)) {
            return;
        }
        for (PcUiBotSubmitAction action : actions) {
            if (CollectionUtils.isEmpty((Collection)action.getActionParams())) continue;
            for (PcUiBotActionParameterMapping actionParam : action.getActionParams()) {
                if (!"CONSTANT".equals(actionParam.getType())) continue;
                PcUiBotActionVariable actionVariable = PcUiBotActionVariable.builder().variableKey(actionParam.getName()).variableValue((Object)actionParam.getValue()).build();
                actionVariable.setVariableType(actionParam.getValueType());
                variables.add(actionVariable);
            }
        }
        List pageDataVariables = (List)dynamicForm.getPageData().get((Object)UIBOT_VARIABLES);
        if (CollectionUtils.isEmpty(variables)) {
            return;
        }
        if (pageDataVariables == null) {
            dynamicForm.getPageData().put((Object)UIBOT_VARIABLES, variables);
        } else {
            List existVariableKeys = pageDataVariables.stream().map(PcUiBotActionVariable::getVariableKey).collect(Collectors.toList());
            variables.forEach(variable -> {
                if (!existVariableKeys.contains(variable.getVariableKey())) {
                    pageDataVariables.add(variable);
                }
            });
        }
    }

    public static void setTotalResultsDefault(PcUiBotPageDefine pageDefine, QueryResultSet queryResultSet) {
        if (BooleanUtils.isTrue((Boolean)pageDefine.getUseHasNext()) && Objects.isNull(queryResultSet.getMainQueryResult().getTotalResults())) {
            queryResultSet.getMainQueryResult().setTotalResults(Integer.valueOf(0));
        }
    }
}

