/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequestPosition;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeDistrict;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.sign.InputSign;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.standardentry.InputStandardEntryColumn;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsData;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.file.FileService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogSubmitResult;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspStdData;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkZTBSubmitHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ZhilinkZTBSubmitHandler {
    private static final Logger log = LoggerFactory.getLogger(ZhilinkZTBSubmitHandler.class);
    public static final String SUCCESS_CODE = "200";
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private ComponentParamAnalyzerFactory componentParamAnalyzerFactory;
    @Autowired
    private FileService fileService;
    private static final Logger logger = LoggerFactory.getLogger(ZhilinkZTBSubmitHandler.class);

    public ActionSubmitResult submit(ApiRequestSubmit apiRequest) {
        ApiRawData rawData = apiRequest.getRawData();
        String pageId = (String)rawData.get((Object)"page_id");
        String actionId1 = (String)rawData.get((Object)"action_id");
        log.debug("pageId:" + pageId);
        log.debug("actionId:" + actionId1);
        String taskNo = (String)rawData.get((Object)"task_no");
        String transportNo = (String)rawData.get((Object)"transport_no");
        if (!StringUtils.hasLength((String)pageId)) {
            return ActionSubmitResult.create((boolean)false, (String)(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6570\u636e\u9884\u5904\u7406\u5f02\u5e38") + "," + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u63d0\u4ea4\u4e2d\u6b62")));
        }
        ApiRequestPosition position = apiRequest.getPosition();
        String actionId = (String)rawData.get((Object)"action_id");
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$core$pagesetting$PageSettingIdPresetEnum[PageSettingIdPresetEnum.getEnumByName((String)pageId).ordinal()]) {
            case 1: {
                return this.shippingNextStep(taskNo, apiRequest);
            }
            case 2: {
                return this.shippingSubmit(taskNo, apiRequest);
            }
            case 3: {
                return this.scanReceiveOrderSubmit(taskNo, apiRequest);
            }
            case 4: {
                return this.goodsLoadingSubmit(taskNo, apiRequest);
            }
            case 5: {
                return this.goodsLoadingVehicleInfoSubmit(taskNo, apiRequest);
            }
            case 6: {
                HashMap<String, Object> params = new HashMap<String, Object>(4);
                params.put("transport_no", transportNo);
                if (position != null) {
                    params.put("province", position.getProvince());
                    params.put("city", position.getCity());
                    params.put("area", position.getArea());
                    params.put("complete_address", position.getCompleteAddress());
                    params.put("detail_address", position.getDetailAddress());
                    params.put("longitude", position.getLongitude());
                    params.put("latitude", position.getLatitude());
                    params.put("address", position.getCompleteAddress());
                }
                return this.goodsDepartureSubmit(params, apiRequest);
            }
            case 7: {
                return this.transport(taskNo, transportNo, actionId, apiRequest);
            }
            case 8: {
                return this.transportVehicleInfo(transportNo, actionId, apiRequest);
            }
            case 9: {
                return this.tansportAlarm(transportNo, apiRequest);
            }
            case 10: {
                return this.modificationReceiptSchedule(apiRequest);
            }
            case 11: {
                return this.receiptPreparation(transportNo, apiRequest);
            }
            case 12: {
                return this.transportComingSoon(transportNo, apiRequest);
            }
            case 13: {
                return this.confirmationReceiptPreparation(transportNo, apiRequest);
            }
            case 14: 
            case 15: {
                return this.receiptConfirmation(transportNo, apiRequest);
            }
            case 16: {
                if ("manual_freightage_start".equalsIgnoreCase((String)rawData.get((Object)"dataId"))) {
                    return this.projectCreateManualFreightageStart(apiRequest);
                }
                if ("scan_freightage_start".equalsIgnoreCase(rawData.getString("dataId"))) {
                    return this.projectCreateScanFreightageStart(apiRequest);
                }
                return this.projectCreateReceiptScheduleChange(apiRequest);
            }
            case 17: {
                return this.modifiyAddress(apiRequest);
            }
            case 18: {
                String addressId = rawData.getString("address_id");
                return this.deleteAddress(addressId, apiRequest);
            }
            case 19: 
            case 20: {
                return this.receiptSignature(transportNo, apiRequest);
            }
            case 21: 
            case 22: {
                return this.processAlarmMsg(transportNo, actionId, apiRequest);
            }
            case 23: {
                this.commitAlarm(transportNo, apiRequest);
                return this.pcUiBotSubmit(apiRequest);
            }
            case 24: {
                return this.pcUiBotSubmit(apiRequest);
            }
        }
        return ActionSubmitResult.create((boolean)false, (String)(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6570\u636e\u9884\u5904\u7406\u5f02\u5e38") + "," + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u63d0\u4ea4\u4e2d\u6b62")));
    }

    private void commitAlarm(String transportNo, ApiRequestSubmit apiRequest) {
        HashMap<String, Object> rawData = new HashMap<String, Object>(4);
        rawData.put("transport_no", transportNo);
        List submitParams = apiRequest.getSubmitParams();
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            switch (submitParam.getType()) {
                case "SINGLE_SELECT_LIST": {
                    SingleSelectList singleSelect = (SingleSelectList)submitParam.getParams();
                    rawData.put(schema, singleSelect.getSelectId());
                    break;
                }
                case "INPUT_MULTI": {
                    InputMultiText text = (InputMultiText)submitParam.getParams();
                    rawData.put(schema, text.getText());
                    break;
                }
                case "PICTURE": {
                    Picture picture = (Picture)submitParam.getParams();
                    List fileList = picture.getFileList();
                    ArrayList<String> pics = new ArrayList<String>(3);
                    if (!CollectionUtils.isEmpty((Collection)fileList)) {
                        for (AttachmentFile file : fileList) {
                            pics.add(file.getFileId());
                        }
                    }
                    rawData.put(schema, pics);
                }
            }
        }
        ApiRequestPosition position = apiRequest.getPosition();
        if (position != null) {
            rawData.put("province", position.getProvince());
            rawData.put("city", position.getCity());
            rawData.put("area", position.getArea());
            rawData.put("complete_address", position.getCompleteAddress());
            rawData.put("detail_address", position.getDetailAddress());
            rawData.put("longitude", position.getLongitude());
            rawData.put("latitude", position.getLatitude());
            rawData.put("address", position.getCompleteAddress());
        }
        this.digiwinEspProxyService.transportAbnormalAlarmProcess(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), rawData);
    }

    private ActionSubmitResult projectCreateScanFreightageStart(ApiRequestSubmit apiRequest) {
        Map rawData = (Map)apiRequest.getRawData().get((Object)"data");
        return this.returnSubmit(this.digiwinEspProxyService.deliveryHeadInfoSubmit(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale());
    }

    private ActionSubmitResult receiptSignature(String transportNo, ApiRequestSubmit apiRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("transport_no", transportNo);
        for (ActionSubmitParam submitParam : apiRequest.getSubmitParams()) {
            switch (submitParam.getType()) {
                case "PICTURE": {
                    Picture picture = (Picture)submitParam.getParams();
                    List fileList = picture.getFileList();
                    ArrayList<String> pics = new ArrayList<String>(3);
                    if (!CollectionUtils.isEmpty((Collection)fileList)) {
                        for (AttachmentFile file : fileList) {
                            pics.add(file.getFileId());
                        }
                    }
                    params.put(submitParam.getSchema(), pics);
                    break;
                }
                case "INPUT_SIGN": {
                    InputSign inputSign = (InputSign)submitParam.getParams();
                    String signData = inputSign.getSignData();
                    Map result = this.fileService.uploadFile(signData, "srm-loading", "driver_vehicle_img", true, apiRequest.getIamUserToken(), apiRequest.getTenantId());
                    log.debug(JSONUtil.toJsonStr((Object)result));
                    if (!SUCCESS_CODE.equals(result.get("code"))) {
                        log.error("\u4e0a\u4f20\u56fe\u7247\u5931\u8d25" + result.get("message"));
                        return this.returnSubmit(Boolean.valueOf(false), apiRequest.getLocale());
                    }
                    Object fileId = result.get("fileId");
                    ArrayList<String> signFileIds = new ArrayList<String>();
                    signFileIds.add(StrUtil.toString(fileId));
                    params.put(submitParam.getSchema(), signFileIds);
                    break;
                }
            }
        }
        if (this.digiwinEspProxyService.transportPaperReceiptSubmit(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params).booleanValue()) {
            return this.pcUiBotSubmit(apiRequest);
        }
        return this.returnSubmit(Boolean.valueOf(false), apiRequest.getLocale());
    }

    private ActionSubmitResult projectCreateManualFreightageStart(ApiRequestSubmit apiRequest) {
        HashMap<String, Object> rawData = new HashMap<String, Object>();
        List submitParams = apiRequest.getSubmitParams();
        block10: for (ActionSubmitParam submitParam : submitParams) {
            switch (submitParam.getType()) {
                case "LOGISTICS": {
                    List logisticsDataList = ModuleUtils.listMapToListObject((List)((List)submitParam.getParams()), LogisticsData.class);
                    for (LogisticsData data : logisticsDataList) {
                        if (LogisticsEnum.SEND.getValue().equals(data.getType())) {
                            rawData.put("delivery_address_id", data.getId());
                            continue;
                        }
                        if (!LogisticsEnum.RECEIVER.getValue().equals(data.getType())) continue;
                        rawData.put("receipt_address_id", data.getId());
                    }
                    continue block10;
                }
                case "INPUT_DATETIME_PICKER": {
                    InputDateTimePicker inputDateTimePicker = (InputDateTimePicker)submitParam.getParams();
                    InputDateTime inputDateTime = inputDateTimePicker.getDatetimeValue();
                    rawData.put(submitParam.getSchema(), InputDateTime.getDateTypeDateStringByType((InputDateTime)inputDateTime, (Integer)InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType()));
                    break;
                }
                case "ZTB_CARGO_INFO_ENTRY": {
                    List deliveryDetails;
                    List columns = ModuleUtils.listMapToListObject((List)((List)submitParam.getParams()), InputStandardEntryColumn.class);
                    if (!CollectionUtils.isEmpty((Collection)columns)) {
                        deliveryDetails = new ArrayList(columns.size());
                        for (InputStandardEntryColumn column : columns) {
                            HashMap<String, String> deliveryDetail = new HashMap<String, String>(4);
                            for (CardContent content : column.getColumn()) {
                                deliveryDetail.put(content.getSchema(), content.getValue());
                                if (!"PRICE".equalsIgnoreCase(content.getType())) continue;
                                deliveryDetail.put("unit_no", content.getUnitName());
                            }
                            deliveryDetails.add(deliveryDetail);
                        }
                    } else {
                        deliveryDetails = Collections.emptyList();
                    }
                    rawData.put(submitParam.getSchema(), deliveryDetails);
                    break;
                }
            }
        }
        return this.returnSubmit(this.digiwinEspProxyService.deliveryStartManualSubmit(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale());
    }

    private ActionSubmitResult modifiyAddress(ApiRequestSubmit apiRequest) {
        HashMap<String, Object> rawData = new HashMap<String, Object>(5);
        Boolean isAdd = apiRequest.getRawData().getBooleanValue("isAdd");
        List submitParams = apiRequest.getSubmitParams();
        StringBuffer completeAddress = new StringBuffer();
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object analyzedParam = this.componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(submitParam.getParams());
            switch (submitParam.getType()) {
                case "INPUT_SINGLE": {
                    rawData.put(schema, analyzedParam);
                    break;
                }
                case "INPUT_MULTI": {
                    completeAddress = completeAddress.append(" ").append(analyzedParam);
                    rawData.put(schema, analyzedParam);
                    break;
                }
                case "INPUT_CASCADE_DISTRICT": {
                    InputCascadeDistrict district = (InputCascadeDistrict)submitParam.getParams();
                    completeAddress = completeAddress.append(district.getProvince()).append(" ").append(district.getCity()).append(" ").append(district.getArea());
                    rawData.put(schema, analyzedParam);
                    break;
                }
            }
        }
        rawData.put("complete_address", completeAddress);
        if (isAdd.booleanValue()) {
            return this.returnSubmit(this.digiwinEspProxyService.createUserAddress(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale());
        }
        return this.returnSubmit(this.digiwinEspProxyService.updateUserAddress(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale());
    }

    private ActionSubmitResult deleteAddress(String addressId, ApiRequestSubmit apiRequest) {
        return this.returnSubmit(this.digiwinEspProxyService.deleteUserAddress(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), addressId), apiRequest.getLocale());
    }

    private ActionSubmitResult projectCreateReceiptScheduleChange(ApiRequestSubmit apiRequest) {
        HashMap<String, Object> rawData = new HashMap<String, Object>();
        List submitParams = apiRequest.getSubmitParams();
        for (ActionSubmitParam submitParam : submitParams) {
            switch (submitParam.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect)submitParam.getParams();
                    Map detail = inputWindowSingleSelect.getDetail();
                    rawData.put("data", detail);
                    break;
                }
            }
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_RECEIPT_SCHEDULE_CHANGE.toString());
        action.setJumpPageTitle(this.localeService.getLanguageValue(apiRequest.getLocale(), "\u6536\u8d27\u6392\u7a0b\u66f4\u6539"));
        rawData.put("pcUibotModel", apiRequest.getRawData().get((Object)"pcUibotModel"));
        action.setRawData(rawData);
        return ActionSubmitResult.create((boolean)true, (Action)action);
    }

    private ActionSubmitResult modificationReceiptSchedule(ApiRequestSubmit apiRequest) {
        Boolean isCancel = (Boolean)apiRequest.getRawData().get((Object)"isCancel");
        ApiRawData rawData = apiRequest.getRawData();
        String transportNo = (String)rawData.get((Object)"transport_no");
        List submitParams = apiRequest.getSubmitParams();
        HashMap<String, Object> params = new HashMap<String, Object>(9);
        params.put("transport_no", transportNo);
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            Object analyzedParam = this.componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(paramObj);
            switch (submitParam.getType()) {
                case "SINGLE_SELECT_LIST": {
                    SingleSelectList selectList = (SingleSelectList)paramObj;
                    if (SingleSelectTypeEnum.SINGLE_SELECT.getValue().equals(selectList.getType())) {
                        if ("plan_unload_time".equalsIgnoreCase(schema)) {
                            params.put(schema, selectList.getText());
                            break;
                        }
                        params.put(schema, analyzedParam);
                        break;
                    }
                    List selectIds = selectList.getSelectIdList();
                    ArrayList timeSolts = new ArrayList(selectIds.size());
                    for (String selectId : selectIds) {
                        HashMap<String, String> timeSolt = new HashMap<String, String>(2);
                        String[] splits = selectId.split("~");
                        timeSolt.put("appointment_delivery_time_start", splits[0]);
                        timeSolt.put("appointment_delivery_time_end", splits[1]);
                        timeSolts.add(timeSolt);
                    }
                    params.put(schema, timeSolts);
                    break;
                }
                case "WINDOW_SINGLE_SELECT": 
                case "INPUT_SINGLE": {
                    InputWindowSingleSelect inputWindowSingleSelect;
                    if ("unloader_name".equalsIgnoreCase(schema)) {
                        inputWindowSingleSelect = (InputWindowSingleSelect)paramObj;
                        inputWindowSingleSelect.getSelectId();
                        params.put("unloader_id", ((InputWindowSingleSelect)paramObj).getSelectId());
                    } else if ("platform_no".equalsIgnoreCase(schema)) {
                        inputWindowSingleSelect = (InputWindowSingleSelect)paramObj;
                        Map detail = inputWindowSingleSelect.getDetail();
                        params.put(schema, detail.get(schema));
                        params.put("platform_name", detail.get("platform_name"));
                    }
                    params.put(schema, analyzedParam);
                    break;
                }
            }
        }
        if (isCancel.booleanValue()) {
            return this.pcUiBotSubmit(apiRequest);
        }
        return this.resultSubimtInPcUibotSubmit(this.digiwinEspProxyService.scheduleInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params), apiRequest);
    }

    private ActionSubmitResult receiptConfirmation(String transportNo, ApiRequestSubmit apiRequest) {
        Action action;
        ActionSubmitResult result;
        List submitParams = apiRequest.getSubmitParams();
        if (apiRequest.getRawData().get((Object)"submitParams") != null) {
            submitParams.addAll(ModuleUtils.listMapToListObject((List)((List)apiRequest.getRawData().get((Object)"submitParams")), ActionSubmitParam.class));
        }
        Boolean hasReject = false;
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            Object analyzedParam = new Object();
            if (!submitParam.getType().equalsIgnoreCase("PICTURE") && !submitParam.getType().equalsIgnoreCase("MULTI_FUNCTION_LIST")) {
                analyzedParam = this.componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(paramObj);
            }
            switch (submitParam.getType()) {
                case "MULTI_FUNCTION_LIST": {
                    MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)submitParam.getParams(), MultiFunctionList.class);
                    List mapList = multiFunctionList.getSelectDetailList();
                    if (!CollectionUtils.isEmpty((Collection)mapList)) {
                        mapList.forEach(map -> map.put("receipt_qty", map.get("ztb_mobile_number")));
                    }
                    params.put("receipt_list", mapList);
                    break;
                }
                case "INPUT_MULTI": {
                    hasReject = true;
                    params.put(schema, analyzedParam);
                    break;
                }
                case "SINGLE_SELECT_LIST": {
                    params.put(schema, analyzedParam);
                    break;
                }
                case "PICTURE": {
                    Picture picture = (Picture)submitParam.getParams();
                    List fileList = picture.getFileList();
                    ArrayList<String> pics = new ArrayList<String>(3);
                    if (!CollectionUtils.isEmpty((Collection)fileList)) {
                        for (AttachmentFile file : fileList) {
                            pics.add(file.getFileId());
                        }
                    }
                    params.put(schema, pics);
                    break;
                }
            }
        }
        params.put("transport_no", transportNo);
        params.put("is_rejected", hasReject);
        DigiwinEspStdData data = this.digiwinEspProxyService.confirmCargoReceiptInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
        if (!"0".equals(data.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("cargo.arrival.info.process \u8fd4\u56de code " + data.getExecution().getCode() + ":" + data.getExecution().getDescription()));
        }
        if (data.getParameter().get("is_receipt_completed") != null && ((Boolean)data.getParameter().get("is_receipt_completed")).booleanValue()) {
            Action action2;
            ActionSubmitResult result2;
            if (hasReject.booleanValue()) {
                result2 = this.pcUiBotSubmit(apiRequest, this.localeService.getLanguageValue(apiRequest.getLocale(), "\u8d27\u7269\u5df2\u62d2\u6536"));
                action2 = result2.getAction();
                if (action2 == null) {
                    action2 = new Action();
                }
                action2.setType(ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
                return result2;
            }
            result2 = this.pcUiBotSubmit(apiRequest, this.localeService.getLanguageValue(apiRequest.getLocale(), "\u8d27\u7269\u5df2\u7b7e\u6536"));
            action2 = result2.getAction();
            if (action2 == null) {
                action2 = new Action();
            }
            action2.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            return result2;
        }
        HashMap<String, Boolean> rawData = new HashMap<String, Boolean>(1);
        rawData.put("hasReject", hasReject);
        if (hasReject.booleanValue()) {
            result = this.returnSubmit(Boolean.valueOf(true), apiRequest.getLocale(), "\u8d27\u7269\u5df2\u62d2\u6536");
            action = result.getAction();
            if (action == null) {
                action = new Action();
            }
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_RECEIPT_CONFIRMATION.toString());
            action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
            action.setRawData(rawData);
            return result;
        }
        result = this.returnSubmit(Boolean.valueOf(true), apiRequest.getLocale(), "\u8d27\u7269\u5df2\u7b7e\u6536");
        action = result.getAction();
        if (action == null) {
            action = new Action();
        }
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_RECEIPT_CONFIRMATION.toString());
        action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
        action.setRawData(rawData);
        return result;
    }

    private ActionSubmitResult receiptPreparation(String transportNo, ApiRequestSubmit apiRequest) {
        List submitParams = apiRequest.getSubmitParams();
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            Object analyzedParam = new Object();
            if (!"ATTACHMENT".equals(submitParam.getType())) {
                analyzedParam = this.componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(paramObj);
            }
            switch (submitParam.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect)paramObj;
                    params.put("unloader_id", inputWindowSingleSelect.getSelectId());
                    params.put("unloader_name", inputWindowSingleSelect.getTitle());
                    break;
                }
                case "INPUT_SINGLE": 
                case "SINGLE_SELECT_LIST": {
                    params.put(schema, analyzedParam);
                    break;
                }
            }
        }
        return this.resultSubimtInPcUibotSubmit(this.digiwinEspProxyService.receiptPreparationInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), transportNo, params), apiRequest);
    }

    private ActionSubmitResult transportComingSoon(String transportNo, ApiRequestSubmit apiRequest) {
        List submitParams = apiRequest.getSubmitParams();
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            Object analyzedParam = new Object();
            if (!"ATTACHMENT".equals(submitParam.getType())) {
                analyzedParam = this.componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(paramObj);
            }
            switch (submitParam.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect)paramObj;
                    params.put("unloader_id", inputWindowSingleSelect.getSelectId());
                    params.put("unloader_name", inputWindowSingleSelect.getTitle());
                    break;
                }
                case "INPUT_DATETIME_PICKER": {
                    InputDateTimePicker inputDateTimePicker = (InputDateTimePicker)paramObj;
                    InputDateTime inputDateTime = inputDateTimePicker.getDatetimeValue();
                    params.put(submitParam.getSchema(), InputDateTime.getDateTypeDateStringByType((InputDateTime)inputDateTime, (Integer)InputDateTimePickerTypeEnum.HOUR_MINUTE.getType()));
                    break;
                }
                case "INPUT_SINGLE": 
                case "INPUT_NUMERIC": {
                    params.put(schema, analyzedParam);
                    break;
                }
            }
        }
        return this.resultSubimtInPcUibotSubmit(this.digiwinEspProxyService.transportComingSoonProcess(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), transportNo, params), apiRequest);
    }

    private ActionSubmitResult confirmationReceiptPreparation(String transportNo, ApiRequestSubmit apiRequest) {
        return this.resultSubimtInPcUibotSubmit(this.digiwinEspProxyService.completeReceiptPreparationInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), transportNo), apiRequest);
    }

    private ActionSubmitResult transport(String taskNo, String transportNo, String actionId, ApiRequestSubmit apiRequest) {
        if (!StringUtils.hasLength((String)actionId)) {
            return ActionSubmitResult.create((boolean)false, (String)(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6570\u636e\u9884\u5904\u7406\u5f02\u5e38") + "," + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u63d0\u4ea4\u4e2d\u6b62")));
        }
        if ("transfer".equalsIgnoreCase(actionId)) {
            return this.transportTransfer(transportNo, apiRequest);
        }
        if ("abnormal".equalsIgnoreCase(actionId)) {
            return this.transportAbnormal(transportNo, apiRequest);
        }
        if ("transport_arrival".equalsIgnoreCase(actionId)) {
            return this.transportValidArrival(taskNo, transportNo, apiRequest);
        }
        if ("arrive_scan".equalsIgnoreCase(actionId) || "arrive_online".equalsIgnoreCase(actionId) || "arrive_offline".equalsIgnoreCase(actionId)) {
            return this.transportArrive(actionId, transportNo, apiRequest);
        }
        return ActionSubmitResult.create((boolean)false, (String)(LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u6570\u636e\u9884\u5904\u7406\u5f02\u5e38") + "," + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u63d0\u4ea4\u4e2d\u6b62")));
    }

    private ActionSubmitResult transportArrive(String actionId, String transportNo, ApiRequestSubmit apiRequest) {
        String receiverName = ObjectUtil.isEmpty((Object)apiRequest.getRawData().get((Object)"receiver_name")) ? "" : StrUtil.toString((Object)apiRequest.getRawData().get((Object)"receiver_name"));
        String receiverMobile = ObjectUtil.isEmpty((Object)apiRequest.getRawData().get((Object)"receiver_mobile")) ? "" : StrUtil.toString((Object)apiRequest.getRawData().get((Object)"receiver_mobile"));
        DigiwinEspStdData digiwinEspStdData = this.digiwinEspProxyService.cargoArrival(actionId, apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), transportNo, receiverName, receiverMobile, apiRequest.getPosition());
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("cargo.arrival.info.process \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        HashMap<String, List> dataMap = (HashMap<String, List>)apiRequest.getRawData().get((Object)"data");
        HashMap<String, String> carInfo = new HashMap<String, String>(1);
        if (CollectionUtils.isEmpty((Map)dataMap)) {
            dataMap = new HashMap<String, List>(1);
            if ("arrive_scan".equalsIgnoreCase(actionId) || "arrive_online".equalsIgnoreCase(actionId)) {
                carInfo.put("submit_type", "1");
            } else if ("arrive_offline".equalsIgnoreCase(actionId)) {
                carInfo.put("submit_type", "3");
            }
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(1);
            list.add(carInfo);
            dataMap.put("cargo_information", list);
        } else {
            List cargoInformations = (List)dataMap.get("cargo_information");
            for (Map cargoInformation : cargoInformations) {
                if ("arrive_scan".equalsIgnoreCase(actionId) || "arrive_online".equalsIgnoreCase(actionId)) {
                    cargoInformation.put("submit_type", "1");
                    continue;
                }
                if (!"arrive_offline".equalsIgnoreCase(actionId)) continue;
                cargoInformation.put("submit_type", "3");
            }
            dataMap.put("cargo_information", cargoInformations);
        }
        apiRequest.getRawData().put("data", dataMap);
        return this.pcUiBotSubmit(apiRequest, this.localeService.getLanguageValue(apiRequest.getLocale(), "\u5df2\u5230\u8fbe\u76ee\u7684\u5730"));
    }

    private ActionSubmitResult transportVehicleInfo(String transportNo, String actionId, ApiRequestSubmit apiRequest) {
        DigiwinEspStdData digiwinEspStdData;
        ApiRawData apiRawData = apiRequest.getRawData();
        String vehicleInfoId = String.valueOf(apiRawData.get((Object)"vehicle_info_id"));
        ApiRequestPosition position = apiRequest.getPosition();
        String msgType = "3";
        if (StrUtil.equalsAny((CharSequence)actionId, (CharSequence[])new CharSequence[]{"stop", "shifting"})) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("transport_no", transportNo);
            params.put("vehicle_info_id", vehicleInfoId);
            params.put("msg_type", msgType);
            digiwinEspStdData = this.digiwinEspProxyService.commitDriverMsg(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params, position);
        } else {
            digiwinEspStdData = this.digiwinEspProxyService.oldDriverProcess(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), transportNo, vehicleInfoId, position);
        }
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("old.driver.transport.twist.info.process \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        HashMap<String, List> dataMap = (HashMap<String, List>)apiRequest.getRawData().get((Object)"data");
        HashMap<String, String> carInfo = new HashMap<String, String>(1);
        if (CollectionUtils.isEmpty((Map)dataMap)) {
            dataMap = new HashMap<String, List>(1);
            carInfo.put("submit_type", "2");
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(1);
            list.add(carInfo);
            dataMap.put("cargo_information", list);
        } else {
            List cargoInformations = (List)dataMap.get("cargo_information");
            for (Map cargoInformation : cargoInformations) {
                cargoInformation.put("submit_type", "2");
            }
            dataMap.put("cargo_information", cargoInformations);
        }
        apiRequest.getRawData().put("data", dataMap);
        return this.pcUiBotSubmit(apiRequest, this.localeService.getLanguageValue(apiRequest.getLocale(), "\u8f6c\u8fd0\u6210\u529f"));
    }

    private ActionSubmitResult processAlarmMsg(String transportNo, String actionId, ApiRequestSubmit apiRequest) {
        ApiRawData apiRawData = apiRequest.getRawData();
        String buttonActionId = (String)apiRawData.get((Object)"button_action_id");
        HashMap<String, Object> params = new HashMap<String, Object>();
        String msgType = StrUtil.equals((CharSequence)actionId, (CharSequence)"stop") ? "3" : "2";
        List submitParams = apiRequest.getSubmitParams();
        String licensePlateNo = "";
        if (ObjectUtil.isNotEmpty((Object)submitParams) && submitParams.size() > 0 && StrUtil.equals((CharSequence)buttonActionId, (CharSequence)"confirm")) {
            for (ActionSubmitParam submitParam : submitParams) {
                String schema = submitParam.getSchema();
                Object paramObj = submitParam.getParams();
                ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(submitParam.getType());
                if (null == componentParamAnalyzer) {
                    logger.error("\u5f53\u524d\u63d0\u4ea4\u53c2\u6570\u6ca1\u6709\u5bf9\u5e94\u53c2\u6570\u89e3\u6790\u5668\uff0c\u8bf7\u6ce8\u610f\u662f\u5426\u4f1a\u6709\u540e\u7eed\u53c2\u6570\u5f02\u5e38\uff01\u5f53\u524dschema\u662f\uff1a{}\uff0c\u53c2\u6570\u662f\uff1a{}", (Object)schema, (Object)JsonUtil.javaObjectToJsonString((Object)paramObj));
                    continue;
                }
                Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                block5 : switch (submitParam.getType()) {
                    case "INPUT_SINGLE": {
                        switch (schema) {
                            case "licensePlateNo": {
                                params.put("license_plate_no", analyzedParam);
                                licensePlateNo = ObjectUtil.isEmpty((Object)analyzedParam) ? "" : StrUtil.toString((Object)analyzedParam);
                                break block5;
                            }
                            case "driverPhone": {
                                params.put("driver_phone", analyzedParam);
                                break block5;
                            }
                        }
                        break;
                    }
                    case "INPUT_MULTI": {
                        if (!StrUtil.equals((CharSequence)schema, (CharSequence)"remark") || !ObjectUtil.isNotEmpty((Object)analyzedParam)) break;
                        if (StrUtil.equals((CharSequence)msgType, (CharSequence)"3")) {
                            params.put("stop_reason", analyzedParam);
                            break;
                        }
                        params.put("shifting_reason", analyzedParam);
                        break;
                    }
                    case "BUTTON_SINGLE_SELECT": {
                        String value;
                        String string = value = ObjectUtil.isEmpty((Object)analyzedParam) ? "" : StrUtil.toString((Object)analyzedParam);
                        if (!StrUtil.equals((CharSequence)msgType, (CharSequence)"3")) break;
                        switch (value) {
                            case "0": {
                                params.put("stop_reason", "\u4f11\u606f");
                                break block5;
                            }
                            case "1": {
                                params.put("stop_reason", "\u8f66\u8f86\u7ef4\u4fee");
                                break block5;
                            }
                        }
                        break;
                    }
                }
            }
        }
        params.put("transport_no", transportNo);
        params.put("msg_type", msgType);
        ApiRequestPosition position = apiRequest.getPosition();
        DigiwinEspStdData digiwinEspStdData = this.digiwinEspProxyService.commitDriverMsg(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params, position);
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("transport.driver.msg.process \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        if (StrUtil.isNotBlank((CharSequence)licensePlateNo)) {
            HashMap<String, List> dataMap = (HashMap<String, List>)apiRequest.getRawData().get((Object)"data");
            HashMap<String, String> carInfo = new HashMap<String, String>(1);
            if (CollectionUtils.isEmpty((Map)dataMap)) {
                dataMap = new HashMap<String, List>(1);
                carInfo.put("submit_type", "2");
                ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(1);
                list.add(carInfo);
                dataMap.put("cargo_information", list);
            } else {
                List cargoInformations = (List)dataMap.get("cargo_information");
                for (Map cargoInformation : cargoInformations) {
                    cargoInformation.put("submit_type", "2");
                }
                dataMap.put("cargo_information", cargoInformations);
            }
            apiRequest.getRawData().put("data", dataMap);
            return this.pcUiBotSubmit(apiRequest, this.localeService.getLanguageValue(apiRequest.getLocale(), "\u8f6c\u8fd0\u6210\u529f"));
        }
        return ActionSubmitResult.create((boolean)true, (String)"\u63d0\u4ea4\u6210\u529f");
    }

    private ActionSubmitResult tansportAlarm(String transportNo, ApiRequestSubmit apiRequest) {
        HashMap<String, Object> rawData = new HashMap<String, Object>(4);
        rawData.put("transport_no", transportNo);
        List submitParams = apiRequest.getSubmitParams();
        for (ActionSubmitParam submitParam : submitParams) {
            String schema = submitParam.getSchema();
            switch (submitParam.getType()) {
                case "SINGLE_SELECT_LIST": {
                    SingleSelectList singleSelect = (SingleSelectList)submitParam.getParams();
                    rawData.put(schema, singleSelect.getSelectId());
                    break;
                }
                case "INPUT_MULTI": {
                    InputMultiText text = (InputMultiText)submitParam.getParams();
                    rawData.put(schema, text.getText());
                    break;
                }
                case "PICTURE": {
                    Picture picture = (Picture)submitParam.getParams();
                    List fileList = picture.getFileList();
                    ArrayList<String> pics = new ArrayList<String>(3);
                    if (!CollectionUtils.isEmpty((Collection)fileList)) {
                        for (AttachmentFile file : fileList) {
                            pics.add(file.getFileId());
                        }
                    }
                    rawData.put(schema, pics);
                }
            }
        }
        ApiRequestPosition position = apiRequest.getPosition();
        if (position != null) {
            rawData.put("province", position.getProvince());
            rawData.put("city", position.getCity());
            rawData.put("area", position.getArea());
            rawData.put("complete_address", position.getCompleteAddress());
            rawData.put("detail_address", position.getDetailAddress());
            rawData.put("longitude", position.getLongitude());
            rawData.put("latitude", position.getLatitude());
            rawData.put("address", position.getCompleteAddress());
        }
        return this.returnSubmit(this.digiwinEspProxyService.transportAbnormalAlarmProcess(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), rawData), apiRequest.getLocale(), this.localeService.getLanguageValue(apiRequest.getLocale(), "\u5f02\u5e38\u62a5\u8b66\u6210\u529f"));
    }

    private ActionSubmitResult resultSubimtInPcUibotSubmit(DigiwinEspStdData digiwinEspStdData, ApiRequestSubmit apiRequest) {
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("cargo.arrival.info.process \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        return this.pcUiBotSubmit(apiRequest);
    }

    private ActionSubmitResult transportAbnormal(String transportNo, ApiRequestSubmit apiRequest) {
        DigiwinEspStdData digiwinEspStdData = this.digiwinEspProxyService.abnormalAlertCheck(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), transportNo);
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("abnormal.alert.check \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        HashMap<String, List> dataMap = (HashMap<String, List>)apiRequest.getRawData().get((Object)"data");
        HashMap<String, String> carInfo = new HashMap<String, String>(1);
        if (CollectionUtils.isEmpty((Map)dataMap)) {
            dataMap = new HashMap<String, List>(1);
            carInfo.put("submit_type", "2");
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(1);
            list.add(carInfo);
            dataMap.put("cargo_information", list);
        } else {
            List cargoInformations = (List)dataMap.get("cargo_information");
            for (Map cargoInformation : cargoInformations) {
                cargoInformation.put("submit_type", "2");
            }
            dataMap.put("cargo_information", cargoInformations);
        }
        apiRequest.getRawData().put("data", dataMap);
        return this.pcUiBotSubmit(apiRequest);
    }

    private ActionSubmitResult transportValidArrival(String taskNo, String transportNo, ApiRequestSubmit apiRequest) {
        DigiwinEspStdData digiwinEspStdData = this.digiwinEspProxyService.validArrival(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), taskNo, transportNo, apiRequest.getPosition());
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("transport.arrival.valid.process \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        String promptMessage = LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u63d0\u4ea4\u6210\u529f");
        return ActionSubmitResult.create((boolean)true, (String)promptMessage);
    }

    private ActionSubmitResult transportTransfer(String transportNo, ApiRequestSubmit apiRequest) {
        ActionSubmitResult actionSubmitResult = new ActionSubmitResult();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        ApiRawData apiRawData = apiRequest.getRawData();
        List mapList = this.digiwinEspProxyService.getTransportDriver(iamUserToken, tenantId, locale, transportNo);
        if (CollectionUtils.isEmpty((Collection)mapList)) {
            Action action = new Action();
            action.setType(ActionTypeEnum.POP_PROMPT.getValue());
            PopPromptMsg popPromptMsg = new PopPromptMsg();
            popPromptMsg.setTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u793a"));
            popPromptMsg.setContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5f85\u53f8\u673a\u626b\u63cf\u8fd0\u5355\u4e8c\u7ef4\u7801\u8f6c\u8fd0\u5904\u7406"));
            ArrayList<Button> popButtonList = new ArrayList<Button>();
            Button popButton = new Button();
            popButton.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u786e\u5b9a"));
            popButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            Action popAction = new Action();
            popAction.setType(ActionTypeEnum.BACK.getValue());
            popButton.setAction(popAction);
            popButtonList.add(popButton);
            popPromptMsg.setButtonList(popButtonList);
            action.setPopPromptMsg(popPromptMsg);
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        Action action = new Action();
        action.setDataId(transportNo);
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_VEHICLE_INFO.toString());
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8f6c\u8fd0\u8f66\u8f86\u4fe1\u606f"));
        HashMap<String, Object> rawData = new HashMap<String, Object>();
        rawData.put("vehicle_info", mapList.get(0));
        rawData.put("transport_no", transportNo);
        rawData.put("action", apiRawData.get((Object)"action"));
        rawData.put("data", apiRawData.get((Object)"data"));
        rawData.put("digi-proxy-token", apiRawData.get((Object)"digi-proxy-token"));
        action.setRawData(rawData);
        actionSubmitResult.setAction(action);
        return actionSubmitResult;
    }

    private ActionSubmitResult shippingSubmit(String taskNo, ApiRequestSubmit apiRequest) {
        DigiwinEspStdData digiwinEspStdData = this.digiwinEspProxyService.ztbSubmit(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), taskNo, "2");
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("delivery.task.status.process \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        return this.pcUiBotSubmit(apiRequest);
    }

    private ActionSubmitResult shippingNextStep(String taskNo, ApiRequestSubmit apiRequest) {
        ActionSubmitResult actionSubmitResult = new ActionSubmitResult();
        ApiRawData apiRawData = apiRequest.getRawData();
        String locale = apiRequest.getLocale();
        List mapList = this.digiwinEspProxyService.getVehicleInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), taskNo, Boolean.valueOf(false), null);
        if (CollectionUtils.isEmpty((Collection)mapList)) {
            Action action = new Action();
            action.setType(ActionTypeEnum.POP_PROMPT.getValue());
            PopPromptMsg popPromptMsg = new PopPromptMsg();
            popPromptMsg.setTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u793a"));
            popPromptMsg.setContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5f85\u53f8\u673a\u626b\u63cf\u8d27\u8fd0\u4e8c\u7ef4\u7801\u63a5\u5355\u5904\u7406"));
            ArrayList<Button> popButtonList = new ArrayList<Button>();
            Button popButton = new Button();
            popButton.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u786e\u5b9a"));
            popButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            Action popAction = new Action();
            popAction.setType(ActionTypeEnum.BACK.getValue());
            popButton.setAction(popAction);
            popButtonList.add(popButton);
            popPromptMsg.setButtonList(popButtonList);
            action.setPopPromptMsg(popPromptMsg);
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        Action action = new Action();
        action.setDataId(taskNo);
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK_VEHICLE_INFO.toString());
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8f66\u8f86\u4fe1\u606f"));
        HashMap<String, Object> rawData = new HashMap<String, Object>();
        rawData.put("vehicle_infos", mapList);
        rawData.put("task_no", taskNo);
        rawData.put("action", apiRawData.get((Object)"action"));
        rawData.put("data", apiRawData.get((Object)"data"));
        rawData.put("digi-proxy-token", apiRawData.get((Object)"digi-proxy-token"));
        action.setRawData(rawData);
        actionSubmitResult.setAction(action);
        return actionSubmitResult;
    }

    private ActionSubmitResult scanReceiveOrderSubmit(String taskNo, ApiRequestSubmit apiRequestSubmit) {
        ApiRawData apiRawData = apiRequestSubmit.getRawData();
        String transportNo = (String)apiRawData.get((Object)"transport_no");
        List submitParams = apiRequestSubmit.getSubmitParams();
        ActionSubmitParam driverMessageParam = submitParams.stream().filter(item -> item.getSchema().equalsIgnoreCase("driverMessage")).findFirst().orElse(new ActionSubmitParam());
        InputWindowSingleSelect data_info = (InputWindowSingleSelect)JsonUtil.objectToJavaObject((Object)driverMessageParam.getParams(), InputWindowSingleSelect.class);
        Map detail = data_info.getDetail();
        HashMap params = new HashMap();
        params.put("brand_model_no", detail.get("brand_model_no"));
        params.put("vehicle_type", detail.get("vehicle_type"));
        params.put("license_plate_no", detail.get("license_plate_no"));
        params.put("vehicle_info_id", detail.get("vehicle_info_id"));
        params.put("task_no", taskNo);
        if (StringUtils.hasLength((String)transportNo)) {
            DigiwinEspStdData digiwinEspStdData = this.digiwinEspProxyService.newDriverProcess(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), transportNo, detail.get("vehicle_info_id"));
            if ("0".equals(digiwinEspStdData.getExecution().getCode())) {
                String promptMessage = LocaleUtil.getMobileTextByKey((String)apiRequestSubmit.getLocale(), (String)"\u63d0\u4ea4\u6210\u529f");
                return ActionSubmitResult.create((boolean)true, (String)promptMessage);
            }
            return ActionSubmitResult.create((boolean)false, (String)("new.driver.transport.twist.info.process \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        DigiwinEspStdData digiwinEspStdData = this.digiwinEspProxyService.driverCurrentVehicleUpdate(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), params);
        if ("0".equals(digiwinEspStdData.getExecution().getCode())) {
            String promptMessage = LocaleUtil.getMobileTextByKey((String)apiRequestSubmit.getLocale(), (String)"\u63d0\u4ea4\u6210\u529f");
            return ActionSubmitResult.create((boolean)true, (String)promptMessage);
        }
        return ActionSubmitResult.create((boolean)false, (String)("driver.current.vehicle.update \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
    }

    private ActionSubmitResult goodsDepartureSubmit(Map<String, Object> params, ApiRequestSubmit apiRequestSubmit) {
        ArrayList fileList = new ArrayList(6);
        apiRequestSubmit.getSubmitParams().forEach(submit -> {
            Picture picture;
            if ("PICTURE".equalsIgnoreCase(submit.getType()) && (picture = (Picture)submit.getParams()) != null && !CollectionUtils.isEmpty((Collection)picture.getFileList())) {
                picture.getFileList().forEach(file -> fileList.add(file.getFileId()));
            }
        });
        params.put("depart_pic_file_list", fileList);
        DigiwinEspStdData digiwinEspStdData = this.digiwinEspProxyService.cargoDepart(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), apiRequestSubmit.getLocale(), params);
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("cargo.depart.info.process \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        HashMap<String, List> dataMap = (HashMap<String, List>)apiRequestSubmit.getRawData().get((Object)"data");
        HashMap<String, String> carInfo = new HashMap<String, String>(1);
        if (CollectionUtils.isEmpty((Map)dataMap)) {
            dataMap = new HashMap<String, List>(1);
            carInfo.put("submit_type", "1");
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>(1);
            list.add(carInfo);
            dataMap.put("cargo_information", list);
        } else {
            List cargoInformations = (List)dataMap.get("cargo_information");
            for (Map cargoInformation : cargoInformations) {
                cargoInformation.put("submit_type", "1");
            }
            dataMap.put("cargo_information", cargoInformations);
        }
        apiRequestSubmit.getRawData().put("data", dataMap);
        return this.pcUiBotSubmit(apiRequestSubmit);
    }

    private ActionSubmitResult goodsLoadingSubmit(String taskNo, ApiRequestSubmit apiRequestSubmit) {
        ActionSubmitResult actionSubmitResult = new ActionSubmitResult();
        ApiRawData rawData = apiRequestSubmit.getRawData();
        List submitParams = apiRequestSubmit.getSubmitParams();
        List deliveryInfoParams = submitParams.stream().filter(submitParam -> "MULTI_FUNCTION_LIST".equalsIgnoreCase(submitParam.getType())).collect(Collectors.toList());
        if (deliveryInfoParams.isEmpty()) {
            Action action = new Action();
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            action.setToastMsg(this.localeService.getLanguageValue(apiRequestSubmit.getLocale(), "\u8bf7\u5148\u9009\u62e9\u8d27\u7269"));
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)((ActionSubmitParam)deliveryInfoParams.get(0)).getParams(), MultiFunctionList.class);
        List deliveryDetailList = multiFunctionList.getSelectDetailList();
        rawData.put("deliveryDetailList", (Object)deliveryDetailList);
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setRawData((Object)rawData);
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_GOODS_LOADING_VEHICLE_INFO.toString());
        action.setJumpPageTitle(this.localeService.getLanguageValue(apiRequestSubmit.getLocale(), "\u8f66\u8f86\u4fe1\u606f"));
        actionSubmitResult.setAction(action);
        return actionSubmitResult;
    }

    private ActionSubmitResult goodsLoadingVehicleInfoSubmit(String taskNo, ApiRequestSubmit apiRequestSubmit) {
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult;
        List deliveryDetailMapList;
        ActionSubmitResult actionSubmitResult = new ActionSubmitResult();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();
        String locale = apiRequestSubmit.getLocale();
        ApiRawData rawData = apiRequestSubmit.getRawData();
        List deliveryDetailList = (List)rawData.get((Object)"deliveryDetailList");
        List submitParams = apiRequestSubmit.getSubmitParams();
        List vehicleParams = submitParams.stream().filter(submitParam -> "MULTI_FUNCTION_LIST".equalsIgnoreCase(submitParam.getType())).collect(Collectors.toList());
        if (vehicleParams.isEmpty()) {
            Action action = new Action();
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            action.setToastMsg(this.localeService.getLanguageValue(apiRequestSubmit.getLocale(), "\u8bf7\u5148\u9009\u62e9\u8f66\u8f86"));
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        MultiFunctionList multiFunctionList = (MultiFunctionList)JsonUtil.objectToJavaObject((Object)((ActionSubmitParam)vehicleParams.get(0)).getParams(), MultiFunctionList.class);
        List vehicleDetailList = multiFunctionList.getSelectDetailList();
        Map vehicleDetail = (Map)vehicleDetailList.get(0);
        DigiwinEspStdData digiwinEspStdData = this.digiwinEspProxyService.ztbLoadingSubmit(iamUserToken, tenantId, locale, deliveryDetailList, vehicleDetail);
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ActionSubmitResult.create((boolean)false, (String)("cargo.loading.info.process \u8fd4\u56de code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription()));
        }
        Boolean isLoadCar = (Boolean)digiwinEspStdData.getParameter().get("is_load_car");
        String transportNo = (String)digiwinEspStdData.getParameter().get("transport_no");
        Map rawDataData = (Map)rawData.get((Object)"data");
        if (!CollectionUtils.isEmpty((Map)rawDataData) && !CollectionUtils.isEmpty((Collection)(deliveryDetailMapList = (List)rawDataData.get("delivery_detail")))) {
            deliveryDetailMapList.forEach(deliveryDetailMap -> deliveryDetailMap.put("transport_no", transportNo));
        }
        if (null != (atmcSubmitResult = this.digiwinAtmcProxyService.actionSubmit(locale, iamUserToken, tenantId, (Map)rawData)).getRequestData()) {
            String promptMessage = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4\u6210\u529f");
            actionSubmitResult = ActionSubmitResult.create((boolean)true, (String)promptMessage);
            Action action = new Action();
            if (isLoadCar != null && isLoadCar.booleanValue()) {
                action.setType(ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
            } else {
                action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            }
            actionSubmitResult.setAction(action);
            return actionSubmitResult;
        }
        return ActionSubmitResult.create((boolean)false, (String)atmcSubmitResult.getErrorMessage());
    }

    private ActionSubmitResult pcUiBotSubmit(ApiRequestSubmit apiRequest) {
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult = this.digiwinAtmcProxyService.actionSubmit(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), (Map)apiRequest.getRawData());
        if (null != atmcSubmitResult.getRequestData()) {
            String promptMessage = LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"\u63d0\u4ea4\u6210\u529f");
            return ActionSubmitResult.create((boolean)true, (String)promptMessage);
        }
        return ActionSubmitResult.create((boolean)false, (String)atmcSubmitResult.getErrorMessage());
    }

    private ActionSubmitResult pcUiBotSubmit(ApiRequestSubmit apiRequest, String promptMessage) {
        DigiwinAtmcBacklogSubmitResult atmcSubmitResult = this.digiwinAtmcProxyService.actionSubmit(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), (Map)apiRequest.getRawData());
        if (null != atmcSubmitResult.getRequestData()) {
            return ActionSubmitResult.create((boolean)true, (String)promptMessage);
        }
        return ActionSubmitResult.create((boolean)false, (String)atmcSubmitResult.getErrorMessage());
    }

    private ActionSubmitResult returnSubmit(Boolean submit, String locale) {
        if (submit.booleanValue()) {
            String promptMessage = LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4\u6210\u529f");
            return ActionSubmitResult.create((boolean)true, (String)promptMessage);
        }
        return ActionSubmitResult.create((boolean)false, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4\u5f02\u5e38"));
    }

    private ActionSubmitResult returnSubmit(Boolean submit, String locale, String promptMessage) {
        if (submit.booleanValue()) {
            return ActionSubmitResult.create((boolean)true, (String)promptMessage);
        }
        return ActionSubmitResult.create((boolean)false, (String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u4ea4\u5f02\u5e38"));
    }
}

