/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildZTBDeliveryLoadEditItemStrategy")
public class UiBotModelBuildZTBDeliveryLoadEditItemStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBDeliveryLoadEditItemStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Ztb handel Bottom");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        logger.debug(JSONUtil.toJsonStr((Object)uiBotModel));
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotPageData newPageData = new UiBotPageData();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)fieldSchema), Card.class);
                    newPageData.put((Object)fieldSchema, (Object)card.detailMessage((Map)rawData, card, this.localeService, locale));
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = new CustomGroup();
                    UiBotModel customUiBot = (UiBotModel)JsonUtil.objectToJavaObject((Object)pageData.get((Object)layout.getSchema()), UiBotModel.class);
                    UiBotPageData customPageData = customUiBot.getPageData();
                    for (UiBotLayout uiBotLayout : customUiBot.getLayout()) {
                        String title = this.localeService.getLanguageValue(locale, uiBotLayout.getLabel());
                        String data = (String)rawData.get(uiBotLayout.getSchema());
                        switch (uiBotLayout.getType()) {
                            case "INPUT_SINGLE": {
                                customPageData.put((Object)uiBotLayout.getSchema(), (Object)InputSingleText.create((String)uiBotLayout.getSchema(), (String)title, (Boolean)true, (Boolean)true, (String)locale, (String)data, (Boolean)false));
                                break;
                            }
                            case "INPUT_NUMERIC": {
                                InputNumeric inputNumeric = null;
                                if (StrUtil.equals((CharSequence)uiBotLayout.getSchema(), (CharSequence)"item_qty")) {
                                    Button button = new Button();
                                    button.setName(this.localeService.getLanguageValue(locale, "\u4e00\u5e76\u6c47\u5165"));
                                    button.setType(ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());
                                    ParseFieldData fieldData = new ParseFieldData();
                                    fieldData.setLabel(this.localeService.getLanguageValue(locale, "\u88c5\u8f66\u6570\u91cf"));
                                    ArrayList uiBotRuleList = new ArrayList();
                                    BigDecimal unLoadingQty = new BigDecimal(StrUtil.toString(rawData.get("un_loading_qty")));
                                    String str = NumberUtil.toStr((Number)NumberUtil.parseNumber((String)unLoadingQty.toString()));
                                    inputNumeric = InputNumeric.create((String)locale, (ParseFieldData)fieldData, uiBotRuleList, (Button)button, (String)str, (boolean)true);
                                    inputNumeric.setText(data);
                                    ArrayList<ValidateRule> validateRuleList = new ArrayList<ValidateRule>();
                                    ValidateRule validateRule = new ValidateRule();
                                    validateRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                                    validateRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
                                    String un_loading_qty = (String)rawData.get("un_loading_qty");
                                    validateRule.setParameter(un_loading_qty);
                                    validateRule.setOperatorType(Integer.valueOf(4));
                                    validateRule.setErrorMessage(this.localeService.getLanguageValue(locale, "\u8f93\u5165\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5e94\u53d1\u6570\u91cf:" + un_loading_qty));
                                    validateRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                                    validateRuleList.add(validateRule);
                                    ValidateRule validateRule2 = new ValidateRule();
                                    validateRule2.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                                    validateRule2.setType(ValidateRuleTypeEnum.APPOINT.getType());
                                    validateRule2.setParameter("0");
                                    validateRule2.setOperatorType(Integer.valueOf(5));
                                    validateRule2.setErrorMessage(this.localeService.getLanguageValue(locale, "\u8f93\u5165\u6570\u91cf\u5e94\u5927\u4e8e0"));
                                    validateRule2.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                                    validateRuleList.add(validateRule2);
                                    inputNumeric.setValidateRuleList(validateRuleList);
                                } else {
                                    inputNumeric = InputNumeric.create((Integer)999, (Integer)6, (String)data, (String)title, (Integer)InputNumericTypeEnum.INTEGER.getValue());
                                    inputNumeric.setPlaceholder("\u8bf7\u8f93\u5165...");
                                    inputNumeric.setRequired(Boolean.valueOf(false));
                                }
                                customPageData.put((Object)uiBotLayout.getSchema(), (Object)inputNumeric);
                                break;
                            }
                        }
                    }
                    CustomGroupContent content = new CustomGroupContent();
                    content.setLayout(customUiBot.getLayout());
                    content.setPageData(customUiBot.getPageData());
                    customGroup.setContent(content);
                    customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                    newPageData.put((Object)fieldSchema, (Object)customGroup);
                    break;
                }
            }
        }
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

