/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionSubmitType;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Component(value="uiBotModelBuildZTBReceiptScheduleChangeStrategy")
public class UiBotModelBuildZTBReceiptScheduleChangeStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBReceiptScheduleChangeStrategy.class);
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildZTBReceiptScheduleChangeStrategy");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        ApiRawData rawData = apiRequest.getRawData();
        JSONObject data = rawData.getJSONObject("data");
        UiBotModel pcUiBotModel = (UiBotModel)JsonUtil.objectToJavaObject((Object)rawData.get((Object)"pcUiBotModel"), UiBotModel.class);
        String transportNo = data.getString("transport_no");
        String taskNo = data.getString("task_no");
        Map transportMainInfo = this.digiwinEspProxyService.getTransportMainInfoResponseMap(iamUserToken, tenantId, locale, transportNo);
        Map transportVehicleInfo = this.digiwinEspProxyService.getTransportVehicleInfo(iamUserToken, tenantId, locale, transportNo);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    pageData.put((Object)schema, (Object)InputWindowSingleSelect.create((UiBotLayout)((UiBotLayout)pcUiBotModel.getLayout().get(0)), (Boolean)true, (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=ZtbReceiptScheduleChange"), (UiBotModel)pcUiBotModel, (Boolean)true, (Map)data, (ApiRequest)apiRequest));
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), Card.class);
                    if ("carMessage".equalsIgnoreCase(schema) || "driverMeaasge".equalsIgnoreCase(schema)) {
                        card.detailMessage(transportVehicleInfo, card, this.localeService, locale);
                    }
                    pageData.put((Object)schema, (Object)card);
                    break;
                }
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = new CustomGroup();
                    UiBotModel customUiboModel = (UiBotModel)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), UiBotModel.class);
                    if ("logisticsMessage".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildLogisticsGroup(locale, (DigiwinTransportResponse)JsonUtil.objectToJavaObject((Object)transportMainInfo, DigiwinTransportResponse.class), customUiboModel, Boolean.valueOf(false));
                    } else if ("receiptPreparation".equalsIgnoreCase(schema)) {
                        CustomGroupContent content;
                        if (StringUtils.hasLength((String)((String)transportMainInfo.get("unloader_id")))) {
                            customGroup.setName(this.localeService.getLanguageValue(locale, customUiboModel.getName()));
                            customGroup.buildReceiptPreparation(customUiboModel, this.localeService, this.digiwinEspProxyService, apiRequest, transportMainInfo, transportNo, taskNo);
                            content = new CustomGroupContent();
                            content.setLayout(customUiboModel.getLayout());
                            content.setPageData(customUiboModel.getPageData());
                            customGroup.setContent(content);
                            customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                        } else {
                            content = new CustomGroupContent();
                            customGroup.setContent(content);
                        }
                    } else if ("platformMessage".equalsIgnoreCase(schema)) {
                        customGroup = customGroup.buildPlatformMessage(transportMainInfo, customUiboModel, apiRequest, this.localeService, (String)transportMainInfo.get("delivery_no"));
                        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());
                    }
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    String finalTaskNo = taskNo;
                    String finalTransportNo = transportNo;
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength((String)buttonName)) {
                            bottomButtonDigiwinAthena.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), buttonName));
                        }
                        HashMap<String, Object> buttonRawData = new HashMap<String, Object>(3);
                        Action action = bottomButtonDigiwinAthena.getAction();
                        ConfirmPop confirmPop = action.getConfirmPop();
                        if (confirmPop != null) {
                            confirmPop.setContent(this.localeService.getLanguageValue(locale, confirmPop.getContent()));
                            buttonRawData.put("isCancel", true);
                        } else {
                            buttonRawData.put("isCancel", false);
                        }
                        buttonRawData.put("task_no", finalTaskNo);
                        buttonRawData.put("page_id", apiRequest.getPageId());
                        buttonRawData.put("biz_id", "ZTB");
                        buttonRawData.put("transport_no", finalTransportNo);
                        buttonRawData.put("digi-proxy-token", "");
                        UiBotAction uiBotAction = UiBotModel.getSubmitAction((UiBotModel)pcUiBotModel, (String)"sd_manual.project.create");
                        if (null != uiBotAction) {
                            buttonRawData.put("action", uiBotAction);
                            HashMap<String, Object> actionData = new HashMap<String, Object>(1);
                            String actionDataScheme = Optional.ofNullable(uiBotAction.getSubmitType()).orElse(new UiBotActionSubmitType()).getSchema();
                            actionData.put(actionDataScheme, pcUiBotModel.getPageData().get((Object)actionDataScheme));
                            buttonRawData.put("data", actionData);
                        }
                        action.setRawData(buttonRawData);
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

