/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UiBotModelBuildZTBShippingTaskVehicleInfoStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        List vehicleInfos = (List)rawData.get((Object)"vehicle_infos");
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        ArrayList<UiBotLayout> newLayoutList = new ArrayList<UiBotLayout>();
        UiBotPageData newUibotPageData = new UiBotPageData();
        Boolean hasButton = false;
        UiBotLayout buttonLayout = new UiBotLayout();
        for (Map vehicleInfo : vehicleInfos) {
            UiBotLayout customLayout = new UiBotLayout();
            String customSchema = UUIDUtil.getUuid();
            customLayout.setSchema(customSchema);
            customLayout.setType("CARD");
            Card card = new Card();
            List cardContents = card.getContent();
            for (UiBotLayout layout : layoutList) {
                String type = layout.getType();
                String schema = layout.getSchema();
                CardContent content = new CardContent();
                switch (type) {
                    case "FIELD": {
                        Field field = (Field)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), Field.class);
                        if ("license_plate_no".equalsIgnoreCase(schema)) {
                            card.setTitle((String)vehicleInfo.get(schema));
                            break;
                        }
                        content.setValue((String)vehicleInfo.get(schema));
                        content.setLabel(this.localeService.getLanguageValue(locale, field.getLabel()));
                        cardContents.add(content);
                        break;
                    }
                    case "BOTTOM_BUTTON": {
                        if (hasButton.booleanValue()) break;
                        buttonLayout = layout;
                        BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                        bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                            String nameKey = bottomButtonDigiwinAthena.getName();
                            bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)nameKey));
                            if (ActionTypeEnum.CALL_API_BACK_TWO.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                                Action action = bottomButtonDigiwinAthena.getAction();
                                ConfirmPop confirmPop = action.getConfirmPop();
                                confirmPop.setContent(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)confirmPop.getContent()));
                                ApiRawData buttonRawData = new ApiRawData();
                                buttonRawData.put("task_no", rawData.get((Object)"task_no"));
                                buttonRawData.put("biz_id", (Object)"ZTB");
                                buttonRawData.put("page_id", (Object)PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK_VEHICLE_INFO.toString());
                                buttonRawData.put("action", rawData.get((Object)"action"));
                                buttonRawData.put("data", rawData.get((Object)"data"));
                                action.setRawData((Object)buttonRawData);
                                bottomButtonDigiwinAthena.setAction(action);
                            }
                        });
                        newUibotPageData.put((Object)schema, (Object)bottomButtonList);
                        hasButton = true;
                        break;
                    }
                }
            }
            newLayoutList.add(customLayout);
            newUibotPageData.put((Object)customSchema, (Object)card);
        }
        newLayoutList.add(buttonLayout);
        uiBotModel.setLayout(newLayoutList);
        uiBotModel.setPageData(newUibotPageData);
        return uiBotModel;
    }
}

