/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildZTBTransportFactoryVoucherStrategy")
public class UiBotModelBuildZTBTransportFactoryVoucherStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildZTBTransportFactoryVoucherStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build ReceiptConfirmation");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        ApiRawData rawData = apiRequest.getRawData();
        String transportNo = rawData.getString("transportNo");
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        Map transportVehicleInfo = this.digiwinEspProxyService.getTransportVehicleInfo(iamUserToken, tenantId, locale, transportNo);
        Map transportEntryArrangement = this.digiwinEspProxyService.getTransportEntryArrangement(iamUserToken, tenantId, locale, transportNo);
        for (UiBotLayout layout : layoutList) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "Entry_Certificate": {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    HashMap<String, String> deliveryMap = new HashMap<String, String>();
                    deliveryMap.put("title", "\u53d1");
                    Card card = new Card();
                    card.setCmptUuid(UUIDUtil.getUuid());
                    card.setStyle(Integer.valueOf(1));
                    ArrayList<CardContent> contents = new ArrayList<CardContent>();
                    CardContent cardContent = new CardContent();
                    cardContent.setLabel(this.localeService.getLanguageValue(locale, "\u53d1\u8d27\u516c\u53f8"));
                    cardContent.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("supplier_company_name")) ? "-" : StrUtil.toString(transportEntryArrangement.get("supplier_company_name")));
                    cardContent.setValueStyleType(Integer.valueOf(1));
                    cardContent.setSchema("supplier_company_name");
                    contents.add(cardContent);
                    card.setContent(contents);
                    deliveryMap.put("dataItem", (String)card);
                    resultMap.put("delivery", deliveryMap);
                    resultMap.put("graphic", GraphicDisplay.createNoSubTitle((ZTBDriverVehicle)((ZTBDriverVehicle)JsonUtil.objectToJavaObject((Object)transportVehicleInfo, ZTBDriverVehicle.class)), (Integer)2, (DigiwinDmcProxyService)this.digiwinDmcProxyService));
                    HashMap<String, String> receiveMap = new HashMap<String, String>();
                    receiveMap.put("title", "\u6536");
                    Card card1 = new Card();
                    card1.setCmptUuid(UUIDUtil.getUuid());
                    card1.setStyle(Integer.valueOf(1));
                    ArrayList<CardContent> contents1 = new ArrayList<CardContent>();
                    CardContent cardContent1 = new CardContent();
                    cardContent1.setLabel(this.localeService.getLanguageValue(locale, "\u6536\u8d27\u516c\u53f8"));
                    cardContent1.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("receiver_company_name")) ? "-" : StrUtil.toString(transportEntryArrangement.get("receiver_company_name")));
                    cardContent1.setValueStyleType(Integer.valueOf(1));
                    cardContent1.setSchema("receiver_company_name");
                    contents1.add(cardContent1);
                    CardContent cardContent2 = new CardContent();
                    cardContent2.setLabel(this.localeService.getLanguageValue(locale, "\u6536\u8d27\u5458"));
                    cardContent2.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("unloader_name")) ? "-" : StrUtil.toString(transportEntryArrangement.get("unloader_name")));
                    cardContent2.setValueStyleType(Integer.valueOf(1));
                    cardContent2.setSchema("unloader_name");
                    contents1.add(cardContent2);
                    CardContent cardContent3 = new CardContent();
                    cardContent3.setLabel(this.localeService.getLanguageValue(locale, "\u8054\u7cfb\u65b9\u5f0f"));
                    cardContent3.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("unloader_phone")) ? "-" : StrUtil.toString(transportEntryArrangement.get("unloader_phone")));
                    cardContent3.setValueStyleType(Integer.valueOf(1));
                    cardContent3.setType("PHONE");
                    cardContent3.setSchema("unloader_phone");
                    contents1.add(cardContent3);
                    CardContent cardContent4 = new CardContent();
                    cardContent4.setLabel(this.localeService.getLanguageValue(locale, "\u4ed3\u5e93\u53f7"));
                    cardContent4.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("warehouse_no")) ? "-" : StrUtil.toString(transportEntryArrangement.get("warehouse_no")));
                    cardContent4.setValueStyleType(Integer.valueOf(1));
                    cardContent4.setSchema("warehouse_no");
                    contents1.add(cardContent4);
                    CardContent cardContent5 = new CardContent();
                    cardContent5.setLabel(this.localeService.getLanguageValue(locale, "\u5378\u8d27\u6708\u53f0"));
                    cardContent5.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("platform_no")) ? "-" : StrUtil.toString(transportEntryArrangement.get("platform_no")));
                    cardContent5.setValueStyleType(Integer.valueOf(1));
                    cardContent5.setSchema("platform_no");
                    contents1.add(cardContent5);
                    CardContent cardContent6 = new CardContent();
                    cardContent6.setLabel(this.localeService.getLanguageValue(locale, "\u5165\u5382\u65f6\u95f4"));
                    cardContent6.setValue(ObjectUtil.isEmpty(transportEntryArrangement.get("arrival_time")) ? "-" : StrUtil.toString(transportEntryArrangement.get("arrival_time")));
                    cardContent6.setValueStyleType(Integer.valueOf(1));
                    cardContent6.setSchema("arrival_time");
                    contents1.add(cardContent6);
                    card1.setContent(contents1);
                    receiveMap.put("dataItem", (String)card1);
                    resultMap.put("receive", receiveMap);
                    resultMap.put("title", this.localeService.getLanguageValue(locale, "\u5165\u5382\u51ed\u8bc1"));
                    pageData.put((Object)schema, resultMap);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

