/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.proxy.zhilink.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UiBotModelBuildZTBTransportVehicleInfoStrategy
implements UiBotModelBuildStrategy {
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = this.doActually(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        ZTBDriverVehicle vehicleInfo = (ZTBDriverVehicle)JsonUtil.objectToJavaObject((Object)rawData.get((Object)"vehicle_info"), ZTBDriverVehicle.class);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List layoutList = uiBotModel.getLayout();
        for (UiBotLayout layout : layoutList) {
            String type = layout.getType();
            String schema = layout.getSchema();
            switch (type) {
                case "GRAPHIC_DISPLAY": {
                    pageData.put((Object)schema, (Object)GraphicDisplay.createNoSubTitle((ZTBDriverVehicle)vehicleInfo, (Integer)1, (DigiwinDmcProxyService)this.digiwinDmcProxyService));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)nameKey));
                        if (ActionTypeEnum.CALL_API_BACK_INDEX.getValue().equals(bottomButtonDigiwinAthena.getAction().getType())) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            ApiRawData buttonRawData = new ApiRawData();
                            buttonRawData.put("transport_no", rawData.get((Object)"transport_no"));
                            buttonRawData.put("vehicle_info_id", (Object)(vehicleInfo.getVehicleInfoId() == null ? vehicleInfo.getId() : vehicleInfo.getVehicleInfoId()));
                            buttonRawData.put("biz_id", (Object)"ZTB");
                            buttonRawData.put("page_id", (Object)PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_VEHICLE_INFO.toString());
                            buttonRawData.put("action", rawData.get((Object)"action"));
                            buttonRawData.put("data", rawData.get((Object)"data"));
                            action.setRawData((Object)buttonRawData);
                            bottomButtonDigiwinAthena.setAction(action);
                        }
                    });
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }
}

