/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.scanner;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONException;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.common.url.UrlUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.PopPromptMsg;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsData;
import com.digiwin.mobile.mobileuibot.core.component.logistics.LogisticsEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.portal.service.PortalService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbCargoUnloading;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.scanner.QrCodeDoIt;
import com.digiwin.mobile.mobileuibot.scanner.QrCodeStrategyEnum;
import com.digiwin.mobile.mobileuibot.scanner.QrCodeStrategyFactory;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/qrcode"})
public class QrCodeController {
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private ZhilinkService zhilinkService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private PortalService portalService;
    @Autowired
    QrCodeStrategyFactory qrCodeStrategyFactory;
    private static final Logger logger = LoggerFactory.getLogger(QrCodeController.class);

    @PostMapping(value={"/scan"})
    public ApiResponse scanQrCode(HttpServletRequest request) throws IOException {
        String bizType;
        Map conditon;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String tenantId = (String)params.get("tenantId");
        String locale = (String)params.get("locale");
        String userId = (String)params.get("userId");
        String clientId = MapUtils.getString((Map)params, (Object)"clientId");
        Map buttonRawData = (Map)params.get("rawData");
        Map map = new HashMap(8);
        QrCodeDoIt qrCodeDoIt = null;
        ApiRequest apiRequest = ApiRequest.builder().iamUserToken(iamUserToken).tenantId(tenantId).userId(userId).locale(locale).clientId(clientId).build();
        if (this.isQrCodeSearchTaskCondition(params) && (conditon = (Map)JsonUtil.jsonStringToObject((String)MapUtils.getString((Map)params, (Object)"content"), Map.class)).containsKey("t") && !ObjectUtil.isEmpty(conditon.get("t"))) {
            Integer t = (Integer)conditon.get("t");
            switch (t) {
                case 101: {
                    qrCodeDoIt = this.qrCodeStrategyFactory.get(QrCodeStrategyEnum.QR_CODE_PREVIEW_PORTAL.getValue());
                    break;
                }
                default: {
                    qrCodeDoIt = this.qrCodeStrategyFactory.get(QrCodeStrategyEnum.QR_CODE_SEARCH_TASK.getValue());
                }
            }
            Action action = qrCodeDoIt.doIt(apiRequest, conditon);
            resultMap.put("action", action);
            return ApiResponse.buildOK().setData(resultMap);
        }
        String url = (String)params.get("content");
        if (!StringUtils.hasLength((String)url) || !url.startsWith("http")) {
            bizType = (String)buttonRawData.get("bizType");
        } else {
            map = UrlUtil.parseUrl((String)url);
            map = this.decrypt(map, this.sysEnvConfig.getAesKey());
            bizType = (String)map.get("bizType");
        }
        if ("ZHILINK_ITM".equals(bizType)) {
            String timestampStr = (String)map.get("timestamp");
            boolean valid = true;
            if (StringUtils.hasLength((String)timestampStr)) {
                valid = this.checkTimeStamp(timestampStr);
            }
            if (!valid) {
                Action action = this.invalidAction(locale);
                resultMap.put("action", action);
                return ApiResponse.buildOK().setData(resultMap);
            }
            String taskNo = (String)map.get("task_no");
            String transportNo = (String)map.get("transport_no");
            Map joinTenant = this.zhilinkService.joinTenant(iamUserToken, locale, taskNo, userId);
            if (!((Boolean)joinTenant.get("isSuccess")).booleanValue()) {
                resultMap.put("action", joinTenant.get("action"));
                return ApiResponse.buildOK().setData(resultMap);
            }
            Action action = new Action();
            if (!StringUtils.hasLength((String)taskNo)) {
                return ApiResponse.buildOK().setData(resultMap);
            }
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            HashMap<String, String> rawData = new HashMap<String, String>(2);
            rawData.put("task_no", taskNo);
            if (StringUtils.hasLength((String)transportNo)) {
                rawData.put("transport_no", transportNo);
            }
            action.setRawData(rawData);
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SCAN_RECEIVE_ORDER.toString());
            resultMap.put("action", action);
            return ApiResponse.buildOK().setData(resultMap);
        }
        if ("DRIVER_CODE".equalsIgnoreCase(bizType)) {
            Map codeScan;
            String taskNo = (String)buttonRawData.get("task_no");
            Map joinTenant = this.zhilinkService.joinTenant(iamUserToken, locale, taskNo, userId);
            if (!((Boolean)joinTenant.get("isSuccess")).booleanValue()) {
                resultMap.put("action", joinTenant.get("action"));
                return ApiResponse.buildOK().setData(resultMap);
            }
            String vehicleInfoId = (String)map.get("vehicle_info_id");
            HashMap<String, String> vehicleParams = new HashMap<String, String>(1);
            vehicleParams.put("vehicle_info_id", vehicleInfoId);
            List driverVehicles = this.digiwinEspProxyService.getDriverVehicleDetail(iamUserToken, tenantId, locale, vehicleParams);
            HashMap<String, String> rawData = new HashMap<String, String>(4);
            rawData.put("task_no", taskNo);
            if (CollectionUtils.isEmpty((Collection)driverVehicles)) {
                resultMap.put("errorMessage", this.localeService.getLanguageValue(locale, "\u8f66\u8f86\u672a\u627e\u5230\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u53f8\u673a\u4e8c\u7ef4\u7801"));
                return ApiResponse.buildOK().setData(resultMap);
            }
            rawData.putAll((Map)driverVehicles.get(0));
            if (((Boolean)params.get("isChangeDriver")).booleanValue()) {
                resultMap.put("errorMessage", this.localeService.getLanguageValue(locale, ((Map)driverVehicles.get(0)).get("license_plate_no") + "\u626b\u7801\u6210\u529f/n\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u66f4\u6362\u8f66\u8f86\uff1f"));
                Action action = new Action();
                HashMap actionRawData = new HashMap(8);
                actionRawData.putAll(buttonRawData);
                actionRawData.put("cargo_information", params.get("cargo_information"));
                action.setRawData(actionRawData);
                resultMap.put("action", action);
                return ApiResponse.buildOK().setData(resultMap);
            }
            if (StringUtils.hasLength((String)((String)buttonRawData.get("transport_no")))) {
                HashMap vehicleMap = new HashMap(5);
                vehicleMap.put("license_plate_no", ((Map)driverVehicles.get(0)).get("license_plate_no"));
                vehicleMap.put("vehicle_type", ((Map)driverVehicles.get(0)).get("vehicle_type"));
                vehicleMap.put("vehicle_length", ((Map)driverVehicles.get(0)).get("vehicle_length"));
                vehicleMap.put("task_no", taskNo);
                vehicleMap.put("transport_no", buttonRawData.get("transport_no"));
                if (PageSettingIdPresetEnum.MOBILE_ZTB_TRANSPORT_VEHICLE_INFO.toString().equalsIgnoreCase((String)buttonRawData.get("page_id"))) {
                    Action action = new Action();
                    action.setJumpPageTitle(this.localeService.getLanguageValue(locale, (String)buttonRawData.get("jumpPageTitle")));
                    action.setJumpPageId((String)buttonRawData.get("page_id"));
                    buttonRawData.put("transport_no", buttonRawData.get("transport_no"));
                    buttonRawData.put("vehicle_info", driverVehicles.get(0));
                    action.setRawData((Object)buttonRawData);
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    resultMap.put("action", action);
                    return ApiResponse.buildOK().setData(resultMap);
                }
                Map changeVehicleMap = this.digiwinEspProxyService.changeTaskTransportVehicle(iamUserToken, tenantId, locale, vehicleMap);
                if (ObjectUtil.isNotEmpty((Object)changeVehicleMap) && ObjectUtil.isNotEmpty(changeVehicleMap.get("transport_info"))) {
                    Map transport_info = (Map)changeVehicleMap.get("transport_info");
                    buttonRawData.put("transport_no", StrUtil.toString(transport_info.get("transport_no")));
                }
            }
            if (!CollectionUtils.isEmpty((Map)(codeScan = this.digiwinEspProxyService.taskTransportVehicleCodeScan(iamUserToken, tenantId, locale, rawData)))) {
                List submitParams = ModuleUtils.listMapToListObject((List)((List)params.get("submitParams")), ActionSubmitParam.class);
                block11: for (ActionSubmitParam submitParam : submitParams) {
                    switch (submitParam.getType()) {
                        case "LOGISTICS": {
                            List logisticsDataList = ModuleUtils.listMapToListObject((List)((List)submitParam.getParams()), LogisticsData.class);
                            for (LogisticsData data : logisticsDataList) {
                                if (LogisticsEnum.SEND.getValue().equals(data.getType())) {
                                    codeScan.put("delivery_address_id", data.getId());
                                    continue;
                                }
                                if (!LogisticsEnum.RECEIVER.getValue().equals(data.getType())) continue;
                                codeScan.put("receipt_address_id", data.getId());
                            }
                            continue block11;
                        }
                        case "INPUT_DATETIME_PICKER": {
                            InputDateTimePicker inputDateTimePicker = (InputDateTimePicker)JsonUtil.objectToJavaObject((Object)submitParam.getParams(), InputDateTimePicker.class);
                            codeScan.put(submitParam.getSchema(), InputDateTime.getDateTypeDateStringByType((InputDateTime)inputDateTimePicker.getDatetimeValue(), (Integer)InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType()));
                            break;
                        }
                    }
                }
                return ApiResponse.buildOK().setData((Object)this.zhilinkService.buildDriverCodeResultMap(resultMap, buttonRawData, codeScan, (Map)driverVehicles.get(0), params.get("cargo_information")));
            }
            resultMap.put("hasPrompt", true);
            resultMap.put("errorMessage", this.localeService.getLanguageValue(locale, "\u626b\u63cf\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5"));
            return ApiResponse.buildOK().setData(resultMap);
        }
        if ("BAR_CODE".equalsIgnoreCase(bizType)) {
            String barcodeNo = (String)params.get("content");
            String taskNo = (String)buttonRawData.get("task_no");
            String transportNo = (String)buttonRawData.get("transport_no");
            HashMap<String, String> rawData = new HashMap<String, String>(3);
            rawData.put("task_no", taskNo);
            rawData.put("barcode_no", barcodeNo);
            rawData.put("transport_no", transportNo);
            List cargoUnloadings = this.digiwinEspProxyService.taskTransportBarcodeScan(iamUserToken, tenantId, locale, rawData);
            if (CollectionUtils.isEmpty((Collection)cargoUnloadings)) {
                resultMap.put("errorMessage", this.localeService.getLanguageValue(locale, "\u626b\u63cf\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5"));
                return ApiResponse.buildOK().setData(resultMap);
            }
            List cargoInfomations = ModuleUtils.listMapToListObject((List)((List)buttonRawData.get("cargo_infomation")), ZtbCargoUnloading.class);
            ArrayList<Card> cards = new ArrayList<Card>(cargoUnloadings.size());
            for (ZtbCargoUnloading cargoUnloading : cargoUnloadings) {
                Card card = new Card();
                StringBuffer title = new StringBuffer();
                if (StringUtils.hasLength((String)cargoUnloading.getItemNo())) {
                    title.append(cargoUnloading.getItemNo()).append("-");
                }
                if (StringUtils.hasLength((String)cargoUnloading.getItemName())) {
                    title.append(cargoUnloading.getItemName());
                } else {
                    title.append("-");
                }
                card.setTitle(title.toString());
                card.setDetail((Map)JsonUtil.objectToJavaObject((Object)cargoUnloading, Map.class));
                card.setDataId(cargoUnloading.getItemNo());
                String unloadingQty = "";
                HashMap<String, Object> rawData1 = new HashMap<String, Object>();
                rawData1.put("item_no", cargoUnloading.getItemNo());
                rawData1.put("item_name", cargoUnloading.getItemName());
                rawData1.put("can_edit_qty", false);
                for (ZtbCargoUnloading cargoInfomation : cargoInfomations) {
                    if (!cargoInfomation.getItemNo().trim().equalsIgnoreCase(cargoUnloading.getItemNo())) continue;
                    card.getContent().add(new CardContent(this.localeService.getLanguageValue(locale, "\u5e94\u53d1\u6570\u91cf"), cargoInfomation.getUnLoadingQty() + "    " + cargoInfomation.getUnitNo(), Integer.valueOf(1), "un_loading_qty"));
                    String item_qty = NumberUtil.add((String[])new String[]{cargoUnloading.getItemQty(), cargoInfomation.getItemQty()}).toString();
                    card.getContent().add(new CardContent(this.localeService.getLanguageValue(locale, "\u88c5\u8f66\u6570\u91cf"), item_qty, Integer.valueOf(1), "item_qty"));
                    cargoInfomation.setItemQty(item_qty);
                    String barcode_num = NumberUtil.add((String[])new String[]{StrUtil.isBlank((CharSequence)cargoInfomation.getBarcode_num()) ? "0" : cargoInfomation.getBarcode_num(), "1"}).toString();
                    cargoInfomation.setBarcode_num(barcode_num);
                    card.getContent().add(new CardContent(this.localeService.getLanguageValue(locale, "\u6807\u7b7e\u6570\u91cf"), barcode_num, Integer.valueOf(1), "barcode_num"));
                    unloadingQty = cargoInfomation.getUnLoadingQty();
                    card.getDetail().put("item_unit_no", cargoInfomation.getUnitNo());
                    card.getDetail().put("item_unit_name", cargoInfomation.getUnitName());
                    rawData1.put("un_loading_qty", cargoInfomation.getUnLoadingQty());
                    rawData1.put("barcode_num", barcode_num);
                    rawData1.put("item_qty", item_qty);
                    rawData1.put("unit_no", cargoInfomation.getUnitNo());
                    rawData1.put("unit_name", cargoInfomation.getUnitName());
                    break;
                }
                buttonRawData.put("cargo_infomation", cargoInfomations);
                card.setRawData(rawData1);
                card.setAdderSubstracter(null);
                card.setCanEdit(Boolean.valueOf(true));
                cards.add(card);
            }
            resultMap.put("CARD", cards);
            HashMap<String, Integer> result = new HashMap<String, Integer>(2);
            result.put("type", 2);
            resultMap.put("result", result);
            Action action = new Action();
            action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/car/loading/submit");
            action.setRawData((Object)buttonRawData);
            resultMap.put("action", action);
            return ApiResponse.buildOK().setData(resultMap);
        }
        if ("ASN_CODE".equalsIgnoreCase(bizType)) {
            Action action = (Action)JsonUtil.objectToJavaObject(buttonRawData.get("action"), Action.class);
            String sourceNo = (String)params.get("content");
            Map sourceDetail = this.digiwinEspProxyService.getDeliverySourceDetail(iamUserToken, tenantId, locale, sourceNo);
            sourceDetail.put("source_no", sourceNo);
            action.setRawData((Object)sourceDetail);
            resultMap.put("action", action);
            return ApiResponse.buildOK().setData(resultMap);
        }
        if ("TRANSPORT_RECEIVE".equalsIgnoreCase(bizType)) {
            Action action = new Action();
            String transportNo = (String)map.get("transport_no");
            Map stringObjectMap = this.digiwinEspProxyService.scanTransportToReceive(userId, iamUserToken, tenantId, locale, transportNo);
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            action.setToastMsg(this.localeService.getLanguageValue(locale, StrUtil.toString(stringObjectMap.get("message"))));
            HashMap<String, Action> map1 = new HashMap<String, Action>();
            map1.put("action", action);
            resultMap.put("data", map1);
            return ApiResponse.buildOK().setData(resultMap);
        }
        if (url.startsWith("http")) {
            Action action = this.webViewAction(url);
            resultMap.put("action", action);
            return ApiResponse.buildOK().setData(resultMap);
        }
        resultMap.put("hasPrompt", true);
        resultMap.put("hasCancel", false);
        resultMap.put("errorMessage", this.localeService.getLanguageValue(locale, "\u626b\u63cf\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5"));
        return ApiResponse.buildOK().setData(resultMap);
    }

    private boolean isQrCodePrePortalCondition(Map<String, Object> params) {
        if (Objects.nonNull(params.get("content"))) {
            try {
                Map conditon = (Map)JsonUtil.jsonStringToObject((String)MapUtils.getString(params, (Object)"content"), Map.class);
                return conditon.containsKey("t") && conditon.get("t").equals("101");
            }
            catch (Exception e) {
                logger.error("isQrCodePrePortalCondition qrCode is : {}", params.get("content"));
            }
        }
        return false;
    }

    private boolean isQrCodeSearchTaskCondition(Map<String, Object> params) {
        if (Objects.nonNull(params.get("content"))) {
            try {
                Map conditon = (Map)JsonUtil.jsonStringToObject((String)MapUtils.getString(params, (Object)"content"), Map.class);
                return conditon.containsKey("t");
            }
            catch (Exception e) {
                logger.error("isQrCodeSearchTaskCondition qrCode is : {}", params.get("content"));
            }
        }
        return false;
    }

    public static boolean isArray(String str) {
        try {
            new JSONArray((CharSequence)str);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private Action webViewAction(String url) {
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
        action.setRequestUrl(url);
        return action;
    }

    private Action invalidAction(String locale) {
        Action action = new Action();
        action.setType(ActionTypeEnum.POP_PROMPT.getValue());
        PopPromptMsg popPromptMsg = new PopPromptMsg();
        popPromptMsg.setTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u63d0\u793a"));
        popPromptMsg.setContent(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u4e8c\u7ef4\u7801\u5931\u6548"));
        Button button = new Button();
        button.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u786e\u5b9a"));
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        button.setAction(new Action(ActionTypeEnum.BACK.getValue()));
        ArrayList<Button> buttonList = new ArrayList<Button>();
        buttonList.add(button);
        popPromptMsg.setButtonList(buttonList);
        action.setPopPromptMsg(popPromptMsg);
        return action;
    }

    private boolean checkTimeStamp(String timestampStr) {
        if (!StringUtils.hasLength((String)timestampStr)) {
            return false;
        }
        long timestamp = Long.parseLong(timestampStr);
        long currentTime = System.currentTimeMillis();
        return currentTime - timestamp <= 600000L;
    }

    private Map<String, String> decrypt(Map<String, String> map, String aesKey) {
        Set<String> keys = map.keySet();
        keys.stream().forEach(key -> {
            String value = (String)map.get(key);
            try {
                value = AESUtil.decrypt((String)aesKey, (String)value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            map.put((String)key, value);
        });
        return map;
    }
}

