/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonBizReportBuilder;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCard;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabsComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.BaseTitleBodyBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildBizReportStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="taskDetailBuildApcProjectScheduleReportListStrategy")
public class TaskDetailBuildApcProjectScheduleReportListStrategy
implements TaskDetailBuildStrategy {
    private static final Logger log = LoggerFactory.getLogger(TaskDetailBuildApcProjectScheduleReportListStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private TaskDetailBuildBizReportStrategy taskDetailBuildBizReportStrategy;
    @Autowired
    private BaseTitleBodyBuilder baseTitleBodyBuilder;
    @Autowired
    private TabsComponentBuilder tabsComponentBuilder;
    @Autowired
    private BottomButtonBizReportBuilder bottomButtonBizReportBuilder;
    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    public String getTaskDetailType() {
        return "workshop_plan_syn_userproject_apc_project_schedule";
    }

    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData uiBotPageData = pageSetting.getPageModel().getPageData();
        if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_LIST.toString().equals(apiRequest.getPageId())) {
            Map woOpReportWorkHoursHistoryInfoGet;
            Object woOpReportData;
            Object woOpReportDatas;
            HashMap<String, Object> reuqestData = new HashMap<String, Object>(1);
            Object businessObject = pcUiBotModel.getExecuteContext().get((Object)"businessUnit");
            if (businessObject instanceof Map) {
                reuqestData.put("enterprise_no", ((LinkedHashMap)businessObject).get("eoc_company_id"));
                reuqestData.put("eoc_site_id", ((LinkedHashMap)businessObject).get("eoc_site_id"));
            }
            if ((woOpReportDatas = pcUiBotModel.getPageData().get((Object)"wo_op_report_data")) instanceof List) {
                HashMap<String, String> processCategory = new HashMap<String, String>();
                processCategory.put("process_category", "1");
                for (Object woOpReport : (ArrayList)woOpReportDatas) {
                    woOpReport.putAll(processCategory);
                }
                reuqestData.put("wo_op_report_data", woOpReportDatas);
            }
            if ((woOpReportData = (woOpReportWorkHoursHistoryInfoGet = this.digiwinEspProxyService.getWoOpReportWorkHoursHistoryInfoGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), reuqestData)).get("wo_op_report_data")) instanceof ArrayList) {
                for (Map woOpReport : (ArrayList)woOpReportData) {
                    for (Map woOpReportdata : (ArrayList)woOpReportDatas) {
                        if (!woOpReportdata.get("op_seq").equals(woOpReport.get("op_seq"))) continue;
                        woOpReportdata.put("standard_work_hours", woOpReport.get("standard_work_hours"));
                        woOpReportdata.put("total_work_hours", woOpReport.get("total_work_hours"));
                    }
                }
            }
        }
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case "TITLE_BODY": {
                    taskDetailBizReport.put((Object)layout.getSchema(), (Object)this.baseTitleBodyBuilder.build(apiRequest, pageSetting, pcUiBotModel, TitleBody.class, args));
                    break;
                }
                case "CARD": {
                    Card card = (Card)JsonUtil.objectToJavaObject((Object)uiBotPageData.get((Object)layout.getSchema()), Card.class);
                    Card.handle((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (Card)card);
                    taskDetailBizReport.put((Object)layout.getSchema(), (Object)card);
                    break;
                }
                case "BLANK_AREA": {
                    taskDetailBizReport.put((Object)layout.getSchema(), JsonUtil.objectToJavaObject((Object)uiBotPageData.get((Object)layout.getSchema()), BlankArea.class));
                    break;
                }
                case "CUSTOM_TABS": {
                    CustomTabs customTabs = (CustomTabs)JsonUtil.objectToJavaObject((Object)uiBotPageData.get((Object)layout.getSchema()), CustomTabs.class);
                    Map defaultDataMap = TaskDataExtractUtil.getDefaultData((String)pageSetting.getPageId());
                    String rightTitleField = String.valueOf(defaultDataMap.get("rightTitleField"));
                    String[] contentFields = (String[])defaultDataMap.get("contentFields");
                    int contentFieldsLimit = Integer.parseInt(defaultDataMap.get("contentFieldsLimit").toString());
                    Map valueToTextMap = (Map)defaultDataMap.get("valueToTextMap");
                    String bizDataSchema = StringUtils.isNotBlank((CharSequence)pcUiBotModel.searchBizDataSchema()) ? pcUiBotModel.searchBizDataSchema() : "wo_op_report_data";
                    List bizDataList = (List)pcUiBotModel.getPageData().get((Object)bizDataSchema);
                    int maxNum = 100;
                    int[] progressPercentageArr = new int[maxNum + 1];
                    for (int i = 0; i <= maxNum; ++i) {
                        progressPercentageArr[i] = i;
                    }
                    boolean isTeamTask = apiRequest.getRawData().getBooleanValue("isTeamTask");
                    List cardList = bizDataList.stream().map(item -> TabItemCard.createApcScheduleReportCard((ApiRequest)apiRequest, (UiBotModel)pcUiBotModel, (Map)item, (!isTeamTask ? 1 : 0) != 0, (String)rightTitleField, (String[])contentFields, (int)contentFieldsLimit, (Map)valueToTextMap, (int[])progressPercentageArr, (LocaleService)this.localeService, (int)bizDataList.size())).collect(Collectors.toList());
                    ZtbViewList ztbViewList = new ZtbViewList();
                    ztbViewList.setData(cardList);
                    CustomTabContentContainer container = new CustomTabContentContainer();
                    container.setData((Object)ztbViewList);
                    container.setContentCmptType("ZTB_VIEW_LIST");
                    customTabs.forEach(item -> {
                        item.setName(this.localeService.getLanguageValue(apiRequest.getLocale(), item.getName()));
                        item.setContent(Collections.singletonList(container));
                    });
                    taskDetailBizReport.put((Object)layout.getSchema(), (Object)customTabs);
                }
            }
        }
        return taskDetailBizReport;
    }

    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object ... args) {
        if (ObjectUtils.isNotEmpty((Object)pcUiBotModel.getFinished()) && pcUiBotModel.getFinished().booleanValue()) {
            return UiBotModel.workReminderEmptyImageUibotModel((String)apiRequest.getLocale());
        }
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return this.uiBotModelBuildService.buildModel(pageSetting, (Object)taskDetail, Boolean.valueOf(true));
    }
}

