/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.account;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.JsRuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.task.model.ReconciliationProgressReasonEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildReconciliationProgressReportStrategy")
public class TaskDetailBuildReconciliationProgressReportStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReconciliationProgressReportStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private JsRuleService jsRuleService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Reconciliation Progress Report Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        List jsRuleList = this.jsRuleService.findByPageId(pageSetting.getPageId());
        if (!CollectionUtils.isEmpty((Collection)jsRuleList)) {
            ArrayList uiBotRuleList = new ArrayList(2);
            jsRuleList.forEach(jsRule -> {
                UiBotRule uiBotRule = new UiBotRule();
                BeanUtils.copyProperties((Object)jsRule, (Object)uiBotRule);
                uiBotRuleList.add(uiBotRule);
            });
            if (uiBotModel != null) {
                uiBotModel.setRules(uiBotRuleList);
            }
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    InputWindowSingleSelect inputWindowSingleSelect = this.buildInputWindowSingleSelect(schema, locale);
                    pageData.put((Object)schema, (Object)inputWindowSingleSelect);
                    break;
                }
                case "INPUT_CALENDAR": {
                    InputCalendar inputCalendar = this.buildInputCalendar(layout, locale);
                    pageData.put((Object)schema, (Object)inputCalendar);
                    break;
                }
                case "INPUT_MULTI": {
                    InputMultiText inputMultiText = this.buildInputMultiText(schema, locale);
                    pageData.put((Object)schema, (Object)inputMultiText);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttonList = this.buildButton(apiRawData, locale);
                    pageData.put((Object)schema, (Object)buttonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private InputCalendar buildInputCalendar(UiBotLayout layout, String locale) {
        layout.setHeaderName(this.localeService.getLanguageValue(locale, "\u9884\u8ba1\u7acb\u8d26\u65e5"));
        InputCalendar inputCalendar = InputCalendar.create((UiBotLayout)layout, null, (String)locale);
        inputCalendar.setMinDateSelectable(InputCalendarDate.createToday());
        ArrayList<InputCalendarDate> calendarDateList = new ArrayList<InputCalendarDate>();
        calendarDateList.add(InputCalendarDate.createToday());
        inputCalendar.setDateValueList(calendarDateList);
        inputCalendar.setRequired(Boolean.valueOf(true));
        return inputCalendar;
    }

    private InputWindowSingleSelect buildInputWindowSingleSelect(String schema, String locale) {
        HashMap<String, Boolean> rawDataMap = new HashMap<String, Boolean>(1);
        rawDataMap.put("isReconciliationProgress", true);
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(schema);
        windowSingleSelect.setTitle(this.localeService.getLanguageValue(locale, "\u65b0\u589e\u539f\u56e0\u7801"));
        windowSingleSelect.setRawData(rawDataMap);
        windowSingleSelect.setType("WINDOW_SINGLE_SELECT");
        windowSingleSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u9009\u62e9"));
        windowSingleSelect.setDefaultSelectId(ReconciliationProgressReasonEnum.D15.getCode());
        windowSingleSelect.setDefaultShowValue(ReconciliationProgressReasonEnum.D15.getDesc());
        windowSingleSelect.setRequired(Boolean.valueOf(true));
        return windowSingleSelect;
    }

    private InputMultiText buildInputMultiText(String schema, String locale) {
        InputMultiText inputMultiText = null;
        if ("handle_desc".equalsIgnoreCase(schema)) {
            inputMultiText = InputMultiText.create((String)schema, (String)this.localeService.getLanguageValue(locale, "\u5904\u7406\u63cf\u8ff0"), (String)"", (Boolean)true, (Boolean)false, (Boolean)false, (String)locale);
        }
        if ("internal_instructions".equalsIgnoreCase(schema)) {
            inputMultiText = InputMultiText.create((String)schema, (String)this.localeService.getLanguageValue(locale, "\u5185\u90e8\u8bf4\u660e"), (String)"", (Boolean)true, (Boolean)false, (Boolean)false, (String)locale);
        }
        return inputMultiText;
    }

    private List<BottomButtonDigiwinAthena> buildButton(ApiRawData apiRawData, String locale) {
        BottomButtonDigiwinAthena offlineButton = new BottomButtonDigiwinAthena();
        offlineButton.setName(this.localeService.getLanguageValue(locale, "\u63d0\u4ea4"));
        apiRawData.put("buttonType", (Object)"progressReport");
        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
        buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/reconciliationProgress/submit");
        buttonAction.setRawData((Object)apiRawData);
        offlineButton.setAction(buttonAction);
        offlineButton.setType(BottomButtonStyleEnum.STRESS.getValue());
        return Collections.singletonList(offlineButton);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

