/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.aide;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildOutSourceWorkReportTaskDetailStrategy")
public class TaskDetailBuildOutSourceWorkReportTaskDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildOutSourceWorkReportTaskDetailStrategy.class);
    private static final String ESP_ACTION_EMPLOYEE_DATA_GET = "esp_ca.cim.tt.athena.employee.data.get";
    private static final String ACTION_EMPLOYEE_DATA_GET = "ca.cim.tt.athena.employee.data.get";
    private static final String GROUPID_PREFIX = "Group";
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build OutSource Work Task Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        String digiProxyToken = apiRawData.getString("digi-proxy-token");
        Map outsourcingReport = (Map)apiRawData.get((Object)"outsourcing_report");
        String tenantId = (String)outsourcingReport.get("tenant_id");
        List reportInfoList = this.getReportDetail(apiRequest, outsourcingReport, digiProxyToken);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    Object reportInfo2;
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)pageData.get((Object)schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    List uiBotLayoutList = customGroupContent.getLayout();
                    ArrayList<String> initGroupIds = new ArrayList<String>();
                    LinkedList uiBotLayoutCopyLinkedList = new LinkedList();
                    int suffixIndex = 0;
                    if (!CollectionUtils.isEmpty((Collection)reportInfoList)) {
                        for (Object reportInfo2 : reportInfoList) {
                            List uiBotLayoutCopyList = this.handleUiBotLayoutList(uiBotLayoutList, customGroupContent, apiRawData, (Map)reportInfo2, locale, suffixIndex, true, tenantId);
                            uiBotLayoutCopyLinkedList.addAll(uiBotLayoutCopyList);
                            initGroupIds.add(GROUPID_PREFIX + suffixIndex);
                            ++suffixIndex;
                        }
                    } else {
                        List uiBotLayoutCopyList = this.handleUiBotLayoutList(uiBotLayoutList, customGroupContent, apiRawData, Collections.emptyMap(), locale, suffixIndex, false, tenantId);
                        uiBotLayoutCopyLinkedList.addAll(uiBotLayoutCopyList);
                        initGroupIds.add(GROUPID_PREFIX + suffixIndex);
                    }
                    customGroup.setInitGroupIds(initGroupIds);
                    customGroupContent.setLayout(uiBotLayoutCopyLinkedList);
                    CustomGroupContent customGroupCopyContent = customGroup.getContentCopy();
                    reportInfo2 = customGroupCopyContent.getLayout().iterator();
                    while (reportInfo2.hasNext()) {
                        UiBotLayout uiBotLayout = (UiBotLayout)reportInfo2.next();
                        this.handleCustomGroup(uiBotLayout, customGroupCopyContent.getPageData(), locale, apiRawData, "", tenantId);
                    }
                    pageData.put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    List buttonList = this.buildButton(locale, outsourcingReport, digiProxyToken);
                    pageData.put((Object)schema, (Object)buttonList);
                }
            }
        }
        return uiBotModel;
    }

    private List<UiBotLayout> handleUiBotLayoutList(List<UiBotLayout> uiBotLayoutList, CustomGroupContent customGroupContent, ApiRawData apiRawData, Map<String, Object> reportInfo, String locale, int suffixIndex, boolean hasInitVal, String tenantId) {
        List<UiBotLayout> uiBotLayoutCopyList = uiBotLayoutList.stream().map(e -> {
            UiBotLayout uiBotLayoutCopy = new UiBotLayout();
            BeanUtils.copyProperties((Object)e, (Object)uiBotLayoutCopy);
            return uiBotLayoutCopy;
        }).collect(Collectors.toList());
        for (UiBotLayout uiBotLayoutCopyDetail : uiBotLayoutCopyList) {
            String customGroupContentSchema = uiBotLayoutCopyDetail.getSchema();
            if (StringUtils.isNotEmpty((CharSequence)customGroupContentSchema)) {
                uiBotLayoutCopyDetail.setSchema(customGroupContentSchema + "_" + GROUPID_PREFIX + suffixIndex);
            }
            uiBotLayoutCopyDetail.setGroupId(GROUPID_PREFIX + suffixIndex);
            if (hasInitVal) {
                this.handleCustomGroup(uiBotLayoutCopyDetail, customGroupContent.getPageData(), locale, apiRawData, String.valueOf(MapUtil.getOrDefault(reportInfo, (String)customGroupContentSchema, (Object)"")), tenantId);
                continue;
            }
            this.handleCustomGroup(uiBotLayoutCopyDetail, customGroupContent.getPageData(), locale, apiRawData, "", tenantId);
        }
        return uiBotLayoutCopyList;
    }

    private List<Map<String, Object>> getReportDetail(ApiRequest apiRequest, Map<String, Object> outsourcingReport, String digiProxyToken) {
        HashMap<String, Object> reportInfoMap = new HashMap<String, Object>(1);
        reportInfoMap.put("outsourcing_report_id", outsourcingReport.get("id"));
        HashMap parameterMap = new HashMap(1);
        parameterMap.put("report_info", Collections.singletonList(reportInfoMap));
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>(2);
        requestParamMap.put("actionId", "ca.cim.outsourcing.report.detail.info.get");
        requestParamMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse employeeInfo = this.digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), digiProxyToken, requestParamMap);
        List<Map<String, Object>> reportInfoList = Optional.ofNullable(employeeInfo).map(DigiwinAthenaApiResponse::getResponse).map(e -> (List)e.get((Object)"report_info")).orElse(Collections.emptyList());
        return reportInfoList;
    }

    private void handleCustomGroup(UiBotLayout layout, UiBotPageData pageData, String locale, ApiRawData apiRawData, String value, String tenantId) {
        String schema = layout.getSchema();
        switch (layout.getType()) {
            case "INPUT_SINGLE": {
                InputSingleText inputSingleText = this.buildInputSingleText(layout, value);
                pageData.put((Object)schema, (Object)inputSingleText);
                break;
            }
            case "INPUT_NUMERIC": {
                InputNumeric inputNumeric = this.buildInputNumeric(layout, value, locale);
                pageData.put((Object)schema, (Object)inputNumeric);
                break;
            }
            case "WINDOW_SINGLE_SELECT": {
                InputWindowSingleSelect inputWindowSingleSelect = this.buildInputWindowSingleSelect(layout, apiRawData, schema, value, locale, tenantId);
                pageData.put((Object)schema, (Object)inputWindowSingleSelect);
                break;
            }
        }
    }

    private InputSingleText buildInputSingleText(UiBotLayout uiBotLayout, String value) {
        InputSingleText inputSingleText = InputSingleText.create((String)uiBotLayout.getLabel(), (String)value);
        inputSingleText.setEnable(Boolean.valueOf(false));
        if (StringUtils.isEmpty((CharSequence)value)) {
            inputSingleText.setHidden(Boolean.valueOf(true));
        }
        return inputSingleText;
    }

    private InputNumeric buildInputNumeric(UiBotLayout uiBotLayout, String value, String locale) {
        InputNumeric inputNumeric = InputNumeric.create((Integer)99999999, (Integer)2, (String)value, (String)this.localeService.getLanguageValue(locale, uiBotLayout.getLabel()), (Integer)InputNumericTypeEnum.INTEGER.getValue(), (Boolean)false, (String)"");
        inputNumeric.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165"));
        return inputNumeric;
    }

    private InputWindowSingleSelect buildInputWindowSingleSelect(UiBotLayout uiBotLayout, ApiRawData apiRawData, String schema, String value, String locale, String tenantId) {
        Map rawDataMap = this.buildEmployeeDataSourceList(apiRawData.getString("eoc_company_id"), apiRawData.getString("digi-proxy-token"), tenantId);
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(uiBotLayout.getLabel());
        windowSingleSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        windowSingleSelect.setRawData(rawDataMap);
        windowSingleSelect.setType("WINDOW_SINGLE_SELECT");
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(this.localeService.getLanguageValue(locale, "\u8bf7\u9009\u62e9"));
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            windowSingleSelect.setDefaultSelectId(value);
            windowSingleSelect.setDefaultShowValue(value);
        }
        windowSingleSelect.setRequired(Boolean.valueOf(true));
        return windowSingleSelect;
    }

    private List<BottomButtonDigiwinAthena> buildButton(String locale, Map<String, Object> outsourcingReportData, String digiProxyToken) {
        ArrayList<BottomButtonDigiwinAthena> buttonList = new ArrayList<BottomButtonDigiwinAthena>(2);
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton((String)locale);
        buttonList.add(cancelButton);
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>();
        requestParamMap.put("actionId", "ca.cim.outsourcing.report.detail.info.update");
        requestParamMap.put("outsourcing_report_id", outsourcingReportData.get("id"));
        requestParamMap.put("digi-proxy-token", digiProxyToken);
        requestParamMap.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_TASK_DETAIL.toString());
        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
        buttonAction.setRawData(requestParamMap);
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(this.localeService.getLanguageValue(locale, "\u4fdd\u5b58"));
        button.setAction(buttonAction);
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        buttonList.add(button);
        return buttonList;
    }

    private Map<String, Object> buildEmployeeDataSourceList(String eocCompanyId, String proxyToken, String tenantId) {
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO = new PcUiBotDataSourceDTO();
        pcUiBotDataSourceDTO.setDataKeys(Collections.singletonList("employee_no"));
        pcUiBotDataSourceDTO.setType("ESP");
        pcUiBotDataSourceDTO.setActionId(ESP_ACTION_EMPLOYEE_DATA_GET);
        PcUiBotQueryAction pcUiBotQueryAction = new PcUiBotQueryAction();
        pcUiBotQueryAction.setTitle("\u5458\u5de5\u4fe1\u606f");
        pcUiBotQueryAction.setActionId(ESP_ACTION_EMPLOYEE_DATA_GET);
        pcUiBotQueryAction.setCategory("ESP");
        PcUiBotActionServiceId pcUiBotActionServiceId = new PcUiBotActionServiceId();
        pcUiBotActionServiceId.setName(ACTION_EMPLOYEE_DATA_GET);
        pcUiBotActionServiceId.setHostAcct("athena");
        pcUiBotActionServiceId.setTenant_id(tenantId);
        pcUiBotQueryAction.setServiceId(pcUiBotActionServiceId);
        PcUiBotActionParameterMapping pcUiBotActionParameterMapping = new PcUiBotActionParameterMapping();
        pcUiBotActionParameterMapping.setName("eoc_company_id");
        pcUiBotActionParameterMapping.setType("CONSTANT");
        pcUiBotActionParameterMapping.setValue(eocCompanyId);
        pcUiBotQueryAction.setActionParams(Collections.singletonList(pcUiBotActionParameterMapping));
        HashMap<String, String> businessUnitMap = new HashMap<String, String>(1);
        businessUnitMap.put("eoc_company_id", eocCompanyId);
        pcUiBotQueryAction.setBusinessUnit(businessUnitMap);
        pcUiBotDataSourceDTO.setAction(pcUiBotQueryAction);
        ArrayList<PcUiBotDataSourceDTO> dataSourceList = new ArrayList<PcUiBotDataSourceDTO>();
        dataSourceList.add(pcUiBotDataSourceDTO);
        HashMap<String, ArrayList<PcUiBotDataSourceDTO>> dataSourceListMap = new HashMap<String, ArrayList<PcUiBotDataSourceDTO>>(1);
        dataSourceListMap.put("dataSourceList", dataSourceList);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("dataSourceSet", dataSourceListMap);
        HashMap<String, String> executeContextMap = new HashMap<String, String>(1);
        executeContextMap.put("proxyToken", proxyToken);
        paramMap.put("executeContext", executeContextMap);
        return paramMap;
    }

    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        List groupSubmitParamList = apiRequestSubmit.getGroupSubmitParamList();
        if (CollectionUtils.isEmpty((Collection)groupSubmitParamList)) {
            return ActionSubmitResult.create((boolean)false, (String)this.localeService.getLanguageValue(locale, "\u8bf7\u8f93\u5165\u62a5\u5de5\u660e\u7ec6"));
        }
        ApiRawData rawData = apiRequestSubmit.getRawData();
        HashSet<String> employeeNoSet = new HashSet<String>();
        ArrayList reportInfoDetailList = new ArrayList();
        for (List actionSubmitParamList : groupSubmitParamList) {
            HashMap<String, String> reportInfoDetail = new HashMap<String, String>(6);
            reportInfoDetail.put("outsourcing_report_id", rawData.getString("outsourcing_report_id"));
            for (ActionSubmitParam actionSubmitParam : actionSubmitParamList) {
                switch (actionSubmitParam.getType()) {
                    case "INPUT_NUMERIC": {
                        String schema = actionSubmitParam.getSchema();
                        Map paramMap = (Map)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), Map.class);
                        if (schema.startsWith("work_hours")) {
                            reportInfoDetail.put("work_hours", (String)paramMap.get("text"));
                        }
                        if (schema.startsWith("machine_hours")) {
                            reportInfoDetail.put("machine_hours", (String)paramMap.get("text"));
                        }
                        if (!schema.startsWith("adjust_hours")) break;
                        reportInfoDetail.put("adjust_hours", (String)paramMap.get("text"));
                        break;
                    }
                    case "WINDOW_SINGLE_SELECT": {
                        Map paramMap = (Map)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), Map.class);
                        reportInfoDetail.put("employee_no", (String)paramMap.get("selectId"));
                        if (employeeNoSet.contains(reportInfoDetail.get("employee_no"))) {
                            return ActionSubmitResult.create((boolean)false, (String)this.localeService.getLanguageValue(locale, "\u5458\u5de5" + reportInfoDetail.get("employee_no") + "\u5b58\u5728\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u6838\u67e5"));
                        }
                        employeeNoSet.add((String)reportInfoDetail.get("employee_no"));
                        Map detailMap = (Map)JsonUtil.objectToJavaObject(paramMap.get("detail"), Map.class);
                        if (detailMap == null) break;
                        reportInfoDetail.put("employee_name", (String)detailMap.get("employee_name"));
                        break;
                    }
                }
            }
            if (StringUtil.isEmpty(reportInfoDetail.get("work_hours")) && StringUtil.isEmpty(reportInfoDetail.get("machine_hours")) && StringUtil.isEmpty(reportInfoDetail.get("adjust_hours"))) {
                return ActionSubmitResult.create((boolean)false, (String)this.localeService.getLanguageValue(locale, "\u51fa\u52e4\u65f6\u6570\u3001\u5f00\u673a\u65f6\u95f4\u3001\u8c03\u89c4\u65f6\u95f4\u5b57\u6bb5\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a"));
            }
            reportInfoDetailList.add(reportInfoDetail);
        }
        HashMap reportInfoMap = new HashMap(1);
        reportInfoMap.put("report_info", reportInfoDetailList);
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>(2);
        requestParamMap.put("parameter", reportInfoMap);
        requestParamMap.put("actionId", rawData.getString("actionId"));
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), rawData.getString("digi-proxy-token"), requestParamMap);
        boolean isSuccess = resp.getStatus() == 200 && StringUtil.isEmpty((CharSequence)resp.getErrorMessage());
        Action action = new Action();
        if (isSuccess) {
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL.toString());
            action.setSuccessMsg(this.localeService.getLanguageValue(locale, "\u4fdd\u5b58\u6210\u529f"));
            return ActionSubmitResult.create((boolean)true, (Action)action);
        }
        action.setType(ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());
        action.setToastMsg(this.localeService.getLanguageValue(locale, "\u4fdd\u5b58\u5931\u8d25"));
        return ActionSubmitResult.create((boolean)false, (Action)action);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

