/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.mergeworkhour;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildApcRemarkDetailStrategy")
public class TaskDetailBuildApcRemarkDetailStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildApcRemarkDetailStrategy.class);
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Remark Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        this.initDataHandle(apiRequest);
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map rawData = apiRequest.getRawData().getInnerMap();
        Map dataDetail = (Map)MapUtil.getOrDefault((Map)rawData, (String)"data", Collections.emptyMap());
        List bottomButtonList = (List)JsonUtil.objectToJavaObject((Object)MapUtil.getOrDefault((Map)rawData, (String)"buttonList", Collections.emptyList()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        boolean isRemarkRequired = (Boolean)MapUtil.getOrDefault((Map)rawData, (String)"isRemarkRequired", (Object)false);
        boolean isShowDispatchRemark = (Boolean)MapUtil.getOrDefault((Map)rawData, (String)"isShowDispatchRemark", (Object)true);
        if (((Boolean)MapUtil.getOrDefault((Map)rawData, (String)"isMergeWorkHour", (Object)false)).booleanValue()) {
            List selectCardList = (List)rawData.get("selectCardList");
            for (Map selectCard : selectCardList) {
                String remark;
                Map selectCardRawData = (Map)selectCard.get("rawData");
                Map dataDetaiMap = (Map)selectCardRawData.get("dataDetail");
                if (CollectionUtils.isEmpty((Map)dataDetaiMap) || !StringUtils.isNotEmpty((CharSequence)(remark = MapUtils.getString((Map)dataDetaiMap, (Object)"remark")))) continue;
                dataDetail.put("remark", remark);
                break;
            }
            bottomButtonList.stream().filter(bottomButtonDigiwinAthena -> 1 == bottomButtonDigiwinAthena.getType()).map(Button::getAction).map(action -> (Map)action.getRawData()).forEach(map -> {
                map.put("selectCardList", rawData.get("selectCardList"));
                map.put("isRemarkAction", true);
            });
        }
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotModel dynamicsUiBotModel = (UiBotModel)JsonUtil.objectToJavaObject((Object)MapUtil.getOrDefault((Map)rawData, (String)"dynamics_uiBotModel", (Object)UiBotModel.emptyUiBotModel()), UiBotModel.class);
        List dynamicsUiBotLayouts = Optional.ofNullable(dynamicsUiBotModel).map(UiBotModel::getLayout).orElse(Collections.emptyList());
        LinkedList<Object> newUiBotLayouts = new LinkedList<Object>();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            if (!CollectionUtils.isEmpty(dynamicsUiBotLayouts) && "dynamics_label".equalsIgnoreCase(schema)) {
                newUiBotLayouts.addAll(dynamicsUiBotLayouts);
                pageData.putAll((Map)dynamicsUiBotModel.getPageData());
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)layout.getType())) continue;
            switch (layout.getType()) {
                case "FIELD": {
                    if (!isShowDispatchRemark) break;
                    String name = this.localeService.getLanguageValue(locale, layout.getLabel());
                    String data = String.valueOf(MapUtil.getOrDefault((Map)dataDetail, (String)schema, (Object)""));
                    Field field = Field.createLabelLeftValueRightField((String)name, (String)data);
                    newUiBotLayouts.add(layout);
                    pageData.put((Object)schema, (Object)field);
                    break;
                }
                case "INPUT_MULTI": {
                    String text = String.valueOf(MapUtil.getOrDefault((Map)dataDetail, (String)schema, (Object)""));
                    newUiBotLayouts.add(layout);
                    pageData.put((Object)schema, (Object)InputMultiText.create((String)schema, (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)text, (Boolean)true, (Boolean)isRemarkRequired, (Boolean)true, (String)locale, (Integer)255));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    if (CollectionUtils.isEmpty((Collection)bottomButtonList)) break;
                    newUiBotLayouts.add(layout);
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        uiBotModel.setLayout(newUiBotLayouts);
        return uiBotModel;
    }

    public void initDataHandle(ApiRequest apiRequest) {
        if (CollectionUtils.isEmpty((Collection)apiRequest.getSubmitParam())) {
            return;
        }
        ApiRawData rawData = apiRequest.getRawData();
        Map dataDetail = (Map)MapUtil.getOrDefault((Map)rawData, (String)"data", Collections.emptyMap());
        for (ActionSubmitParam actionSubmitParam : apiRequest.getSubmitParam()) {
            switch (actionSubmitParam.getType()) {
                case "INPUT_MULTI": {
                    InputMultiText inputMultiText = (InputMultiText)JsonUtil.objectToJavaObject((Object)actionSubmitParam.getParams(), InputMultiText.class);
                    dataDetail.put(actionSubmitParam.getSchema(), inputMultiText.getText());
                    break;
                }
            }
        }
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

