/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.schedulereport;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.FileMaxSize;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component(value="taskDetailBuildApcCommonAttachmentUploadStrategy")
public class TaskDetailBuildApcCommonAttachmentUploadStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildApcCommonAttachmentUploadStrategy.class);
    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;
    @Autowired
    private LocaleService localeService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build APC Attachemnt Upload Page");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        uiBotModel = useMockData == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map rawData = apiRequest.getRawData().getInnerMap();
        stopWatch.start("Build APC Attachemnt Upload Page Model...");
        List uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "CUSTOM_GROUP": {
                    CustomGroup customGroup = (CustomGroup)JsonUtil.objectToJavaObject((Object)uiBotModel.getPageData().get((Object)schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    List customGroupUiBotLayouts = customGroupContent.getLayout();
                    for (UiBotLayout customGroupUiBotLayout : customGroupUiBotLayouts) {
                        String customGroupSchema = customGroupUiBotLayout.getSchema();
                        switch (customGroupUiBotLayout.getType()) {
                            case "ATTACHMENT": {
                                Attachment attachment = new Attachment();
                                attachment.setTitle(this.localeService.getLanguageValue(locale, customGroupUiBotLayout.getLabel()));
                                attachment.setFileMaxSize(new FileMaxSize(Long.valueOf(0x1E00000L), Long.valueOf(0x1E00000L)));
                                attachment.setLimit(Integer.valueOf(10));
                                attachment.setRequired(Boolean.valueOf(true));
                                AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
                                attachment.setRawData((AttachmentRawData)attachmentRawDataDigiwinAthena);
                                customGroupContent.getPageData().put((Object)customGroupSchema, (Object)attachment);
                            }
                        }
                    }
                    uiBotModel.getPageData().put((Object)schema, (Object)customGroup);
                    break;
                }
                case "BOTTOM_BUTTON": {
                    ArrayList<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<BottomButtonDigiwinAthena>();
                    BottomButtonDigiwinAthena submitButton = new BottomButtonDigiwinAthena();
                    submitButton.setName(this.localeService.getLanguageValue(locale, "\u63d0\u4ea4"));
                    Action buttonAction = new Action();
                    buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
                    buttonAction.setRawData((Object)rawData);
                    submitButton.setAction(buttonAction);
                    ModuleUtils.addRefreshPageId((BottomButtonDigiwinAthena)submitButton, (String)apiRequest.getRefreshPageId());
                    bottomButtonList.add(submitButton);
                    uiBotModel.getPageData().put((Object)schema, bottomButtonList);
                    break;
                }
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map rawData = apiRequestSubmit.getRawData().getInnerMap();
        Map data = (Map)MapUtil.getOrDefault((Map)rawData, (String)"data", Collections.emptyMap());
        HashMap submitRawData = new HashMap();
        submitRawData.put("wo_no", data.get("wo_no"));
        submitRawData.put("plot_no", data.get("plot_no"));
        submitRawData.put("op_seq", data.get("op_seq"));
        submitRawData.put("op_no", data.get("op_no"));
        submitRawData.put("sub_op_seq", data.get("sub_op_seq"));
        submitRawData.put("sub_op_no", data.get("sub_op_no"));
        submitRawData.put("check_in_datetime", DateTimeUtil.getTodayTimeUseDefaultPattern());
        submitRawData.put("eoc_company_id", data.get("eoc_company_id"));
        submitRawData.put("eoc_site_id", data.get("eoc_site_id"));
        submitRawData.put("source_type", rawData.get("source_type"));
        submitRawData.put("submit_time", DateTimeUtil.getTodayTimeUseDefaultPattern());
        EocPersonInfo eocPersonInfo = this.digiwinEocProxyService.getEocPersonInfo(apiRequestSubmit.getUserId(), apiRequestSubmit.getIamUserToken(), 2);
        submitRawData.put("reporter_no", Optional.ofNullable(eocPersonInfo).map(EocPersonInfo::getEocId).orElse(apiRequestSubmit.getUserId()));
        submitRawData.put("reporter_name", Optional.ofNullable(eocPersonInfo).map(EocPersonInfo::getName).orElse(""));
        for (ActionSubmitParam actionSubmitParam : apiRequestSubmit.getSubmitParams()) {
            switch (actionSubmitParam.getType()) {
                case "ATTACHMENT": {
                    Attachment attachment = (Attachment)actionSubmitParam.getParams();
                    submitRawData.put("attachment", attachment.parseToUiBotAttachment(attachment, this.digiwinDmcProxyService));
                    break;
                }
            }
        }
        HashMap reportInfoMap = new HashMap(1);
        reportInfoMap.put("wo_op_report_attachment_data", Collections.singletonList(submitRawData));
        HashMap<String, Object> requestParamMap = new HashMap<String, Object>(2);
        requestParamMap.put("parameter", reportInfoMap);
        requestParamMap.put("actionId", "bm.opsc.lc.wo.op.report.attachment.create");
        DigiwinAthenaApiResponse resp = this.digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", requestParamMap);
        boolean isSuccess = resp.getStatus() == 200 && StringUtil.isEmpty((CharSequence)resp.getErrorMessage());
        Action action = new Action();
        if (isSuccess) {
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL.toString());
            action.setSuccessMsg(this.localeService.getLanguageValue(locale, "\u63d0\u4ea4\u6210\u529f"));
            return ActionSubmitResult.create((boolean)true, (Action)action);
        }
        action.setType(ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());
        action.setToastMsg(this.localeService.getLanguageValue(locale, "\u63d0\u4ea4\u5931\u8d25"));
        return ActionSubmitResult.create((boolean)false, (Action)action);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}

