/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.JsRuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Component(value="uiBotModelBuildTbdsProductionProgressRecordRejectSubmitStrategy")
public class UiBotModelBuildTbdsProductionProgressRecordRejectSubmitStrategy
implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildTbdsProductionProgressRecordRejectSubmitStrategy.class);
    @Autowired
    private LocaleService localeService;
    @Autowired
    private JsRuleService jsRuleService;

    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Tbds production progress report reject submit");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel = useMockData == false && modelTypeShow == false ? this.doActually(pageSetting, apiRequest, stopWatch) : this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());
        List jsRuleList = this.jsRuleService.findByPageId(pageSetting.getPageId());
        if (!CollectionUtils.isEmpty((Collection)jsRuleList)) {
            ArrayList uiBotRuleList = new ArrayList(1);
            jsRuleList.forEach(jsRule -> {
                UiBotRule uiBotRule = new UiBotRule();
                BeanUtils.copyProperties((Object)jsRule, (Object)uiBotRule);
                uiBotRuleList.add(uiBotRule);
            });
            if (uiBotModel != null) {
                uiBotModel.setRules(uiBotRuleList);
            }
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case "WINDOW_SINGLE_SELECT": {
                    if (!"reject_to_op_seq".equals(schema)) break;
                    HashMap<String, Object> mobileOpDatas = new HashMap(2);
                    mobileOpDatas.put("type", schema);
                    mobileOpDatas.put("isTbds", true);
                    mobileOpDatas.put("mobileOpDatas", rawData.get("mobileOpDatas"));
                    pageData.put((Object)schema, (Object)InputWindowSingleSelect.create((UiBotLayout)layout, (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list"), (String)locale, mobileOpDatas, (LocaleService)this.localeService, (String)"", (Boolean)true, (Boolean)true));
                    break;
                }
                case "WINDOW_MULTI_SELECT": {
                    HashMap<String, Object> mobileOpDatas = new HashMap<String, Object>(1);
                    mobileOpDatas.put("type", schema);
                    mobileOpDatas.put("isTbds", true);
                    mobileOpDatas.put("mobileOpDatas", rawData.get("mobileOpDatas"));
                    InputWindowMultiSelect inputWindowMultiSelect = InputWindowMultiSelect.create((UiBotLayout)layout, (String)(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list"), mobileOpDatas, (String)locale, (Integer)1, (Integer)InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue(), (Boolean)true, (Boolean)true, (LocaleService)this.localeService);
                    pageData.put((Object)schema, (Object)inputWindowMultiSelect);
                    break;
                }
                case "INPUT_MULTI": {
                    pageData.put((Object)schema, (Object)InputMultiText.create((String)schema, (String)this.localeService.getLanguageValue(locale, layout.getLabel()), (String)"", (Boolean)true, (Boolean)false, (Boolean)true, (String)locale, (Integer)100));
                    break;
                }
                case "BOTTOM_BUTTON": {
                    BottomButtonList bottomButtonList = (BottomButtonList)JsonUtil.objectToJavaObject((Object)pageSetting.getPageModel().getPageData().get((Object)layout.getSchema()), BottomButtonList.class);
                    bottomButtonList.forEach(arg_0 -> this.lambda$doActually$1(locale, (Map)rawData, apiRequest, arg_0));
                    pageData.put((Object)schema, (Object)bottomButtonList);
                    break;
                }
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    private /* synthetic */ void lambda$doActually$1(String locale, Map rawData, ApiRequest apiRequest, BottomButtonDigiwinAthena button) {
        button.setName(this.localeService.getLanguageValue(locale, button.getName()));
        if (button.getIsCheckButton().booleanValue()) {
            Action action = button.getAction();
            rawData.put("pageId", apiRequest.getPageId());
            rawData.put("biz_id", "TBDS");
            action.setRawData((Object)rawData);
        }
    }
}

