/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.aiassistant;

import com.digiwin.mobile.mobileuibot.aiassistant.AiAssistantController;
import com.digiwin.mobile.mobileuibot.aiassistant.model.AiAssistantSkillTypeEnum;
import com.digiwin.mobile.mobileuibot.aiassistant.model.ExampleModel;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.AiAssistantQuestionExampleRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.AssistantMockDataRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.BulletinRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectConfigQueryDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionAddRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionGroupAddOrUpdateDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionGroupDeleteDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionGroupQueryDTO;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionRemoveRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataSubscriptionRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.MessageInfoRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.NewRecordOverviewSubmitRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.TaskDistributeRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.service.AiAssistantService;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.file.dto.AgileDataLiteUploadFileQueryDTO;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AgileDataCalculateConfigRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.ProcessMessageRequest;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoInformationModelQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.EchoPageConfigProductBulletinQueryDTO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/aiassistant"})
@Validated
public class AiAssistantController {
    @Autowired
    private AiAssistantService aiAssistantService;
    @Autowired
    private LocaleService localeService;

    @PostMapping(value={"/getMessageInfo"})
    public ApiResponse<Map<String, Object>> getMessageInfo(@RequestBody MessageInfoRequest messageInfoRequest) {
        Map messageInfoRespData;
        try {
            messageInfoRespData = this.aiAssistantService.getMessageInfo(messageInfoRequest);
        }
        catch (Exception e) {
            return ApiResponse.buildError((String)e.getMessage());
        }
        return ApiResponse.buildOK().setData((Object)messageInfoRespData);
    }

    @PostMapping(value={"/submitNewRecordOverview"})
    public ApiResponse submitNewRecordOverview(@RequestBody NewRecordOverviewSubmitRequest newRecordOverviewSubmitRequest) {
        try {
            this.aiAssistantService.submitNewRecordOverview(newRecordOverviewSubmitRequest);
        }
        catch (Exception e) {
            return ApiResponse.buildError((String)e.getMessage());
        }
        return ApiResponse.buildOK();
    }

    @PostMapping(value={"/taskDistribute"})
    public ApiResponse taskDistribute(@RequestBody TaskDistributeRequest taskDistributeRequest) {
        String taskDistributeData;
        try {
            taskDistributeData = this.aiAssistantService.taskDistribute(taskDistributeRequest);
        }
        catch (Exception e) {
            return ApiResponse.buildError((String)e.getMessage());
        }
        return ApiResponse.buildOK().setData((Object)taskDistributeData);
    }

    @Deprecated
    @PostMapping(value={"/questions/example/first"})
    public ApiResponse getQuestionExamplesFirstTime(@Validated @RequestBody AiAssistantQuestionExampleRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        AiAssistantSkillTypeEnum skillTypeEnum = AiAssistantSkillTypeEnum.getEnumByValue((String)apiRequest.getSkillType());
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$aiassistant$model$AiAssistantSkillTypeEnum[skillTypeEnum.ordinal()]) {
            case 1: {
                ExampleModel example = this.aiAssistantService.getExample(iamUserToken, locale);
                if (example == null) {
                    return ApiResponse.buildOK();
                }
                return ApiResponse.buildOK().setData(JsonUtil.objectToJavaObject((Object)example, Map.class));
            }
            case 2: {
                return ApiResponse.buildOK();
            }
            case 3: {
                return ApiResponse.buildOK();
            }
        }
        return ApiResponse.buildOK();
    }

    @Deprecated
    @PostMapping(value={"/questions/example/normal"})
    public ApiResponse getQuestionExamplesInNormal(@Validated @RequestBody AiAssistantQuestionExampleRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String tenantId = apiRequest.getTenantId();
        AiAssistantSkillTypeEnum skillTypeEnum = AiAssistantSkillTypeEnum.getEnumByValue((String)apiRequest.getSkillType());
        switch (1.$SwitchMap$com$digiwin$mobile$mobileuibot$aiassistant$model$AiAssistantSkillTypeEnum[skillTypeEnum.ordinal()]) {
            case 1: {
                List questionsExampleModels = this.aiAssistantService.querySceneIntentions(apiRequest.getIamUserToken(), locale);
                return ApiResponse.buildOK().setData((Object)questionsExampleModels);
            }
            case 2: {
                String exampleDataString = this.aiAssistantService.getDocumentAssistantQuestionsExample(locale);
                return ApiResponse.buildOK().setData(JsonUtil.jsonStringToObject((String)exampleDataString, List.class));
            }
            case 3: {
                String exampleDataString = this.aiAssistantService.getAdministrativeQuestionsExample(locale);
                return ApiResponse.buildOK().setData(JsonUtil.jsonStringToObject((String)exampleDataString, List.class));
            }
        }
        return ApiResponse.buildOK();
    }

    @PostMapping(value={"getAssistantMockData"})
    public ApiResponse getAssistantMockData(@RequestBody @Validated AssistantMockDataRequest assistantMockDataRequest) {
        List assistantMockData = this.aiAssistantService.getAssistantMockData(assistantMockDataRequest);
        if (CollectionUtils.isEmpty((Collection)assistantMockData)) {
            return ApiResponse.buildOK((String)this.localeService.getLanguageValue(assistantMockDataRequest.getLocale(), "\u5f88\u62b1\u6b49\uff0c\u6211\u6682\u65f6\u8fd8\u4e0d\u652f\u6301\u8fd9\u7c7b\u95ee\u9898\u7684\u56de\u7b54"));
        }
        return ApiResponse.buildOK().setData((Object)assistantMockData);
    }

    @PostMapping(value={"getDataSubscriptionList"})
    public ApiResponse getDataSubscriptionList(@RequestBody @Validated DataSubscriptionRequest request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.getDataSubscriptionList(request));
    }

    @PostMapping(value={"addOrUpdateDataSubscription"})
    public ApiResponse addOrUpdateDataSubscription(@RequestBody @Validated DataSubscriptionRequest request) {
        Boolean b = this.aiAssistantService.addOrUpdateDataSubscription(request);
        if (StringUtils.isBlank((CharSequence)request.getDataSubscriptionModel().getRuleId())) {
            if (b.booleanValue()) {
                return ApiResponse.buildOK((String)this.localeService.getLanguageValue(request.getLocale(), "\u8ba2\u9605\u6210\u529f\uff01\u53ef\u5728\u8ba2\u9605\u7ba1\u7406\u4e2d\u4fee\u6539")).setData((Object)true);
            }
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u8ba2\u9605\u5931\u8d25\uff01\u8bf7\u91cd\u8bd5")).setData((Object)false);
        }
        if (!b.booleanValue()) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u4fee\u6539\u5931\u8d25\uff01\u8bf7\u91cd\u8bd5")).setData((Object)false);
        }
        return ApiResponse.buildOK((String)"").setData((Object)true);
    }

    @PostMapping(value={"removeDataSubscription"})
    public ApiResponse removeDataSubscription(@RequestBody @Validated DataSubscriptionRequest request) {
        Boolean b = this.aiAssistantService.removeDataSubscription(request);
        if (!b.booleanValue()) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u5220\u9664\u5931\u8d25\uff01\u8bf7\u91cd\u8bd5")).setData((Object)false);
        }
        return ApiResponse.buildOK((String)"").setData((Object)true);
    }

    @GetMapping(value={"getDataSubscriptionInfo"})
    public ApiResponse getDataSubscriptionInfo(String iamUserToken, String ruleId) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.getDataSubscriptionInfo(iamUserToken, ruleId));
    }

    @PostMapping(value={"canDataSubscription"})
    public ApiResponse canDataSubscription(@RequestBody @Validated DataSubscriptionRequest request) {
        if (!this.aiAssistantService.canDataSubscription(request).booleanValue()) {
            return ApiResponse.buildError((String)this.localeService.getLanguageValue(request.getLocale(), "\u8be5\u6570\u636e\u5df2\u7ecf\u8ba2\u9605\u4e86"));
        }
        return ApiResponse.buildOK().setData((Object)true);
    }

    @Deprecated
    @GetMapping(value={"queryDataCollectConfig"})
    public ApiResponse queryDataCollectConfig(DataCollectConfigQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryDataCollectConfig(queryDTO));
    }

    @PostMapping(value={"addDataCollectConfig"})
    public ApiResponse addDataCollectConfig(@RequestBody @Validated DataCollectionAddRequest request) {
        return this.aiAssistantService.addDataCollectConfig(request);
    }

    @PostMapping(value={"removeDataCollectConfig"})
    public ApiResponse removeDataCollectConfig(@RequestBody @Validated DataCollectionRemoveRequest request) {
        return this.aiAssistantService.removeDataCollectConfig(request);
    }

    @PostMapping(value={"processMessage"})
    public ApiResponse processMessage(@RequestBody @Validated ProcessMessageRequest request) {
        return this.aiAssistantService.processMessage(request);
    }

    @PostMapping(value={"queryReadBulletinList"})
    public ApiResponse queryReadBulletinList(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryReadBulletinList(apiRequest));
    }

    @PostMapping(value={"queryUnreadBulletinList"})
    public ApiResponse queryUnreadBulletinList(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryUnreadBulletinList(apiRequest));
    }

    @PostMapping(value={"saveReadBulletin"})
    public ApiResponse saveReadBulletin(@RequestBody @Validated BulletinRequest queryDTO) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.saveReadBulletin(queryDTO));
    }

    @PostMapping(value={"queryExceptionInfoByMessageId"})
    public ApiResponse getExceptionInfoByMessageId(@RequestBody @Validated EchoInformationModelQueryDTO queryDTO) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.getExceptionInfoByMessageId(queryDTO));
    }

    @PostMapping(value={"queryApplicationAuthorizationInformation"})
    public ApiResponse queryApplicationAuthorizationInformation(@RequestBody @Validated ApiRequest request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryApplicationAuthorizationInformation(request));
    }

    @PostMapping(value={"saveUserCloseTrafficThresholdAlert"})
    public ApiResponse saveUserCloseTrafficThresholdAlert(@RequestBody @Validated AgileDataCalculateConfigRequest request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.saveUserCloseTrafficThresholdAlert(request));
    }

    @PostMapping(value={"checkIsItUser"})
    public ApiResponse checkIsItUser(@RequestBody @Validated ApiRequest request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.checkIsItUser(request));
    }

    @PostMapping(value={"getTenantApplicationIsBilling"})
    public ApiResponse getTenantApplicationIsBilling(@RequestBody @Validated ApiRequest request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.getTenantApplicationIsBilling(request));
    }

    @PostMapping(value={"getInfoAndSchemaByMessageId"})
    public ApiResponse getInfoAndSchemaByMessageId(@RequestBody @Validated EchoInformationModelQueryDTO request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.getInfoAndSchemaByMessageId(request));
    }

    @PostMapping(value={"queryProductBulletinList"})
    public ApiResponse queryProductBulletinList(@RequestBody @Validated EchoPageConfigProductBulletinQueryDTO request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryProductBulletinList(request));
    }

    @PostMapping(value={"queryOpeningRemarksConfig"})
    public ApiResponse queryOpeningRemarksConfig(@RequestBody @Validated EchoPageConfigProductBulletinQueryDTO request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryOpeningRemarksConfig(request));
    }

    @PostMapping(value={"queryLiteTenantId"})
    public ApiResponse queryLiteTenantId(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryLiteTenantId(apiRequest));
    }

    @PostMapping(value={"sendLiteNanaMessage"})
    public ApiResponse queryLiteTenantId(@RequestBody AgileDataLiteUploadFileQueryDTO queryDTO) {
        this.aiAssistantService.sendLiteNanaMessage(queryDTO);
        return ApiResponse.buildOK();
    }

    @PostMapping(value={"queryLiteUploadLimitationsConfig"})
    public ApiResponse queryLiteUploadLimitationsConfig(@RequestBody ApiRequest request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryLiteUploadLimitationsConfig(request));
    }

    @PostMapping(value={"getMongoDbMetricInfoList"})
    public ApiResponse getMongoDbMetricInfoList(@RequestBody ApiRequest request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.getMongoDbMetricInfoList(request));
    }

    @PostMapping(value={"queryDataCollectionGroup"})
    public ApiResponse queryDataCollectionGroup(@RequestBody @Validated DataCollectionGroupQueryDTO request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryDataCollectionGroup(request));
    }

    @PostMapping(value={"addOrUpdateDataCollectionGroup"})
    public ApiResponse addOrUpdateDataCollectionGroup(@RequestBody @Validated DataCollectionGroupAddOrUpdateDTO request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.addOrUpdateDataCollectionGroup(request));
    }

    @PostMapping(value={"deleteDataCollectionGroup"})
    public ApiResponse deleteDataCollectionGroup(@RequestBody @Validated DataCollectionGroupDeleteDTO request) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.deleteDataCollectionGroup(request));
    }

    @PostMapping(value={"queryCommandIntentions"})
    public ApiResponse queryCommandIntentions(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryCommandIntentions(apiRequest));
    }

    @PostMapping(value={"queryFuzzyMatchingConfig"})
    public ApiResponse queryFuzzyMatchingConfig(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.queryFuzzyMatchingConfig(apiRequest));
    }

    @PostMapping(value={"getThirdPartyAgileData"})
    public ApiResponse getThirdPartyAgileData(@RequestBody @Validated ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData((Object)this.aiAssistantService.getThirdPartyAgileData(apiRequest));
    }
}

