/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.aiassistant.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.aiassistant.AdapterUrl;
import com.digiwin.mobile.mobileuibot.aiassistant.model.request.AsaDispatchRequest;
import com.digiwin.mobile.mobileuibot.aiassistant.service.AdapterService;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.impl.HttpServiceImpl;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AdapterServiceImpl
implements AdapterService {
    private static final Logger logger = LoggerFactory.getLogger(AdapterServiceImpl.class);
    @Autowired
    private HttpService httpService;
    @Autowired
    private SysEnvConfig sysEnvConfig;
    @Autowired
    @Qualifier(value="asaRestTemplate")
    private RestTemplate asaRestTemplate;
    @Autowired
    private HttpServiceImpl httpServiceImpl;

    public ApiResponse sendPost(HttpServletRequest httpServletRequest, Map<String, Object> requestParam) {
        String url = this.checkAndChangeUrl(httpServletRequest);
        String queryParam = httpServletRequest.getQueryString();
        if (StringUtils.isNotEmpty((CharSequence)queryParam)) {
            url = url + "?" + queryParam;
        }
        ApiResponse response = new ApiResponse();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = AthenaBasicHttpRequestHead.BuilderAsaParam((AppRequestContext.ContextEntity)AppRequestContext.getContextEntity());
        ResponseEntity responseEntity = this.httpService.doPost(url, athenaBasicHttpRequestHead, JsonUtil.javaObjectToJsonString(requestParam), Map.class);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("asa post message info error");
            throw new ServiceException("asa post message info error");
        }
        Map responseBody = (Map)responseEntity.getBody();
        if (responseBody != null) {
            response.setCode(String.valueOf(responseBody.get("code")));
            response.setMsg(String.valueOf(responseBody.get("msg")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals(0, responseBody.get("code"))) {
                response.setData(responseBody.get("data"));
            }
        }
        return response;
    }

    public ApiResponse sendPost(HttpServletRequest httpServletRequest, Object requestParam) {
        String url = this.checkAndChangeUrl(httpServletRequest);
        ApiResponse response = new ApiResponse();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = AthenaBasicHttpRequestHead.BuilderAsaParam((AppRequestContext.ContextEntity)AppRequestContext.getContextEntity());
        ResponseEntity responseEntity = this.httpService.doPost(url, athenaBasicHttpRequestHead, JsonUtil.javaObjectToJsonString((Object)requestParam), Map.class);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("asa post message info error");
            throw new ServiceException("asa post message info error");
        }
        Map responseBody = (Map)responseEntity.getBody();
        if (responseBody != null) {
            response.setCode(String.valueOf(responseBody.get("code")));
            response.setMsg(String.valueOf(responseBody.get("msg")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals(0, responseBody.get("code"))) {
                response.setData(responseBody.get("data"));
            }
        }
        return response;
    }

    public ApiResponse sendGet(HttpServletRequest httpServletRequest, MultiValueMap<String, Object> formDataMap) {
        long startTime1 = System.currentTimeMillis();
        ApiResponse response = new ApiResponse();
        String url = this.checkAndChangeUrl(httpServletRequest);
        String queryParam = httpServletRequest.getQueryString();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = AthenaBasicHttpRequestHead.BuilderAsaParam((AppRequestContext.ContextEntity)AppRequestContext.getContextEntity());
        HttpHeaders httpHeader = new HttpHeaders((MultiValueMap)this.processHeaders(url, athenaBasicHttpRequestHead, httpServletRequest));
        boolean b = null != httpServletRequest.getContentType() && httpServletRequest.getContentType().startsWith("multipart/form-data");
        long endTime1 = System.currentTimeMillis();
        logger.debug("ada#sendGet#time1:{}", (Object)(startTime1 - endTime1));
        long startTime2 = System.currentTimeMillis();
        if (b) {
            httpHeader.setContentType(MediaType.MULTIPART_FORM_DATA);
        } else if (StringUtils.isNotEmpty((CharSequence)queryParam)) {
            url = url + "?" + httpServletRequest.getQueryString();
        }
        String sanitizedUrl = url.replace("\r", "").replace("\n", "");
        logger.debug("asa get url is : {}", (Object)sanitizedUrl);
        ResponseEntity responseEntity = this.asaRestTemplate.exchange(url, HttpMethod.GET, b ? new HttpEntity(formDataMap, (MultiValueMap)httpHeader) : new HttpEntity((MultiValueMap)httpHeader), Map.class, new Object[0]);
        long endTime2 = System.currentTimeMillis();
        logger.debug("ada#sendGet#time2:{}", (Object)(startTime2 - endTime2));
        long startTime3 = System.currentTimeMillis();
        this.httpServiceImpl.checkResponse(url, responseEntity, athenaBasicHttpRequestHead.getLocale());
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("asa get message error");
            throw new ServiceException("asa get message error");
        }
        Map responseBody = (Map)responseEntity.getBody();
        if (responseBody != null) {
            response.setCode(String.valueOf(responseBody.get("code")));
            response.setMsg(String.valueOf(responseBody.get("msg")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals(0, responseBody.get("code"))) {
                response.setData(responseBody.get("data"));
            }
        }
        long endTime3 = System.currentTimeMillis();
        logger.debug("ada#sendGet#time3:{}", (Object)(startTime3 - endTime3));
        return response;
    }

    public String checkAndChangeUrl(HttpServletRequest requestParam) {
        return this.sysEnvConfig.getAsaUrl() + "/asa" + requestParam.getRequestURI().replace("asaAdapter/", "");
    }

    public ApiResponse sendPost(HttpServletRequest httpServletRequest, MultipartFile file, Map<String, Object> requestParam) {
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead;
        ApiResponse response = new ApiResponse();
        String url = this.checkAndChangeUrl(httpServletRequest);
        ResponseEntity responseEntity = this.httpService.doPost(url, athenaBasicHttpRequestHead = AthenaBasicHttpRequestHead.BuilderAsaParam((AppRequestContext.ContextEntity)AppRequestContext.getContextEntity()), file, requestParam, Map.class);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("asa get message error");
            throw new ServiceException("asa get message error");
        }
        Map responseBody = (Map)responseEntity.getBody();
        if (responseBody != null) {
            response.setCode(String.valueOf(responseBody.get("code")));
            response.setMsg(String.valueOf(responseBody.get("msg")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals(0, responseBody.get("code"))) {
                response.setData(responseBody.get("data"));
            }
        }
        return response;
    }

    public String getCurrentMethod() {
        try {
            Method[] methods;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String methodName = stackTrace[3].getMethodName();
            Class<?> declaringClass = Class.forName(stackTrace[3].getClassName());
            for (Method method : methods = declaringClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !method.isAnnotationPresent(AdapterUrl.class)) continue;
                AdapterUrl annotation = method.getAnnotation(AdapterUrl.class);
                return this.sysEnvConfig.getAsaUrl() + "/asa" + annotation.url();
            }
            logger.warn("adapterUrl not present");
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("adapterUrl get url error");
        }
        return this.sysEnvConfig.getAsaUrl();
    }

    public HttpHeaders processHeaders(String url, AthenaBasicHttpRequestHead athenaBasicHttpRequestHead, HttpServletRequest request) {
        String proxyToken;
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-app", this.sysEnvConfig.getAppToken());
        httpHeaders.set("digi-middleware-auth-user", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("token", athenaBasicHttpRequestHead.getUserToken());
        httpHeaders.set("client-agent", athenaBasicHttpRequestHead.getClientAgent());
        httpHeaders.set("locale", request.getHeader("locale"));
        String tenantId = this.httpServiceImpl.getTenantId(url, athenaBasicHttpRequestHead);
        if (!StringUtils.isEmpty((CharSequence)tenantId)) {
            httpHeaders.set("routerKey", tenantId);
        }
        if (!StringUtils.isEmpty((CharSequence)(proxyToken = this.httpServiceImpl.getProxyToken(athenaBasicHttpRequestHead)))) {
            httpHeaders.set("digi-proxy-token", proxyToken);
        }
        return httpHeaders;
    }

    public ApiResponse dispatch(HttpServletRequest request, AsaDispatchRequest asaDispatchRequest) {
        ResponseEntity responseEntity;
        HttpMethod httpMethod = asaDispatchRequest.getHttpMethod();
        Map requestParam = asaDispatchRequest.getRequestParam();
        String dispatchUrl = StringUtils.isBlank((CharSequence)asaDispatchRequest.getTarget()) || "asa".equals(asaDispatchRequest.getTarget()) ? this.sysEnvConfig.getAsaUrl() + "/asa" + asaDispatchRequest.getDispatchUrl() : AppContext.getApiUrlSetting().getAniaUrl() + "/ania" + asaDispatchRequest.getDispatchUrl();
        HttpHeaders httpHeader = new HttpHeaders((MultiValueMap)this.dispatchHeader(dispatchUrl, request, asaDispatchRequest));
        if (httpMethod == HttpMethod.POST) {
            httpHeader.setContentType(MediaType.APPLICATION_JSON);
        }
        if ((responseEntity = this.asaRestTemplate.exchange(dispatchUrl, httpMethod, new HttpEntity((Object)requestParam, (MultiValueMap)httpHeader), Map.class, new Object[0])) == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            logger.debug("aAdapterServiceImpl.dispatch error dispatchUrl:{}", (Object)dispatchUrl);
            throw new ServiceException("asa get message error");
        }
        ApiResponse response = new ApiResponse();
        if (responseEntity.getBody() != null) {
            response.setCode(String.valueOf(((Map)responseEntity.getBody()).get("code")));
            response.setMsg(String.valueOf(((Map)responseEntity.getBody()).get("msg")));
            response.setTraceId(String.valueOf(((Map)responseEntity.getBody()).get("traceId")));
            if (Objects.equals(0, ((Map)responseEntity.getBody()).get("code"))) {
                response.setData(((Map)responseEntity.getBody()).get("data"));
            }
        }
        return response;
    }

    public HttpHeaders dispatchHeader(String url, HttpServletRequest request, AsaDispatchRequest asaDispatchRequest) {
        AthenaBasicHttpRequestHead athenaHead = AthenaBasicHttpRequestHead.BuilderAsaParam((AppRequestContext.ContextEntity)AppRequestContext.getContextEntity());
        HttpHeaders httpHeaders = this.processHeaders(url, athenaHead, request);
        List headerKeys = asaDispatchRequest.getHeaderKeys();
        CollUtil.emptyIfNull((List)headerKeys).forEach(headerKey -> {
            String headerValue = request.getHeader(headerKey);
            if (StrUtil.isNotEmpty((CharSequence)headerValue)) {
                httpHeaders.set(headerKey, headerValue);
            }
        });
        return httpHeaders;
    }
}

