/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.aiassistant.service.impl;

import com.digiwin.mobile.mobileuibot.aiassistant.service.AniaAdapterService;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class AniaAdapterServiceImpl
implements AniaAdapterService {
    private static final Logger log = LoggerFactory.getLogger(AniaAdapterServiceImpl.class);
    @Autowired
    private HttpService httpService;

    public ApiResponse sendPost(HttpServletRequest httpServletRequest, Map<String, Object> requestParam) {
        String url = this.checkAndChangeUrl(httpServletRequest);
        ApiResponse response = new ApiResponse();
        AthenaBasicHttpRequestHead athenaBasicHttpRequestHead = AthenaBasicHttpRequestHead.BuilderAsaParam((AppRequestContext.ContextEntity)AppRequestContext.getContextEntity());
        String sanitizedUrl = url.replace("\r", "").replace("\n", "");
        log.debug("\u8bf7\u6c42\u7684url:{}", (Object)sanitizedUrl);
        requestParam.remove("tenantId");
        requestParam.remove("userId");
        requestParam.remove("appInfo");
        ResponseEntity responseEntity = this.httpService.doPost(sanitizedUrl, athenaBasicHttpRequestHead, JsonUtil.javaObjectToJsonString(requestParam), Map.class);
        if (responseEntity == null || !responseEntity.getStatusCode().is2xxSuccessful()) {
            log.debug("ania post message info error");
            throw new ServiceException("ania post message info error");
        }
        Map responseBody = (Map)responseEntity.getBody();
        if (responseBody != null) {
            response.setCode("200".equals(String.valueOf(responseBody.get("status"))) ? "0" : "-1");
            response.setMsg(String.valueOf(responseBody.get("errorMessage")));
            response.setTraceId(String.valueOf(responseBody.get("traceId")));
            if (Objects.equals("0", response.getCode())) {
                response.setData(responseBody.get("response"));
            }
        }
        return response;
    }

    public String checkAndChangeUrl(HttpServletRequest requestParam) {
        return AppContext.getApiUrlSetting().getAniaUrl() + requestParam.getRequestURI().replace("aniaAdapter/", "");
    }
}

