/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.businesslogic;

import com.digiwin.mobile.mobileuibot.businesslogic.BusinessLogicHandler;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="businessLogicHandlerFactory")
public class BusinessLogicHandlerFactory
implements InitializingBean,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(BusinessLogicHandlerFactory.class);
    private static final Map<String, BusinessLogicHandler> BUSINESS_LOGIC_HANDLER_MAP = new HashMap();
    private ApplicationContext appContext;

    public BusinessLogicHandler get(String key) {
        return (BusinessLogicHandler)BUSINESS_LOGIC_HANDLER_MAP.get(key);
    }

    public void afterPropertiesSet() throws Exception {
        this.appContext.getBeansOfType(BusinessLogicHandler.class).values().forEach(handler -> BUSINESS_LOGIC_HANDLER_MAP.put(handler.getBusinessType(), handler));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }
}

