/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.cache;

import com.digiwin.mobile.mobileuibot.locale.service.TranslateService;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LuckyColaCache {
    private static final Logger log = LoggerFactory.getLogger(LuckyColaCache.class);
    private static final String LUCKYCOLA_COLAKEY = "LuckyCola_ColaKey";
    @Autowired
    private TranslateService translateService;
    private LoadingCache<String, String> colaKeyCache = Caffeine.newBuilder().recordStats().initialCapacity(8).maximumSize(8L).refreshAfterWrite(60L, TimeUnit.DAYS).removalListener((key, value, cause) -> log.debug("LuckyColaCache[cahceBuilder] key {} msg {} ", key, (Object)cause)).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    public String getColaKey() {
        return this.getValue(LUCKYCOLA_COLAKEY);
    }

    public String getValue(String key) {
        try {
            return (String)this.colaKeyCache.get((Object)key);
        }
        catch (Exception e) {
            log.error("LuckyColaCache[getValue] occurred error ", (Throwable)e);
            return "";
        }
    }

    public void putValue(String value) {
        try {
            this.colaKeyCache.put((Object)LUCKYCOLA_COLAKEY, (Object)value);
        }
        catch (Exception e) {
            log.error("LuckyColaCache[putValue] occurred error ", (Throwable)e);
        }
    }

    static /* synthetic */ TranslateService access$000(LuckyColaCache x0) {
        return x0.translateService;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

