/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.common.http;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class DigiwinHttpReqTimeInterceptor
implements ClientHttpRequestInterceptor {
    private Logger logger = LoggerFactory.getLogger(DigiwinHttpReqTimeInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.logger.debug("========================\u5916\u90e8HTTP\u8bf7\u6c42\u62e6\u622a-request===========================\nrequestUrl\uff1a{}\nrequestTime\uff1a{}", (Object)request.getURI(), (Object)DateTimeUtil.getTodayTimeUseDefaultPattern());
        long startTime = System.currentTimeMillis();
        ClientHttpResponse response = execution.execute(request, body);
        long endTime = System.currentTimeMillis();
        this.logger.debug("========================\u5916\u90e8HTTP\u8bf7\u6c42\u62e6\u622a-response==========================\nrequestUrl\uff1a{}\nresponseTime\uff1a{}\nrunningTime\uff1a{}ms", new Object[]{request.getURI(), DateTimeUtil.getTodayTimeUseDefaultPattern(), endTime - startTime});
        return response;
    }
}

