/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigiwinI18nResourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DigiwinI18nResourceFactory.class);
    private static final Locale[] SUPPORT_LOCALE = new Locale[]{Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.US};

    void init() {
        for (Locale locale : SUPPORT_LOCALE) {
            try {
                AppContext.getDefaultI18nResourceMap().put(locale.toString(), this.getMobileSpecificI18nResource(locale.toString()));
                logger.debug("{} language resource load successfully...", (Object)locale);
            }
            catch (Exception e) {
                logger.error("{} language resource load error...", (Object)locale, (Object)e);
            }
        }
    }

    private Map<String, String> getMobileSpecificI18nResource(String locale) {
        if (Locale.TRADITIONAL_CHINESE.toString().equalsIgnoreCase(locale)) {
            return this.getMobileZhTwI18nResource();
        }
        if (Locale.US.toString().equalsIgnoreCase(locale)) {
            return this.getMobileEnUsI18nResource();
        }
        return this.getMobileZhCnI18nResource();
    }

    private Map<String, String> getMobileZhCnI18nResource() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("dj-mobile-" + PageSettingIdPresetEnum.INDEX, "\u9996\u9875");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT, "\u5de5\u4f5c\u63d0\u9192");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_PROJECT_ASSISTANT, "\u9879\u76ee\u52a9\u7406");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM, "\u7cfb\u7edf\u901a\u77e5");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_MY_TODO, "\u6211\u7684\u5f85\u529e");
        result.put("dj-mobile-" + AthenaMobileNotificationCategoryEnum.MOBILE_MY_PROJECT, "\u6211\u7684\u9879\u76ee");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_APPROVAL_TASK_PROGRESS, "\u7b7e\u6838\u8fdb\u5ea6");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_AGREE, "\u540c\u610f");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_DISAGREE, "\u4e0d\u540c\u610f");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REAPPROVE, "\u9000\u56de\u91cd\u7b7e");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REEXECUTE, "\u9000\u56de\u91cd\u529e");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_ADDTASK, "\u52a0\u7b7e");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REASSIGN, "\u8f6c\u6d3e");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_DETAIL_ITEM_DETAIL, "");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT, "\u9879\u76ee\u8ffd\u8e2a");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_PROJECT_DETAIL, "\u9879\u76ee\u4e2d\u63a7\u53f0\u8be6\u60c5");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.DASHBOARD, "\u5de5\u4f5c\u53f0");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.GPT_AI, "\u5a1c\u5a1c");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.CONTACTS, "\u901a\u8baf\u5f55");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.ME, "\u6211\u7684");
        result.put("dj-mobile-" + PageSettingIdPresetEnum.NOTIFICATION_PAGE, "\u6d88\u606f");
        result.put("dj-mobile-WELCOME_TO_ATHENA", "\u6b22\u8fce\u4f60\u4f7f\u7528Athena\uff0c\u5feb\u6765\u770b\u770b\u6211\u53ef\u4ee5\u505a\u4ec0\u4e48\u5427");
        result.put("dj-mobile-ATHENA_MY_PROJECT_PROMPT", "\u77e5\u6653\u8fdb\u5ea6\u60c5\u51b5\uff0c\u603b\u89c8\u9879\u76ee\u95ee\u9898");
        result.put("dj-mobile-\u7531\u8f6c\u6d3e", "\u7531%s\u8f6c\u6d3e>");
        result.put("dj-mobile-\u9996\u9875\u4efb\u52a1\u63d0\u793a\u903e\u671f", "\u5176\u4e2d\u5305\u542b%d\u4e2a\u903e\u671f\u4efb\u52a1\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\ud83d\udcaa");
        result.put("dj-mobile-\u9996\u9875\u4efb\u52a1\u63d0\u793a", "\u8bf7\u53ca\u65f6\u5904\u7406\ud83d\udcaa");
        result.put("dj-mobile-\u9879\u76ee\u6765\u6e90\u8bf4\u660e", "\u7531 %s \u7b49%d\u5f20%s\u7ec4\u6210");
        result.put("dj-mobile-\u591a\u4e2a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d", "\u5171%d\u4e2a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d");
        result.put("dj-mobile-\u591a\u4e2a\u4efb\u52a1\u903e\u671f\u5f02\u5e38", "\u5171%d\u4e2a\u4efb\u52a1\u903e\u671f/\u5f02\u5e38");
        result.put("dj-mobile-\u903e\u671f\u5929\u6570", "\u903e\u671f%d\u5929");
        result.put("dj-mobile-\u6807\u51c6\u9879\u76ee\u6765\u6e90", "\u5171%d\u4e2a\u5206\u516c\u53f8%d\u5f20%s\u7ec4\u6210");
        result.put("dj-mobile-\u903e\u671f\u540e\u5b8c\u6210", "\u903e\u671f%d\u5929\u5b8c\u6210");
        result.put("dj-mobile-\u903e\u671f\u8be6\u60c5", "\u903e\u671f%d\u9879\uff0c\u6700\u5927\u903e\u671f%d\u5929");
        result.put("dj-mobile-\u603b\u8ba1", "\u5171\u641c\u7d22%d\u7b14\u7ed3\u679c");
        result.put("dj-mobile-\u6211\u7684\u9875\u9762\u63d0\u793atitle", "\u201c\u6211\u7684\u201d\u9875\u9762\u6362\u5730\u65b9\u54af\uff5e");
        result.put("dj-mobile-\u6211\u7684\u9875\u9762\u63d0\u793abody", "\u70b9\u51fb\u8fd9\u91cc\u5373\u53ef\u8fdb\u5165\uff0c\u5185\u542b\u201c\u5207\u6362\u79df\u6237\u3001\u901a\u8baf\u5f55\u201d\u7b49\u529f\u80fd");
        result.put("dj-mobile-actualMinutesErrors", "\u5206\u949f\u6570\u5fc5\u987b\u662f\u6574\u6570\uff0c\u5927\u4e8e\u7b49\u4e8e0\u5c0f\u4e8e60");
        result.put("dj-mobile-actualHoursErrors", "\u5c0f\u65f6\u6570\u5fc5\u987b\u662f\u6574\u6570");
        result.put("dj-mobile-close_status", "\u72b6\u6001");
        result.put("dj-mobile-purchase_no", "\u5355\u53f7");
        result.put("dj-mobile-purchase_seq", "\u9879\u6b21");
        result.put("dj-mobile-item_no", "\u6599\u53f7");
        result.put("dj-mobile-item_name_spec", "\u54c1\u540d\u89c4\u683c");
        result.put("dj-mobile-purchase_qty", "\u6570\u91cf");
        result.put("dj-mobile-stock_in_qty", "\u5165\u5e93\u6570\u91cf");
        result.put("dj-mobile-complete_rate", "\u5b8c\u6210\u7387");
        result.put("dj-mobile-attachment_remark", "\u4efb\u52a1\u8bf4\u660e");
        result.put("dj-mobile-purchaser_name", "\u91c7\u8d2d\u4eba\u5458");
        result.put("dj-mobile-purchase_sub_seq", "\u5b50\u9879\u6b21");
        result.put("dj-mobile-issue_set_qty", "\u5df2\u53d1\u6599\u5957\u6570");
        result.put("dj-mobile-plan_delivery_date", "\u9884\u8ba1\u4ea4\u8d27\u65e5");
        result.put("dj-mobile-plan_start_date", "\u9884\u8ba1\u5f00\u59cb\u65e5");
        result.put("dj-mobile-plan_finish_date", "\u9884\u8ba1\u5b8c\u6210\u65e5");
        result.put("dj-mobile-actual_start_date", "\u5b9e\u9645\u5f00\u59cb\u65e5");
        result.put("dj-mobile-remarks", "\u62a5\u5de5\u8bf4\u660e");
        result.put("dj-mobile-work_hours", "\u5de5\u65f6");
        result.put("dj-mobile-actual_finish_date", "\u5b9e\u9645\u5b8c\u6210\u65e5");
        result.put("dj-mobile-total_work_hours", "\u8017\u7528\u603b\u5de5\u65f6");
        result.put("dj-mobile-remark", "\u5907\u6ce8");
        result.put("dj-mobile-is_approve", "\u7b7e\u6838");
        result.put("dj-mobile-attachment", "\u4ea4\u4ed8\u7269\u6837\u677f");
        result.put("dj-mobile-liable_person_name", "\u8d1f\u8d23\u4eba\u540d\u79f0");
        result.put("dj-mobile-design_status", "\u8bbe\u8ba1\u4efb\u52a1\u72b6\u6001");
        result.put("dj-mobile-project_no", "\u9879\u76ee\u7f16\u53f7");
        result.put("dj-mobile-task_no", "\u4efb\u52a1\u7f16\u53f7");
        result.put("dj-mobile-design_no", "\u8bbe\u8ba1\u4efb\u52a1\u7f16\u53f7");
        result.put("dj-mobile-design_name", "\u8bbe\u8ba1\u4efb\u52a1\u540d\u79f0");
        result.put("dj-mobile-report_work_description", "\u62a5\u5de5\u8bf4\u660e");
        result.put("dj-mobile-task_status", "\u4efb\u52a1\u72b6\u6001");
        result.put("dj-mobile-task_name", "\u4efb\u52a1\u540d\u79f0");
        result.put("dj-mobile-task_complete_rate", "\u4efb\u52a1\u5b8c\u6210\u7387");
        result.put("dj-mobile-is_on_schedule", "\u662f\u5426\u51c6\u65f6");
        result.put("dj-mobile-important", "\u91cd\u8981\u6027");
        result.put("dj-mobile-task_seq", "\u4efb\u52a1\u5e8f\u53f7");
        result.put("dj-mobile-upper_level_task_no", "\u7236\u7ea7\u4efb\u52a1\u7f16\u53f7");
        result.put("dj-mobile-before_task_no", "\u524d\u7f6e\u4efb\u52a1\u7f16\u53f7");
        result.put("dj-mobile-milestone_type", "\u91cc\u7a0b\u7891\u7c7b\u578b");
        result.put("dj-mobile-plan_work_days", "\u8ba1\u5212\u5de5\u671f");
        result.put("dj-mobile-plan_work_hours", "\u8ba1\u5212\u5de5\u65f6");
        result.put("dj-mobile-executor_name", "\u6267\u884c\u4eba\u540d\u79f0");
        result.put("dj-mobile-executor_role", "\u6267\u884c\u4eba\u89d2\u8272");
        result.put("dj-mobile-reference_type_no", "\u53c2\u8003\u5355\u522b");
        result.put("dj-mobile-reference_doc_no", "\u53c2\u8003\u5355\u53f7");
        result.put("dj-mobile-item_classification", "\u54c1\u53f7\u7c7b\u522b/\u7fa4\u7ec4");
        result.put("dj-mobile-status", "\u72b6\u6001");
        result.put("dj-mobile-wo_no", "\u5de5\u5355\u5355\u53f7");
        result.put("dj-mobile-machine_no", "\u8bbe\u5907\u53f7");
        result.put("dj-mobile-production_qty", "\u751f\u4ea7\u6570\u91cf");
        result.put("dj-mobile-plan_date_e", "\u9884\u5b9a\u5b8c\u5de5\u65e5");
        result.put("dj-mobile-process_seq", "\u52a0\u5de5\u987a\u5e8f");
        result.put("dj-mobile-op_name", "\u5de5\u827a\u540d\u79f0");
        result.put("dj-mobile-op_type", "\u5de5\u827a\u6027\u8d28");
        result.put("dj-mobile-supplier_name", "\u7ebf\u522b/\u5382\u5546\u540d\u79f0");
        result.put("dj-mobile-feed_qty", "\u6295\u5165\u6570\u91cf");
        result.put("dj-mobile-complete_qty", "\u5b8c\u6210\u6570\u91cf");
        result.put("dj-mobile-op_no", "\u5de5\u827a\u7f16\u53f7");
        result.put("dj-mobile-\u641c\u7d22\u4f60\u60f3\u77e5\u9053\u7684\u5185\u5bb9", "\u641c\u7d22");
        result.put("dj-mobile-\u672c\u6b21\u91c7\u8d2d\u5b58\u5728\u5355\u4ef7\u5f02\u5e38\u7269\u6599\u5171n\u9879", "\u672c\u6b21\u91c7\u8d2d\u5b58\u5728\u5355\u4ef7\u5f02\u5e38\u7269\u6599\u5171%s\u9879");
        result.put("dj-mobile-token\u8fc7\u671f", "\u767b\u5f55\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        result.put("dj-mobile-\u9a8c\u8bc1\u7801\u9519\u8bef", "\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
        result.put("dj-mobile-\u4e8c\u7ef4\u7801\u5931\u6548", "\u4e8c\u7ef4\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u83b7\u53d6\u6700\u65b0\u4e8c\u7ef4\u7801\u91cd\u65b0\u626b\u63cf");
        result.put("dj-mobile-\u8bf7\u626b\u7801\u8d27\u8fd0\u4e8c\u7ef4\u7801", "\u626b\u4e00\u626b\u4e0a\u9762\u7684\u4e8c\u7ef4\u7801\uff0c\u6dfb\u52a0\u8f66\u8f86\u4fe1\u606f");
        result.put("dj-mobile-\u6765\u81ea%s\u7684\u5206\u4eab", "\u6765\u81ea%s\u7684\u5206\u4eab");
        result.put("dj-mobile-reassignContentTask", "\u8f6c\u6d3e\u540e\uff0c\u4f60\u5c06\u65e0\u6cd5\u67e5\u770b\u8be5\u4efb\u52a1\u3002");
        result.put("dj-mobile-reassignContentProject", "\u8f6c\u6d3e\u540e\uff0c\u6b64\u9879\u76ee\u5c06\u4e0d\u7531\u4f60\u8d1f\u8d23\uff0c\u4e14\u65e0\u6cd5\u67e5\u9605\u8be5\u9879\u76ee\u3002");
        return result;
    }

    private Map<String, String> getMobileZhTwI18nResource() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("dj-mobile-\u7531\u8f6c\u6d3e", "\u7531%s\u8f49\u6d3e>");
        result.put("dj-mobile-\u9996\u9875\u4efb\u52a1\u63d0\u793a\u903e\u671f", "\u5176\u4e2d\u5305\u542b%d\u500b\u903e\u671f\u4efb\u52d9\uff0c\u8acb\u5118\u5feb\u8655\u7406\ud83d\udcaa");
        result.put("dj-mobile-\u9996\u9875\u4efb\u52a1\u63d0\u793a", "\u8acb\u53ca\u6642\u8655\u7406\ud83d\udcaa");
        result.put("dj-mobile-\u9879\u76ee\u6765\u6e90\u8bf4\u660e", "\u7531 %s \u7b49%d\u5f35%s\u7d44\u6210");
        result.put("dj-mobile-\u591a\u4e2a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d", "\u5171%d\u500b\u4efb\u52d9\u6b63\u5728\u9032\u884c\u4e2d");
        result.put("dj-mobile-\u591a\u4e2a\u4efb\u52a1\u903e\u671f\u5f02\u5e38", "\u5171%d\u500b\u4efb\u52d9\u903e\u671f/\u7570\u5e38");
        result.put("dj-mobile-\u903e\u671f\u5929\u6570", "\u903e\u671f%d\u5929");
        result.put("dj-mobile-\u6807\u51c6\u9879\u76ee\u6765\u6e90", "\u5171%d\u500b\u5206\u516c\u53f8%d\u5f35%s\u7d44\u6210");
        result.put("dj-mobile-\u903e\u671f\u540e\u5b8c\u6210", "\u903e\u671f%d\u5929\u5b8c\u6210");
        result.put("dj-mobile-\u903e\u671f\u8be6\u60c5", "\u903e\u671f%d\u9805\uff0c\u6700\u5927\u903e\u671f%d\u5929");
        result.put("dj-mobile-\u603b\u8ba1", "\u5171\u641c\u7d22%d\u7b46\u7d50\u679c");
        result.put("dj-mobile-\u672c\u6b21\u91c7\u8d2d\u5b58\u5728\u5355\u4ef7\u5f02\u5e38\u7269\u6599\u5171n\u9879", "\u672c\u6b21\u63a1\u8cfc\u5b58\u5728\u55ae\u50f9\u7570\u5e38\u7269\u6599\u5171%s\u9805");
        result.put("dj-mobile-\u6765\u81ea%s\u7684\u5206\u4eab", "\u4f86\u81ea%s\u7684\u5206\u4eab");
        return result;
    }

    private Map<String, String> getMobileEnUsI18nResource() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("dj-mobile-\u7531\u8f6c\u6d3e", "Transferred from %s>");
        result.put("dj-mobile-\u9996\u9875\u4efb\u52a1\u63d0\u793a\u903e\u671f", "You have %d overdue tasks. Let's check them out!\ud83d\udcaa");
        result.put("dj-mobile-\u9996\u9875\u4efb\u52a1\u63d0\u793a", "Please check them out!\ud83d\udcaa");
        result.put("dj-mobile-\u9879\u76ee\u6765\u6e90\u8bf4\u660e", "There are %d %s such as %s");
        result.put("dj-mobile-\u591a\u4e2a\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u4e2d", "A total of %d tasks are in progress");
        result.put("dj-mobile-\u591a\u4e2a\u4efb\u52a1\u903e\u671f\u5f02\u5e38", "A total of %d tasks are overdue or abnormal");
        result.put("dj-mobile-\u903e\u671f\u5929\u6570", "%d days overdue");
        result.put("dj-mobile-\u6807\u51c6\u9879\u76ee\u6765\u6e90", "A total of %d %s for %d branches");
        result.put("dj-mobile-\u903e\u671f\u540e\u5b8c\u6210", "Completed %d days overdue");
        result.put("dj-mobile-\u903e\u671f\u8be6\u60c5", "%d items overdue, with a maximum overdue of %d days");
        result.put("dj-mobile-\u603b\u8ba1", "A total of %d results were searched");
        result.put("dj-mobile-\u672c\u6b21\u91c7\u8d2d\u5b58\u5728\u5355\u4ef7\u5f02\u5e38\u7269\u6599\u5171n\u9879", "There are %s items of abnormal unit price materials in this purchase");
        result.put("dj-mobile-\u6765\u81ea%s\u7684\u5206\u4eab", "Share from %s");
        return result;
    }
}

