/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config.mqtt;

import com.digiwin.mobile.mobileuibot.config.mqtt.MqttProperties;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.stereotype.Component;

@Component
public class MqttConfig {
    private static final Logger log = LoggerFactory.getLogger(MqttConfig.class);
    @Autowired
    private MqttProperties mqttConfiguration;

    @Bean
    public MqttPahoClientFactory mqttClientFactory() {
        DefaultMqttPahoClientFactory factory = new DefaultMqttPahoClientFactory();
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        options.setConnectionTimeout(30);
        options.setKeepAliveInterval(180);
        options.setAutomaticReconnect(true);
        options.setUserName(this.mqttConfiguration.getUsername());
        options.setPassword(this.mqttConfiguration.getPassword().toCharArray());
        options.setServerURIs(new String[]{this.mqttConfiguration.getUrl()});
        factory.setConnectionOptions(options);
        return factory;
    }
}

