/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.config.request.mock;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.common.url.UrlUtil;
import com.digiwin.mobile.mobileuibot.config.request.mock.OuterMockData;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.experience.model.ExperienceRoleIdEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mock.MockService;
import com.digiwin.mobile.mobileuibot.mock.enums.EnableEnum;
import com.digiwin.mobile.mobileuibot.model.Mock;
import com.digiwin.mobile.mobileuibot.navigation.Navigation;
import com.digiwin.mobile.mobileuibot.navigation.NavigationService;
import com.digiwin.mobile.mobileuibot.proxy.ProxyController;
import com.digiwin.mobile.mobileuibot.proxy.experience.service.DigiwinExperienceProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.model.ProxyRefreshTenant;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class MockInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(MockInterceptor.class);
    public static final String RECORD_MOCK_ID = "record-mock-id";
    public static final String LOGIN_URI = "/mobile/v1/proxy/loginInDigiwhale";
    private static final String VERIFICATION_CODE_URI = "/mobile/v1/proxy/getVerificationCode";
    private static final String BOTTOM_URI = "/mobile/v1/navigation/bottom";
    private static final String IM_USER_INFO_URI = "/mobile/v1/im/user/info";
    private static final String REFRESHTENANT_URI = "/mobile/v1/proxy/refreshtenant";
    private static final String RENDER_PAGE_URI = "/mobile/v1/uibot/model";
    public static final TransmittableThreadLocal<OuterMockData> OUTER_MOCK_DATA = new TransmittableThreadLocal();
    public static BlockingDeque<OuterMockData> BLOCKING_DEQUE = new LinkedBlockingDeque(1000);
    @Autowired
    private DigiwinExperienceProxyService digiwinExperienceProxyService;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private MockService mockService;
    @Autowired
    private NavigationService navigationService;
    @Autowired
    private ProxyController proxyController;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String mockId = request.getHeader(RECORD_MOCK_ID);
        String modelType = request.getHeader("modelType");
        if (!StringUtils.hasLength((String)mockId)) {
            return true;
        }
        if ("mock".equalsIgnoreCase(modelType)) {
            if (VERIFICATION_CODE_URI.equals(AppRequestContext.getContextEntity().getRequestUri())) {
                return true;
            }
            if (LOGIN_URI.equals(AppRequestContext.getContextEntity().getRequestUri()) && ExperienceRoleIdEnum.ATHENA_MOCK.getValue().equals(request.getParameter("expRoleId"))) {
                return true;
            }
            if (IM_USER_INFO_URI.equals(AppRequestContext.getContextEntity().getRequestUri())) {
                Mock mock = this.mockService.selectByMockId(mockId, null);
                if (mock != null && EnableEnum.YES.getValue().equals(mock.getEnableNana())) {
                    request.setAttribute("nanaTenantId", (Object)mock.getNanaTenantId());
                }
                return true;
            }
            this.getMockData(mockId, request, response);
            return false;
        }
        this.recordMock(mockId, request);
        return true;
    }

    private void recordMock(String mockId, HttpServletRequest request) throws IOException {
        String requestUri = AppRequestContext.getContextEntity().getRequestUri();
        Map payload = this.buildPayload(request);
        OUTER_MOCK_DATA.set((Object)new OuterMockData().setUrl(requestUri).setMethod(request.getMethod()).setPayload(JsonUtil.javaObjectToJsonString((Object)payload)).setLocale(StringUtil.valueOf(payload.get("locale"))).setMockId(mockId));
    }

    private Map<String, Object> buildPayload(HttpServletRequest request) throws IOException {
        String pageId = "";
        String dataId = "";
        String locale = "";
        String requestId = "";
        String tenantId = "";
        String projectId = null;
        Integer calenderType = null;
        if (HttpMethod.POST.name().equalsIgnoreCase(request.getMethod())) {
            Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
            if (params.containsKey("sysParam")) {
                Map sysParam = (Map)params.get("sysParam");
                pageId = (String)sysParam.get("pageId");
                dataId = (String)sysParam.get("dataId");
                locale = (String)sysParam.get("locale");
                requestId = (String)sysParam.get("requestId");
                tenantId = (String)sysParam.get("tenantId");
            } else {
                pageId = (String)params.get("pageId");
                dataId = (String)params.get("dataId");
                locale = (String)params.get("locale");
                requestId = (String)params.get("requestId");
                tenantId = (String)params.get("tenantId");
                calenderType = (Integer)params.get("calenderType");
            }
        }
        if (!StringUtils.hasLength((String)dataId)) {
            String requestUri = AppRequestContext.getContextEntity().getRequestUri();
            String url = requestUri + "?" + request.getQueryString();
            Map params = UrlUtil.parseUrl((String)url);
            if (params.containsKey("dataId")) {
                dataId = (String)params.get("dataId");
            }
            if (params.containsKey("tenantId")) {
                tenantId = (String)params.get("tenantId");
            }
            if (params.containsKey("projectId")) {
                projectId = (String)params.get("projectId");
            }
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("pageId", pageId);
        payload.put("dataId", dataId);
        payload.put("locale", locale);
        payload.put("requestId", requestId);
        payload.put("tenantId", tenantId);
        payload.put("projectId", projectId);
        payload.put("calenderType", calenderType);
        return payload;
    }

    private void getMockData(String mockId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestUri = AppRequestContext.getContextEntity().getRequestUri();
        Map payload = this.buildPayload(request);
        String responseBody = this.digiwinExperienceProxyService.gainMockDataOne(new OuterMockData().setMockId(mockId).setUrl(requestUri).setPayload(JsonUtil.javaObjectToJsonString((Object)payload)).setMethod(request.getMethod()));
        String locale = StringUtil.valueOf(payload.get("locale"));
        locale = StringUtils.hasLength((String)locale) ? locale : "zh_CN";
        this.returnResponseData(mockId, requestUri, locale, responseBody, response);
    }

    private void returnResponseData(String mockId, String requestUri, String locale, String responseBody, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter writer = response.getWriter();){
            if (StringUtils.hasLength((String)responseBody)) {
                responseBody = this.handleResponseBody(mockId, requestUri, locale, responseBody);
                writer.print(MobileRenderDataUtil.upgradeToV2((String)requestUri, (String)responseBody));
                return;
            }
            if (RENDER_PAGE_URI.equals(requestUri)) {
                UiBotModel uiBotModel = UiBotModel.createEmptyComponent((String)this.localeService.getLanguageValue(locale, "\u6b64\u573a\u666f\u6682\u672a\u5f55\u5236"), (boolean)false, (String)"mock_not_yet_record");
                ApiResponse apiResponse = ApiResponse.buildOK().setData((Object)uiBotModel);
                writer.print(JsonUtil.javaObjectToJsonString((Object)MobileRenderDataUtil.upgradeToV2((String)requestUri, (ApiResponse)apiResponse)));
                return;
            }
            ApiResponse result = ApiResponse.buildMockError((String)this.localeService.getLanguageValue(locale, "\u6b64\u573a\u666f\u6682\u672a\u5f55\u5236"));
            writer.print(JsonUtil.javaObjectToJsonString((Object)MobileRenderDataUtil.upgradeToV2((String)requestUri, (ApiResponse)result)));
        }
        catch (IOException e) {
            logger.error("\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private String handleResponseBody(String mockId, String requestUri, String locale, String responseBody) {
        ProxyRefreshTenant body;
        ApiResponse refreshTenant;
        ProxyRefreshTenant mockBody;
        Mock mock;
        ApiResponse apiResponse;
        if (BOTTOM_URI.equals(requestUri)) {
            Navigation navigation;
            Mock mock2;
            apiResponse = (ApiResponse)JsonUtil.jsonStringToObject((String)responseBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List data = (List)apiResponse.getData();
            if (!CollectionUtils.isEmpty((Collection)data) && data.stream().noneMatch(bottomNavigation -> PageSettingIdPresetEnum.GPT_AI.name().equals(bottomNavigation.getPageId())) && (mock2 = this.mockService.selectByMockId(mockId, null)) != null && EnableEnum.YES.getValue().equals(mock2.getEnableNana()) && (navigation = this.navigationService.findFirst()) != null && !CollectionUtils.isEmpty((Collection)navigation.getBottomNavigations())) {
                navigation.getBottomNavigations().stream().filter(item -> PageSettingIdPresetEnum.GPT_AI.name().equals(item.getPageId())).findFirst().ifPresent(item -> {
                    item.setPageTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)item.getPageId()));
                    item.setName(LocaleUtil.getMobileTextByKey((String)locale, (String)item.getPageId()));
                    data.add(2, item);
                });
            }
            responseBody = JsonUtil.javaObjectToJsonString((Object)apiResponse);
        }
        if (REFRESHTENANT_URI.equals(requestUri) && (apiResponse = (ApiResponse)JsonUtil.jsonStringToObject((String)responseBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).isOK() && (mock = this.mockService.selectByMockId(mockId, null)) != null && EnableEnum.YES.getValue().equals(mock.getEnableNana()) && (mockBody = (ProxyRefreshTenant)apiResponse.getData()) != null && (refreshTenant = this.proxyController.refreshTenant(null, mock.getNanaTenantId(), AppRequestContext.getContextEntity().getIamUserToken())).isOK() && (body = (ProxyRefreshTenant)refreshTenant.getData()) != null) {
            body.setTenantId(mockBody.getTenantId());
            body.setTenantSid(mockBody.getTenantSid());
            body.setTenantName(mockBody.getTenantName());
            DigiwinIamAuthoredUser iamAuth = body.getAuthoredUser();
            if (iamAuth != null) {
                iamAuth.setTenantId(mockBody.getTenantId());
                iamAuth.setTenantSid(mockBody.getTenantSid());
                iamAuth.setTenantName(mockBody.getTenantName());
            }
            responseBody = JsonUtil.javaObjectToJsonString((Object)refreshTenant);
        }
        return responseBody;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.buildResponse();
        OUTER_MOCK_DATA.remove();
    }

    private void buildResponse() {
        OuterMockData outerMockData = (OuterMockData)OUTER_MOCK_DATA.get();
        if (null == outerMockData) {
            return;
        }
        BLOCKING_DEQUE.offer(outerMockData);
    }
}

