/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.contacts;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.pinyin.HypyUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocDeptPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocDeptResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.service.DigiwinImProxyService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mobile/v1/contacts"})
public class ContactsController {
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinImProxyService digiwinImProxyService;

    @RequestMapping(value={"/dept/list"}, method={RequestMethod.POST})
    public ApiResponse<Map> getDepts(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        ArrayList eocDeptList = new ArrayList();
        EocDeptResponse eocDeptResponse = this.digiwinEocProxyService.getEocDeptList(iamUserToken, 100, 1);
        if (eocDeptResponse != null) {
            eocDeptList.addAll(eocDeptResponse.getList());
            Integer total = eocDeptResponse.getTotal();
            if (total > eocDeptList.size()) {
                int page = total / 100 + 1;
                for (int num = 2; num <= page; ++num) {
                    EocDeptResponse eocDeptResp = this.digiwinEocProxyService.getEocDeptList(iamUserToken, 100, num);
                    if (eocDeptResp == null) continue;
                    eocDeptList.addAll(eocDeptResp.getList());
                }
            }
        }
        ArrayList mapList = new ArrayList();
        eocDeptList.stream().filter(Objects::nonNull).forEach(dept -> {
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("sid", String.valueOf(dept.getSid()));
            map.put("name", dept.getName());
            map.put("parentSid", String.valueOf(dept.getParentSid()));
            mapList.add(map);
        });
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("list", mapList);
        data.put("total", Integer.valueOf(mapList.size()));
        return ApiResponse.buildOK().setData(data);
    }

    @RequestMapping(value={"/dept/emp/list"}, method={RequestMethod.POST})
    public ApiResponse<Map> getDeptEmps(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String sid = (String)params.get("sid");
        String tenantId = (String)params.get("tenantId");
        ArrayList eocDeptPersonList = new ArrayList();
        EocDeptPersonResponse eocDeptPersonResponse = this.digiwinEocProxyService.getEocDeptPersonList(sid, iamUserToken, 100, 1);
        if (eocDeptPersonResponse != null) {
            eocDeptPersonList.addAll(eocDeptPersonResponse.getList());
            Integer total = eocDeptPersonResponse.getTotal();
            if (total > eocDeptPersonList.size()) {
                int page = total / 100 + 1;
                for (int num = 2; num <= page; ++num) {
                    EocDeptPersonResponse eocDeptPersonResp = this.digiwinEocProxyService.getEocDeptPersonList(sid, iamUserToken, 100, num);
                    if (eocDeptPersonResp == null) continue;
                    eocDeptPersonList.addAll(eocDeptPersonResp.getList());
                }
            }
        }
        ArrayList mapList = new ArrayList();
        eocDeptPersonList.stream().filter(Objects::nonNull).forEach(person -> {
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("eocId", person.getId());
            map.put("userId", person.getUserId());
            map.put("name", person.getName());
            map.put("sortField", HypyUtil.getPinYin((String)person.getName()));
            map.put("dept", person.getMainDeptName() + "-" + person.getLevelName());
            map.put("accId", "");
            IMUser imUser = this.digiwinImProxyService.userGetAndCreate(iamUserToken, tenantId, person.getId());
            if (imUser != null && imUser.getAccid() != null) {
                map.put("accId", imUser.getAccid());
            }
            mapList.add(map);
        });
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("list", mapList);
        data.put("total", Integer.valueOf(mapList.size()));
        return ApiResponse.buildOK().setData(data);
    }

    @RequestMapping(value={"/emp/info"}, method={RequestMethod.POST})
    public ApiResponse<Map> getEmpInfo(HttpServletRequest request) throws IOException {
        EocPersonInfo eocPersonInfo;
        Boolean useMock = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String id = (String)params.get("eocId");
        Integer type = (Integer)params.get("type");
        if (type == null) {
            type = 1;
        }
        if ((eocPersonInfo = this.digiwinEocProxyService.getEocPersonInfo(id, iamUserToken, type.intValue())) == null) {
            return ApiResponse.buildError((String)"not find emp by id");
        }
        if (useMock.booleanValue() || modelTypeShow.booleanValue()) {
            this.doEmpInfoMockData(eocPersonInfo);
        }
        return ApiResponse.buildOK().setData((Object)eocPersonInfo);
    }

    @RequestMapping(value={"/emp/search"}, method={RequestMethod.POST})
    public ApiResponse<Map> searchEmpInfo(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap((HttpServletRequest)request, (boolean)false, (String)"UTF-8");
        String iamUserToken = (String)params.get("iamUserToken");
        String content = (String)params.get("content");
        EocPersonResponse eocPersonResponse = this.digiwinEocProxyService.getPersonList(iamUserToken, 999, 1, content);
        EocPersonResponse filterPersonResponse = new EocPersonResponse();
        if (eocPersonResponse != null && eocPersonResponse.getList().size() > 0) {
            ArrayList<EocPerson> list = new ArrayList<EocPerson>(eocPersonResponse.getList().size());
            for (EocPerson person : eocPersonResponse.getList()) {
                if (!person.getName().contains(content)) continue;
                person.setSortField(HypyUtil.getPinYin((String)person.getName()));
                person.setEocId(person.getId());
                list.add(person);
            }
            filterPersonResponse.setList(list);
            return ApiResponse.buildOK().setData(JsonUtil.objectToJavaObject((Object)filterPersonResponse, Map.class));
        }
        return ApiResponse.buildOK().setData(Collections.emptyMap());
    }

    private void doEmpInfoMockData(EocPersonInfo eocPersonInfo) {
        if (!StringUtils.hasLength((String)eocPersonInfo.getPhone())) {
            eocPersonInfo.setPhone("13641629516");
        }
    }
}

