/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.appec;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTitle;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogPerformer;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectPerformer;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocDept;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class SlipConfigLeft {
    private String title;
    private SlipTitle subTitle;
    private List<EocPersonInfo> personList = new ArrayList();

    public static SlipConfigLeft build(String locale, String athenaTaskName) {
        SlipConfigLeft left = new SlipConfigLeft();
        left.setTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u534f\u540c"));
        SlipTitle slipTitle = new SlipTitle();
        slipTitle.setContent(athenaTaskName + " " + LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5f53\u524d\u6c9f\u901a"));
        left.setSubTitle(slipTitle);
        return left;
    }

    public static SlipConfigLeft setPersonList(SlipConfigLeft left, List<DigiwinAtmcProjectPerformer> projectPerformers, EocPersonResponse eocPersonResponse) {
        List personList = left.getPersonList();
        if (eocPersonResponse != null && eocPersonResponse.getTotal() > 0) {
            List eocPersonList = eocPersonResponse.getList();
            for (DigiwinAtmcProjectPerformer projectPerformer : projectPerformers) {
                EocPersonInfo personInfo = new EocPersonInfo();
                for (EocPerson eocPerson : eocPersonList) {
                    if (!projectPerformer.getPersonInCharge().equals(eocPerson.getUserId())) continue;
                    personList.add(SlipConfigLeft.setPersonInfo((EocPerson)eocPerson, (EocPersonInfo)personInfo, (String)projectPerformer.getNeteaseImAccId()));
                }
            }
        }
        left.setPersonList((List)personList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EocPersonInfo>(Comparator.comparing(EocPersonInfo::getEocId))), ArrayList::new)));
        return left;
    }

    public static SlipConfigLeft setPersonListByBacklog(SlipConfigLeft left, List<DigiwinAtmcBacklogPerformer> backlogPerformers, EocPersonResponse eocPersonResponse) {
        List personList = left.getPersonList();
        if (eocPersonResponse != null && eocPersonResponse.getTotal() > 0) {
            List eocPersonList = eocPersonResponse.getList();
            for (DigiwinAtmcBacklogPerformer backlogPerformer : backlogPerformers) {
                EocPersonInfo personInfo = new EocPersonInfo();
                for (EocPerson eocPerson : eocPersonList) {
                    if (!backlogPerformer.getPerformerId().equals(eocPerson.getUserId())) continue;
                    personList.add(SlipConfigLeft.setPersonInfo((EocPerson)eocPerson, (EocPersonInfo)personInfo, (String)backlogPerformer.getNeteaseImAccId()));
                }
            }
        }
        left.setPersonList((List)personList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EocPersonInfo>(Comparator.comparing(EocPersonInfo::getEocId))), ArrayList::new)));
        return left;
    }

    private static EocPersonInfo setPersonInfo(EocPerson eocPerson, EocPersonInfo personInfo, String accId) {
        DigiwinIamUserInfo userInfo = eocPerson.getUser();
        if (userInfo != null) {
            personInfo.setPhone(userInfo.getTelephone());
            personInfo.setEmail(userInfo.getEmail());
            personInfo.setTitleName(eocPerson.getTitleName());
        }
        personInfo.setEocId(eocPerson.getId());
        personInfo.setName(eocPerson.getName());
        List depts = eocPerson.getDepts();
        if (depts != null && depts.size() > 0) {
            for (EocDept dept : depts) {
                if (!dept.isMainDept()) continue;
                personInfo.setDept(dept.getName());
                break;
            }
        }
        personInfo.setUserId(eocPerson.getUserId());
        personInfo.setAccId(accId);
        return personInfo;
    }

    public String getTitle() {
        return this.title;
    }

    public SlipTitle getSubTitle() {
        return this.subTitle;
    }

    public List<EocPersonInfo> getPersonList() {
        return this.personList;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubTitle(SlipTitle subTitle) {
        this.subTitle = subTitle;
    }

    public void setPersonList(List<EocPersonInfo> personList) {
        this.personList = personList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlipConfigLeft)) {
            return false;
        }
        SlipConfigLeft other = (SlipConfigLeft)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        SlipTitle this$subTitle = this.getSubTitle();
        SlipTitle other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        List this$personList = this.getPersonList();
        List other$personList = other.getPersonList();
        return !(this$personList == null ? other$personList != null : !((Object)this$personList).equals(other$personList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlipConfigLeft;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        SlipTitle $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        List $personList = this.getPersonList();
        result = result * 59 + ($personList == null ? 43 : ((Object)$personList).hashCode());
        return result;
    }

    public String toString() {
        return "SlipConfigLeft(title=" + this.getTitle() + ", subTitle=" + this.getSubTitle() + ", personList=" + this.getPersonList() + ")";
    }

    public SlipConfigLeft(String title, SlipTitle subTitle, List<EocPersonInfo> personList) {
        this.title = title;
        this.subTitle = subTitle;
        this.personList = personList;
    }

    public SlipConfigLeft() {
    }
}

