/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleSubcategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRuleDate;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRuleText;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public abstract class BaseInputMobileComponent
extends BaseMobileComponent {
    private static final long serialVersionUID = -1088809041057122311L;
    protected Boolean enable;
    protected String errorMessage;
    protected String placeholder;
    protected Boolean required;
    protected List<ValidateRule> validateRuleList;
    protected RelationRule relationRule;
    protected String schema;
    protected Boolean hidden;

    public void addAllMobileRule(Map<String, Object> bizData, String schema, List<Rule> ruleList, String locale, ApiRequest apiRequest, Map<String, Object> variableMaps, String text) {
        List relationRuleList;
        List validateRuleList = ruleList.stream().filter(rule -> rule.getCategory().equalsIgnoreCase(RuleCategoryEnum.VALIDATE.getCategory()) && rule.getSchema().equalsIgnoreCase(schema)).collect(Collectors.toList());
        if (Rule.hasCustomMadeRule((ApiRequest)apiRequest, validateRuleList)) {
            validateRuleList = Rule.compareRule((ApiRequest)apiRequest, validateRuleList, (String)RuleCategoryEnum.VALIDATE.getCategory());
        }
        if (Rule.hasCustomMadeRule((ApiRequest)apiRequest, relationRuleList = ruleList.stream().filter(rule -> rule.getCategory().equalsIgnoreCase(RuleCategoryEnum.RELATION.getCategory()) && rule.getSchema().equalsIgnoreCase(schema)).collect(Collectors.toList()))) {
            relationRuleList = Rule.compareRule((ApiRequest)apiRequest, relationRuleList, (String)RuleCategoryEnum.RELATION.getCategory());
        }
        for (Rule validateRule : validateRuleList) {
            if (!validateRule.validWithBizData(bizData)) continue;
            if (!CollectionUtils.isEmpty(variableMaps) && validateRule.getInitConfig() != null && validateRule.getInitConfig().getKey() != null) {
                if (((Boolean)variableMaps.get(validateRule.getInitConfig().getKey())).booleanValue()) continue;
                this.getValidateRuleList().add(ValidateRule.create((Rule)validateRule, (String)locale, bizData));
                continue;
            }
            this.getValidateRuleList().add(ValidateRule.create((Rule)validateRule, (String)locale, bizData));
        }
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
        RelationRule resultRelationRule = new RelationRule();
        for (Rule relationRule : relationRuleList) {
            if (!relationRule.validWithBizData(bizData)) continue;
            if (relationRule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.DATE.getSubcategory())) {
                resultRelationRule.addRelationRuleDate(RelationRuleDate.create(bizData, (Rule)relationRule));
                continue;
            }
            if (relationRule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.TEXT.getSubcategory())) {
                RelationRuleText relationRuleText = RelationRuleText.create(bizData, (Rule)relationRule);
                if (!Objects.isNull(relationRuleText) && StringUtils.isNotEmpty((CharSequence)relationRuleText.getTargetPlaceholder())) {
                    relationRuleText.setTargetPlaceholder(localeService.getLanguageValue(locale, relationRuleText.getTargetPlaceholder()));
                }
                resultRelationRule.addRelationRuleText(relationRuleText);
                continue;
            }
            if (!relationRule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.COMMON.getSubcategory())) continue;
            CommonRule commonRule = null;
            if (!CollectionUtils.isEmpty(variableMaps) && relationRule.getInitConfig() != null && StringUtil.isNotEmpty((CharSequence)relationRule.getInitConfig().getKey())) {
                if (((Boolean)variableMaps.get(relationRule.getInitConfig().getKey())).booleanValue()) {
                    commonRule = CommonRule.create((CommonRule)relationRule.getCommonRule(), (Object)text);
                }
            } else {
                commonRule = relationRule.getCommonRule();
            }
            if (!Objects.isNull(commonRule) && StringUtils.isNotEmpty((CharSequence)commonRule.getTargetPlaceholder())) {
                commonRule.setTargetPlaceholder(localeService.getLanguageValue(locale, commonRule.getTargetPlaceholder()));
            }
            resultRelationRule.addCommonRule(commonRule);
        }
        this.setRelationRule(resultRelationRule);
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public List<ValidateRule> getValidateRuleList() {
        if (null == this.validateRuleList) {
            this.validateRuleList = new ArrayList();
        }
        return this.validateRuleList;
    }

    public void setValidateRuleList(List<ValidateRule> validateRuleList) {
        this.validateRuleList = validateRuleList;
    }

    public RelationRule getRelationRule() {
        if (null == this.relationRule) {
            this.relationRule = new RelationRule();
        }
        return this.relationRule;
    }

    public void setRelationRule(RelationRule relationRule) {
        this.relationRule = relationRule;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void applyEditable(Boolean enable) {
        this.enable = enable;
    }

    public void applyHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
    }
}

