/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotMultipleDataSourceService;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.DWCallWorkEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryInfo;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class BaseMobileComponent
implements MobileComponent,
Serializable {
    private static final long serialVersionUID = -3463956265364418603L;
    protected String cmptUuid = UUIDUtil.getUuid();
    protected Integer cmptVersion;
    protected String schema;
    protected String mobilePath;
    protected String componentId;
    protected Map<String, Object> hooks;

    protected BaseMobileComponent() {
    }

    public void initSetting(String locale) {
    }

    public void forceSetCmptVersion2() {
        this.cmptVersion = 2;
    }

    public String getCmptUuid() {
        return StringUtils.hasLength((String)this.getComponentId()) ? this.getComponentId() : this.cmptUuid;
    }

    public void applyEditable(Boolean enable) {
        super.applyEditable(enable);
    }

    public void applyHidden(Boolean hidden) {
        super.applyHidden(hidden);
    }

    public void resetCmptMultipleDataSourceData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> data) {
        Map multipleDataSourceData = ((UiBotMultipleDataSourceService)SpringContextHolder.getBean(UiBotMultipleDataSourceService.class)).buildCmptMultipleDataSourceData(cmptContext, executeContext, dataSource, data);
        if (multipleDataSourceData != null) {
            data.clear();
            data.putAll(multipleDataSourceData);
        }
    }

    public void resetCmptMultipleDataSourceDataAndQueryInfo(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, DataSource dataSource, Map<String, Object> data, PcUiBotQueryInfo queryInfo) {
        Map multipleDataSourceData = null;
        multipleDataSourceData = queryInfo == null || queryInfo.getPageInfo() == null || queryInfo.getPageInfo().getPageSize() == null ? ((UiBotMultipleDataSourceService)SpringContextHolder.getBean(UiBotMultipleDataSourceService.class)).buildCmptMultipleDataSourceData(cmptContext, executeContext, dataSource, data) : ((UiBotMultipleDataSourceService)SpringContextHolder.getBean(UiBotMultipleDataSourceService.class)).resetCmptMultipleDataSourceDataAndQueryInfo(cmptContext, executeContext, dataSource, data, queryInfo);
        if (multipleDataSourceData != null) {
            data.clear();
            data.putAll(multipleDataSourceData);
        }
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        if (this.judgeNotEditable(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData)) {
            this.applyEditable(Boolean.valueOf(false));
        }
        if (!CollectionUtils.isEmpty((Collection)cmptContext.getHooks())) {
            this.hooks = cmptContext.getHooks().stream().filter(e -> Objects.equals(this.getComponentId(), MapUtils.getString((Map)e, (Object)"eventSource"))).findFirst().orElse(null);
        }
    }

    private boolean judgeNotEditable(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        List dataKeys;
        if (DWCallWorkEnum.EDIT.getValue().equals(cmptContext.getRawData().getDesignParameter().getDWCallWork()) && !CollectionUtils.isEmpty((Collection)(dataKeys = mobilePageRawData.getDataKeys())) && dataKeys.contains(schema)) {
            return true;
        }
        if (TaskStringUtil.isBizSmartAdjust((String)executeContext.getTmActivityId()) && TaskStringUtil.isBizApproval((String)executeContext.getPattern(), (String)executeContext.getCategory())) {
            return true;
        }
        return SsoSourceTypeEnum.NANA_MESSAGE.getSource().equals(cmptContext.getSourceType()) && cmptContext.getReadOnly() != false;
    }

    public Integer getCmptVersion() {
        return this.cmptVersion;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getMobilePath() {
        return this.mobilePath;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Map<String, Object> getHooks() {
        return this.hooks;
    }

    public void setCmptUuid(String cmptUuid) {
        this.cmptUuid = cmptUuid;
    }

    public void setCmptVersion(Integer cmptVersion) {
        this.cmptVersion = cmptVersion;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setMobilePath(String mobilePath) {
        this.mobilePath = mobilePath;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public void setHooks(Map<String, Object> hooks) {
        this.hooks = hooks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseMobileComponent)) {
            return false;
        }
        BaseMobileComponent other = (BaseMobileComponent)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$cmptVersion = this.getCmptVersion();
        Integer other$cmptVersion = other.getCmptVersion();
        if (this$cmptVersion == null ? other$cmptVersion != null : !((Object)this$cmptVersion).equals(other$cmptVersion)) {
            return false;
        }
        String this$cmptUuid = this.getCmptUuid();
        String other$cmptUuid = other.getCmptUuid();
        if (this$cmptUuid == null ? other$cmptUuid != null : !this$cmptUuid.equals(other$cmptUuid)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$mobilePath = this.getMobilePath();
        String other$mobilePath = other.getMobilePath();
        if (this$mobilePath == null ? other$mobilePath != null : !this$mobilePath.equals(other$mobilePath)) {
            return false;
        }
        String this$componentId = this.getComponentId();
        String other$componentId = other.getComponentId();
        if (this$componentId == null ? other$componentId != null : !this$componentId.equals(other$componentId)) {
            return false;
        }
        Map this$hooks = this.getHooks();
        Map other$hooks = other.getHooks();
        return !(this$hooks == null ? other$hooks != null : !((Object)this$hooks).equals(other$hooks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseMobileComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cmptVersion = this.getCmptVersion();
        result = result * 59 + ($cmptVersion == null ? 43 : ((Object)$cmptVersion).hashCode());
        String $cmptUuid = this.getCmptUuid();
        result = result * 59 + ($cmptUuid == null ? 43 : $cmptUuid.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $mobilePath = this.getMobilePath();
        result = result * 59 + ($mobilePath == null ? 43 : $mobilePath.hashCode());
        String $componentId = this.getComponentId();
        result = result * 59 + ($componentId == null ? 43 : $componentId.hashCode());
        Map $hooks = this.getHooks();
        result = result * 59 + ($hooks == null ? 43 : ((Object)$hooks).hashCode());
        return result;
    }

    public String toString() {
        return "BaseMobileComponent(cmptUuid=" + this.getCmptUuid() + ", cmptVersion=" + this.getCmptVersion() + ", schema=" + this.getSchema() + ", mobilePath=" + this.getMobilePath() + ", componentId=" + this.getComponentId() + ", hooks=" + this.getHooks() + ")";
    }
}

