/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Executor;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Field
extends BaseMobileComponent {
    private static final long serialVersionUID = -8888100200580189673L;
    public static final String COMPONENT_TYPE = "FIELD";
    protected String label;
    protected Boolean labelVisible;
    protected String type;
    protected String value;
    protected String schema;
    private String hideValue;
    protected String text;
    protected Integer alignmentType = FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue();
    protected Integer labelStyleType;
    protected Integer valueStyleType;
    private BaseMobileComponentPerson person;
    private Boolean changeFlag = false;
    protected Boolean hidden;
    protected Boolean enable;
    protected Executor executor;
    protected Action action;
    private Integer align = FieldAlignEnum.HORIZONTAL.getValue();

    public Field() {
    }

    protected Field(String label, String type, String value) {
        this.label = label;
        this.type = null == type ? "LABEL" : type;
        this.value = value;
    }

    public static Field create(String label, String value) {
        return Field.create((String)label, (String)"LABEL", (String)(StringUtils.hasLength((String)value) ? value : "-"));
    }

    public static Field createLabelValueLeftFieldNoNewLineWith18px(String label, String value) {
        Field field = Field.create((String)label, (String)"LABEL", (String)(StringUtils.hasLength((String)value) ? value : "-"));
        field.setLabelVisible(Boolean.valueOf(StringUtils.hasLength((String)label)));
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_WITH_18PX.getValue());
        field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_GREY.getValue());
        field.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BLACK.getValue());
        return field;
    }

    public static Field createLabelValueLeftField(String label, String value) {
        Field field = Field.create((String)label, (String)"LABEL", (String)(StringUtils.hasLength((String)value) ? value : "-"));
        if (!StringUtils.hasLength((String)label)) {
            field.setLabelVisible(Boolean.valueOf(false));
            field.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BIG_TITLE.getValue());
        } else {
            field.setLabelVisible(Boolean.valueOf(true));
        }
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
        return field;
    }

    public static Field createFieldOfOtherScene(String label, String value) {
        Field field = Field.create((String)label, (String)"LABEL", (String)(StringUtils.hasLength((String)value) ? value : "-"));
        field.setValueStyleType(Integer.valueOf(1));
        return field;
    }

    public static Field createLabelValueLeftField(String label, String value, Integer labelType, Integer valueType, String hideValue) {
        Field field = Field.create((String)label, (String)"LABEL", (String)(StringUtils.hasLength((String)value) ? value : "-"));
        field.setLabelVisible(Boolean.valueOf(StringUtils.hasLength((String)label)));
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
        field.setLabelStyleType(labelType);
        field.setValueStyleType(valueType);
        field.setHideValue(hideValue);
        return field;
    }

    public static Field createLabelLeftValueRightField(String label, String value, Integer labelType, Integer valueType) {
        Field field = Field.create((String)label, (String)"LABEL", (String)(StringUtils.hasLength((String)value) ? value : "-"));
        field.setLabelVisible(Boolean.valueOf(StringUtils.hasLength((String)label)));
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue());
        field.setLabelStyleType(labelType);
        field.setValueStyleType(valueType);
        return field;
    }

    public static Field createLabelLeftValueRightField(String label, String value) {
        Field field = Field.create((String)label, (String)"LABEL", (String)(StringUtils.hasLength((String)value) ? value : "-"));
        field.setLabelVisible(Boolean.valueOf(StringUtils.hasLength((String)label)));
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue());
        field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_GREY.getValue());
        field.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BLACK.getValue());
        return field;
    }

    public static Field createLabelLeftValueRightFieldBy18PX(String label, String value, Integer labelType, Integer valueType) {
        Field field = Field.create((String)label, (String)"LABEL", (String)(StringUtils.hasLength((String)value) ? value : "-"));
        field.setLabelVisible(Boolean.valueOf(StringUtils.hasLength((String)label)));
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue());
        field.setLabelStyleType(labelType);
        field.setValueStyleType(valueType);
        return field;
    }

    public static Field createLabelValueLeftFieldNoNewLine(String label, String value) {
        Field field = Field.create((String)label, (String)"LABEL", (String)(StringUtils.hasLength((String)value) ? value : "-"));
        field.setLabelVisible(Boolean.valueOf(StringUtils.hasLength((String)label)));
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
        return field;
    }

    public static Field create(String label, String type, String value) {
        Field field = new Field();
        field.setLabel(label);
        field.setType(type);
        field.setValue(value);
        return field;
    }

    public static Field create(String label, String type, String value, String schema) {
        Field field = new Field();
        field.setLabel(label);
        field.setType(type);
        field.setValue(value);
        field.setSchema(schema);
        return field;
    }

    public static Field create(String label, String type, String value, String schema, Integer fieldAlignmentTypeEnum) {
        Field field = new Field();
        field.setLabel(label);
        field.setType(type);
        field.setValue(value);
        field.setSchema(schema);
        field.setAlignmentType(fieldAlignmentTypeEnum);
        return field;
    }

    public static Field create(String label, String value, FieldAlignmentTypeEnum fieldAlignmentTypeEnum, Boolean isComplete) {
        Field field = Field.create((String)label, (String)"LABEL", (String)value);
        if (null != fieldAlignmentTypeEnum) {
            field.setAlignmentType(fieldAlignmentTypeEnum.getValue());
        }
        field.setEnable(Boolean.valueOf(isComplete == false));
        return field;
    }

    public static Field create(String label, String value, Integer labelStyleType, FieldAlignmentTypeEnum fieldAlignmentTypeEnum, Boolean isComplete) {
        Field field = Field.create((String)label, (String)"LABEL", (String)value);
        if (null != fieldAlignmentTypeEnum) {
            field.setAlignmentType(fieldAlignmentTypeEnum.getValue());
        }
        field.setLabelStyleType(labelStyleType);
        field.setEnable(Boolean.valueOf(isComplete == false));
        return field;
    }

    public static Field create(String label, String value, Integer labelStyleType, FieldAlignmentTypeEnum fieldAlignmentTypeEnum, HashMap maps, Boolean isComplete) {
        Field field = Field.create((String)label, (String)"LABEL", (String)value);
        if (null != fieldAlignmentTypeEnum) {
            field.setAlignmentType(fieldAlignmentTypeEnum.getValue());
        }
        field.setLabelStyleType(labelStyleType);
        if (maps != null && maps.size() > 0) {
            Executor executor = new Executor();
            executor.setExecutorEmpId((String)maps.get("executorEmpId"));
            executor.setExecutorEmpName((String)maps.get("executorEmpName"));
            executor.setExecutorUserId((String)maps.get("executorUserId"));
            executor.setExecutorUserName((String)maps.get("executorUserName"));
            field.setExecutor(executor);
        }
        field.setEnable(Boolean.valueOf(isComplete == false));
        return field;
    }

    public static Field create(UiBotTableColumn column, Map<String, Object> bizData) {
        return Field.create((UiBotTableColumn)column, (String)column.getValueForDisplay(bizData));
    }

    public static Field create(UiBotTableColumn column, String value) {
        Field field = Field.create((String)column.getHeaderName(), (String)column.getType(), (String)value);
        field.setSchema(column.getSchema());
        return field;
    }

    public static Field create(UiBotTableColumn column, Map<String, Object> bizData, FieldAlignmentTypeEnum fieldAlignmentTypeEnum) {
        Field field = Field.create((UiBotTableColumn)column, (String)column.getValueForDisplay(bizData));
        if (null != fieldAlignmentTypeEnum) {
            field.setAlignmentType(fieldAlignmentTypeEnum.getValue());
        }
        return field;
    }

    public static Field create(UiBotLayout fieldLayout, String value) {
        Field field = new Field();
        field.setSchema(fieldLayout.getSchema());
        field.setLabel(fieldLayout.getHeaderName());
        field.setType(fieldLayout.getType());
        field.setValue(value);
        return field;
    }

    public static Field create(ParseFieldData fieldData, String locale) {
        if (fieldData == null || fieldData.getData() == null || fieldData.getLabel() == null) {
            return null;
        }
        Field field = new Field();
        field.setLabel(fieldData.getLabel());
        field.setSchema(fieldData.getSchema());
        if ("TASK_PROGRESS_STATUS".equalsIgnoreCase(fieldData.getType())) {
            Map dataMap = (Map)fieldData.getData();
            String planEndTime = (String)dataMap.get("planEndTime");
            Boolean close = (Boolean)dataMap.get("closed");
            String endTime = (String)dataMap.get("endTime");
            if (close.booleanValue()) {
                if (DateTimeUtil.compareTime((String)endTime, (String)planEndTime).booleanValue()) {
                    field.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5df2\u5b8c\u6210"));
                } else {
                    int days = DateTimeUtil.getDateTimePeriod((String)planEndTime, (String)endTime);
                    field.setValue(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u540e\u5b8c\u6210"), days));
                }
            } else if (!DateTimeUtil.isBeforeNowDateTime((String)planEndTime).booleanValue()) {
                field.setValue(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u6b63\u5728\u8fdb\u884c"));
            } else {
                int days = DateTimeUtil.getDateTimePeriod((String)planEndTime, (String)DateTimeUtil.getTodayTimeUseDefaultPattern());
                field.setValue(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u903e\u671f\u5929\u6570"), days));
            }
        } else if (fieldData.getOptions() != null) {
            fieldData.getOptions().forEach(uiBotTableColumnEditorOption -> {
                if (fieldData.getData().equals(uiBotTableColumnEditorOption.getValue())) {
                    field.setValue(uiBotTableColumnEditorOption.getTitle());
                }
            });
        } else {
            field.setValue(StringUtils.hasLength((String)fieldData.getData().toString()) ? fieldData.getData().toString() : "-");
        }
        return field;
    }

    public static Field create(ParseFieldData fieldData, String locale, String value) {
        if (fieldData == null || fieldData.getData() == null || fieldData.getLabel() == null) {
            return null;
        }
        Field field = new Field();
        field.setLabel(ModuleUtils.localeService.getLanguageValue(locale, fieldData.getLabel()));
        field.setSchema(fieldData.getSchema());
        field.setValue(value);
        return field;
    }

    public static Field create(String label, Integer labelStyleType, Integer valueStyleType, String value) {
        Field field = new Field();
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue());
        field.setLabel(label);
        field.setLabelStyleType(labelStyleType);
        field.setValueStyleType(valueStyleType);
        field.setValue(value);
        return field;
    }

    public static Field create(String label, String type, String value, Integer alignmentType, Boolean hasLabel) {
        Field field = new Field();
        field.setLabel(label);
        field.setType(type);
        field.setValue(value);
        field.setAlignmentType(alignmentType);
        field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_GREY.getValue());
        if (!hasLabel.booleanValue()) {
            field.setLabel("");
            field.setLabelVisible(hasLabel);
            field.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BIG_TITLE.getValue());
        }
        return field;
    }

    public static Field create(String label, String value, Integer alignmentType, Integer valueStyleType, Boolean hidden) {
        Field field = new Field();
        field.setLabel(label);
        field.setValue(StringUtils.hasLength((String)value) ? value : "-");
        field.setAlignmentType(alignmentType);
        field.setValueStyleType(valueStyleType);
        field.setHidden(hidden);
        return field;
    }

    public static Field createZtbField(String label, Integer labelStyleType, Integer valueStyleType, String value, Integer alignmentType) {
        Field field = new Field();
        field.setAlignmentType(alignmentType);
        field.setLabel(label);
        field.setLabelStyleType(labelStyleType);
        field.setValueStyleType(valueStyleType);
        field.setValue(value);
        return field;
    }

    public static Field createApcField(String label, Integer labelStyleType, Integer valueStyleType, String value, Integer alignmentType, Boolean changeFlag) {
        Field field = new Field();
        field.setAlignmentType(alignmentType);
        field.setLabel(label);
        field.setLabelStyleType(labelStyleType);
        field.setValueStyleType(valueStyleType);
        field.setValue(value);
        field.setChangeFlag(changeFlag);
        return field;
    }

    public static Field createProcess(String label, String value) {
        Field field = new Field();
        field.setLabel(label);
        field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_GREY.getValue());
        field.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BLACK.getValue());
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT.getValue());
        field.setValue(value);
        return field;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Integer getAlignmentType() {
        return this.alignmentType;
    }

    public void setAlignmentType(Integer alignmentType) {
        this.alignmentType = alignmentType;
    }

    public Integer getLabelStyleType() {
        return this.labelStyleType;
    }

    public void setLabelStyleType(Integer labelStyleType) {
        this.labelStyleType = labelStyleType;
    }

    public Integer getValueStyleType() {
        return this.valueStyleType;
    }

    public void setValueStyleType(Integer valueStyleType) {
        this.valueStyleType = valueStyleType;
    }

    public String returnComponentType() {
        return "FIELD";
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public BaseMobileComponentPerson getPerson() {
        return this.person;
    }

    public void setPerson(BaseMobileComponentPerson person) {
        this.person = person;
    }

    public Boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(Boolean labelVisible) {
        this.labelVisible = labelVisible;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getHideValue() {
        return this.hideValue;
    }

    public void setHideValue(String hideValue) {
        this.hideValue = hideValue;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(Object::toString).orElse(null);
        if (StringUtils.hasLength((String)value)) {
            this.value = "\n".equalsIgnoreCase(value) ? "-" : value;
        } else if (!BooleanUtils.isTrue((Boolean)this.enable)) {
            this.value = "-";
        }
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        Field field = new Field();
        field.setComponentId(rawContent.getComponentId());
        field.setLabel(rawContent.getLabel());
        field.setEnable(Boolean.valueOf(false));
        field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_GREY.getValue());
        field.setValueStyleType(FieldValueStyleTypeEnum.VALUE_GRAY.getValue());
        field.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return field;
    }

    public void applyEditable(Boolean enable) {
        this.enable = enable;
    }

    public void applyHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Boolean getChangeFlag() {
        return this.changeFlag;
    }

    public Integer getAlign() {
        return this.align;
    }

    public void setChangeFlag(Boolean changeFlag) {
        this.changeFlag = changeFlag;
    }

    public void setAlign(Integer align) {
        this.align = align;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$labelVisible = this.getLabelVisible();
        Boolean other$labelVisible = other.getLabelVisible();
        if (this$labelVisible == null ? other$labelVisible != null : !((Object)this$labelVisible).equals(other$labelVisible)) {
            return false;
        }
        Integer this$alignmentType = this.getAlignmentType();
        Integer other$alignmentType = other.getAlignmentType();
        if (this$alignmentType == null ? other$alignmentType != null : !((Object)this$alignmentType).equals(other$alignmentType)) {
            return false;
        }
        Integer this$labelStyleType = this.getLabelStyleType();
        Integer other$labelStyleType = other.getLabelStyleType();
        if (this$labelStyleType == null ? other$labelStyleType != null : !((Object)this$labelStyleType).equals(other$labelStyleType)) {
            return false;
        }
        Integer this$valueStyleType = this.getValueStyleType();
        Integer other$valueStyleType = other.getValueStyleType();
        if (this$valueStyleType == null ? other$valueStyleType != null : !((Object)this$valueStyleType).equals(other$valueStyleType)) {
            return false;
        }
        Boolean this$changeFlag = this.getChangeFlag();
        Boolean other$changeFlag = other.getChangeFlag();
        if (this$changeFlag == null ? other$changeFlag != null : !((Object)this$changeFlag).equals(other$changeFlag)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        Integer this$align = this.getAlign();
        Integer other$align = other.getAlign();
        if (this$align == null ? other$align != null : !((Object)this$align).equals(other$align)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$hideValue = this.getHideValue();
        String other$hideValue = other.getHideValue();
        if (this$hideValue == null ? other$hideValue != null : !this$hideValue.equals(other$hideValue)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        BaseMobileComponentPerson this$person = this.getPerson();
        BaseMobileComponentPerson other$person = other.getPerson();
        if (this$person == null ? other$person != null : !this$person.equals(other$person)) {
            return false;
        }
        Executor this$executor = this.getExecutor();
        Executor other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Field;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $labelVisible = this.getLabelVisible();
        result = result * 59 + ($labelVisible == null ? 43 : ((Object)$labelVisible).hashCode());
        Integer $alignmentType = this.getAlignmentType();
        result = result * 59 + ($alignmentType == null ? 43 : ((Object)$alignmentType).hashCode());
        Integer $labelStyleType = this.getLabelStyleType();
        result = result * 59 + ($labelStyleType == null ? 43 : ((Object)$labelStyleType).hashCode());
        Integer $valueStyleType = this.getValueStyleType();
        result = result * 59 + ($valueStyleType == null ? 43 : ((Object)$valueStyleType).hashCode());
        Boolean $changeFlag = this.getChangeFlag();
        result = result * 59 + ($changeFlag == null ? 43 : ((Object)$changeFlag).hashCode());
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        Integer $align = this.getAlign();
        result = result * 59 + ($align == null ? 43 : ((Object)$align).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $hideValue = this.getHideValue();
        result = result * 59 + ($hideValue == null ? 43 : $hideValue.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        BaseMobileComponentPerson $person = this.getPerson();
        result = result * 59 + ($person == null ? 43 : $person.hashCode());
        Executor $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    public String toString() {
        return "Field(label=" + this.getLabel() + ", labelVisible=" + this.getLabelVisible() + ", type=" + this.getType() + ", value=" + this.getValue() + ", schema=" + this.getSchema() + ", hideValue=" + this.getHideValue() + ", text=" + this.getText() + ", alignmentType=" + this.getAlignmentType() + ", labelStyleType=" + this.getLabelStyleType() + ", valueStyleType=" + this.getValueStyleType() + ", person=" + this.getPerson() + ", changeFlag=" + this.getChangeFlag() + ", hidden=" + this.getHidden() + ", enable=" + this.getEnable() + ", executor=" + this.getExecutor() + ", action=" + this.getAction() + ", align=" + this.getAlign() + ")";
    }
}

