/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.basic;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.LabelTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import java.io.Serializable;
import java.util.List;

public class Label
implements Serializable {
    private static final long serialVersionUID = -2659759227013979213L;
    private String text;
    private String type;
    private Action action;

    public Label(String text, String type, Action action) {
        this.text = text;
        this.type = type;
        this.action = action;
    }

    public Label(String text, String type) {
        this.text = text;
        this.type = type;
    }

    public static Label create(String text, String type) {
        return new Label(text, type);
    }

    public static Label buildReassignReport(String locale, List<DigiwinReassignReport> reassignReportList) {
        Label label = new Label();
        label.setText(String.format(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u7531\u8f6c\u6d3e"), reassignReportList.get(0).getOldPerformerName()));
        label.setType(LabelTypeEnum.NORMAL.getType());
        label.setAction(Action.createReassignReportAction((String)locale, reassignReportList));
        return label;
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public Action getAction() {
        return this.action;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Label)) {
            return false;
        }
        Label other = (Label)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Label;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    public String toString() {
        return "Label(text=" + this.getText() + ", type=" + this.getType() + ", action=" + this.getAction() + ")";
    }

    public Label() {
    }
}

