/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.business.bizapproval;

import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinition;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.business.bizapproval.BizApprovalDataItemTitle;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BizApprovalDataItem
extends BaseMobileComponent
implements Serializable {
    private static final long serialVersionUID = 7118943813705734168L;
    public static final String COMPONENT_TYPE = "BIZ_APPROVAL_DATA_ITEM";
    private List<Field> content = new ArrayList(5);
    private List<Field> hideContent = new ArrayList(20);
    private BizApprovalDataItemTitle title;

    public static BizApprovalDataItem create(String locale, List<UiBotTableColumn> tableColumns, Map<String, Object> bizData, Map<String, ColumnTag> columnTagMap) {
        ArrayList leftTitle = new ArrayList();
        ArrayList rightTitle = new ArrayList();
        BizApprovalDataItem dataItem = new BizApprovalDataItem();
        tableColumns.forEach(column -> {
            String schema = column.getSchema();
            Optional optBizDataValue = Optional.ofNullable(bizData.get(schema));
            if (optBizDataValue.isPresent()) {
                String bizDataValue = optBizDataValue.get().toString();
                String columnTagCode = Optional.ofNullable(columnTagMap.get(schema)).map(ColumnTag::getTagDefinition).map(ColumnTagDefinition::getCode).orElse("");
                Field itemContentField = Field.create((UiBotTableColumn)column, (String)column.getValueForDisplay(bizData));
                if (columnTagCode.equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode())) {
                    leftTitle.add(bizDataValue);
                } else if (columnTagCode.equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_IMPORTANT.getCode())) {
                    rightTitle.add(bizDataValue);
                } else if (columnTagCode.equalsIgnoreCase(ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode())) {
                    if (!itemContentField.getValue().trim().isEmpty()) {
                        dataItem.getContent().add(itemContentField);
                    }
                } else if (!itemContentField.getValue().trim().isEmpty()) {
                    dataItem.getHideContent().add(itemContentField);
                }
            }
        });
        dataItem.setTitle(BizApprovalDataItemTitle.create((String)locale, leftTitle, (String)(rightTitle.isEmpty() ? "" : (String)rightTitle.get(0))));
        return dataItem;
    }

    public List<Field> getContent() {
        return this.content;
    }

    public void setContent(List<Field> content) {
        this.content = content;
    }

    public List<Field> getHideContent() {
        return this.hideContent;
    }

    public void setHideContent(List<Field> hideContent) {
        this.hideContent = hideContent;
    }

    public BizApprovalDataItemTitle getTitle() {
        return this.title;
    }

    public void setTitle(BizApprovalDataItemTitle title) {
        this.title = title;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }
}

