/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.business.bizprocess;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessDataList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="bizProcessDataListBuilder")
public class BizProcessDataListBuilder
implements MobileComponentBuilder<BizProcessDataList> {
    private static final Logger logger = LoggerFactory.getLogger(BizProcessDataListBuilder.class);
    @Autowired
    private RuleService ruleService;
    @Autowired
    private ColumnTagService columnTagService;

    public String getMobileComponentType() {
        return "MULTI_LEVEL_SUBMITTABLE_LIST";
    }

    public BizProcessDataList build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<BizProcessDataList> clazz, Object ... args) {
        List tableColumnDefinitionList;
        Assert.noNullElements((Object[])args, (String)"args must not null and not empty");
        Assert.isInstanceOf(UiBotLayout.class, (Object)args[0], (String)"args[0] must be instance of UiBotLayout.class!");
        UiBotLayout bizProcessDataListLayout = (UiBotLayout)args[0];
        UiBotTargetLayoutSearchResult layoutSearchResult = pcUiBotModel.searchPcTargetLayout();
        if (!layoutSearchResult.found()) {
            return BizProcessDataList.createEmpty();
        }
        UiBotLayout targetLayout = layoutSearchResult.getTargetUiBotLayout();
        String schema = pcUiBotModel.searchBizDataSchema();
        if (layoutSearchResult.getHasCustomData().booleanValue()) {
            if (null == targetLayout) {
                return BizProcessDataList.createEmpty();
            }
            if (null != targetLayout && null != targetLayout.getFinished() && targetLayout.getFinished().booleanValue()) {
                return BizProcessDataList.createEmpty();
            }
            if (null == targetLayout.getActions() || targetLayout.getActions().isEmpty()) {
                return BizProcessDataList.createEmpty();
            }
            List uiBotActions = targetLayout.getActions();
            tableColumnDefinitionList = bizProcessDataListLayout.getColumnDefs();
        } else {
            if (!"TABLE".equalsIgnoreCase(targetLayout.getType()) && !"GRID_TABLE".equalsIgnoreCase(targetLayout.getType())) {
                return BizProcessDataList.createEmpty();
            }
            tableColumnDefinitionList = targetLayout.getColumnDefs();
        }
        List bizDataList = (List)pcUiBotModel.getPageData().get((Object)schema);
        Assert.notNull((Object)bizDataList, (String)("pagedata." + schema + " cannot be null"));
        if (bizDataList.isEmpty()) {
            return BizProcessDataList.createEmpty();
        }
        if (tableColumnDefinitionList == null) {
            return BizProcessDataList.createEmpty();
        }
        List tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions((List)tableColumnDefinitionList);
        List columnTagList = this.columnTagService.listColumnTagsByPathAndPageId(schema, apiRequest.getPageId());
        List mobileRuleList = this.ruleService.findByRulePath(schema);
        return BizProcessDataList.create((ApiRequest)apiRequest, (UiBotLayout)bizProcessDataListLayout, (List)bizDataList, (UiBotModel)pcUiBotModel, (List)tableColumns, (List)columnTagList, (List)mobileRuleList);
    }
}

