/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.button;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="bottomButtonParamAnalyzer")
public class BottomButtonParamAnalyzer
implements ComponentParamAnalyzer<BottomButtonDigiwinAthena, Object> {
    private static final Logger logger = LoggerFactory.getLogger(BottomButtonParamAnalyzer.class);

    public String getComponentType() {
        return "BOTTOM_BUTTON";
    }

    public Class<BottomButtonDigiwinAthena> getSubmitParamType() {
        return BottomButtonDigiwinAthena.class;
    }

    public Object analyzeSubmitParam(Object submitParam) {
        return null;
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
        Object displayParam = pageData.get((Object)pageDataKey);
        if (displayParam instanceof List) {
            ArrayList buttonList = (ArrayList)displayParam;
            for (Map button : buttonList) {
                HashMap<String, ApiRawData> actionMap = (HashMap<String, ApiRawData>)button.get("action");
                if (actionMap != null) {
                    actionMap.put("rawData", apiRequest.getRawData());
                    if (actionMap.get("popPromptMsg") != null) {
                        List buttons;
                        Map popPromptMsg = (Map)actionMap.get("popPromptMsg");
                        if ("TASK".equals(((ApiRawData)args[0]).get((Object)"category"))) {
                            popPromptMsg.put("content", LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)((String)popPromptMsg.get("content"))) + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"reassignContentTask"));
                        } else {
                            popPromptMsg.put("content", LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)((String)popPromptMsg.get("content"))) + LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)"reassignContentProject"));
                        }
                        if (popPromptMsg.get("buttonList") != null && (buttons = (List)popPromptMsg.get("buttonList")) != null && buttons.size() > 0) {
                            for (Map buttonMap : buttons) {
                                buttonMap.put("name", LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)((String)buttonMap.get("name"))));
                            }
                        }
                    }
                    if (actionMap.get("confirmPop") != null) {
                        Map confirmPopMsg = (Map)actionMap.get("confirmPop");
                        if (confirmPopMsg.get("content") != null) {
                            confirmPopMsg.put("content", LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)((String)confirmPopMsg.get("content"))));
                        }
                        if (confirmPopMsg.get("title") != null) {
                            confirmPopMsg.put("title", LocaleUtil.getMobileTextByKey((String)apiRequest.getLocale(), (String)((String)confirmPopMsg.get("title"))));
                        }
                    }
                } else {
                    actionMap = new HashMap<String, ApiRawData>();
                    actionMap.put("rawData", apiRequest.getRawData());
                    actionMap.put("type", (ApiRawData)ActionTypeEnum.CALL_API.getValue());
                    button.put("action", actionMap);
                }
                button.put("name", LocaleUtil.getMobileTextByDatabaseKey((String)apiRequest.getLocale(), (String)((String)button.get("name"))));
            }
        }
    }
}

