/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.card.cardone;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOne;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOneBuilder;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOneField;
import com.digiwin.mobile.mobileuibot.core.component.card.cardone.CardOneTitle;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.AttachmentViewTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.analyzer.LabelFieldAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="cardOneBizApprovalBuilder")
public class CardOneBizApprovalBuilder
implements CardOneBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CardOneBizApprovalBuilder.class);
    @Autowired
    private LabelFieldAnalyzer labelFieldAnalyzer;
    private final Map<String, String> componentMap = new HashMap();
    @Autowired
    private ColumnTagService columnTagService;

    public CardOneBizApprovalBuilder() {
        this.componentMap.put(this.getMobileComponentType(), "APPROVAL_DESCRIPTION");
    }

    public CardOne build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<CardOne> clazz, Object ... args) {
        String locale = apiRequest.getLocale();
        CardOne cardOne = new CardOne();
        CardOneTitle cardOneTitle = new CardOneTitle();
        if (pcUiBotModel.getPageData() == null || pcUiBotModel.getPageData().size() == 0) {
            return cardOne;
        }
        cardOne.setTitle(cardOneTitle);
        Optional<UiBotLayout> splitLayoutOptional = pcUiBotModel.getLayout().stream().filter(layout -> "SPLIT_LAYOUT".equalsIgnoreCase(layout.getType())).findFirst();
        Optional<UiBotLayout> formListOptional = pcUiBotModel.getLayout().stream().filter(layout -> "FORM_LIST".equalsIgnoreCase(layout.getType())).findFirst();
        if (!splitLayoutOptional.isPresent() && !formListOptional.isPresent()) {
            this.handleOldData(pcUiBotModel, cardOne);
            return cardOne;
        }
        ArrayList<String> parentLayoutTypeList = new ArrayList<String>();
        parentLayoutTypeList.add("SPLIT_LAYOUT");
        parentLayoutTypeList.add("FORM_LIST");
        ArrayList<String> targetLayoutTypeList = new ArrayList<String>();
        targetLayoutTypeList.add("LABEL");
        targetLayoutTypeList.add("AMOUNT_INPUT");
        targetLayoutTypeList.add("INPUT");
        targetLayoutTypeList.add("OPERATION_EDITOR");
        targetLayoutTypeList.add("TEXTAREA");
        targetLayoutTypeList.add("FORM_UPLOAD");
        targetLayoutTypeList.add("DATEPICKER");
        UiBotModel uiBotModel = pcUiBotModel.searchPcTargetModel(targetLayoutTypeList, parentLayoutTypeList, true);
        this.addTableSum(uiBotModel, pcUiBotModel);
        List fieldLayoutList = uiBotModel.getLayout();
        if (fieldLayoutList.isEmpty()) {
            return cardOne;
        }
        List columnTagList = this.columnTagService.listColumnTagsByPath(uiBotModel.getParentSchema());
        List<ColumnTag> importantColumnTags = columnTagList.stream().filter(ct -> ColumnTagDefinitionCodeEnum.DISPLAY_IMPORTANT.getCode().equalsIgnoreCase(ct.getTagDefinition().getCode())).sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        ArrayList importantFieldList = new ArrayList();
        ArrayList unImportantFieldList = new ArrayList();
        fieldLayoutList.stream().forEach(fieldLayout -> {
            if ("FORM_UPLOAD".equals(fieldLayout.getType())) {
                Map map;
                List dataList;
                Object valueObj = uiBotModel.getPageData().get((Object)fieldLayout.getSchema());
                if (null != valueObj && !CollectionUtils.isEmpty((Collection)(dataList = (List)(map = (Map)JsonUtil.objectToJavaObject((Object)valueObj, Map.class)).get("data")))) {
                    Attachment attachment = new Attachment();
                    BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)attachment, "ATTACHMENT", fieldLayout.getSchema());
                    attachment.setTitle(fieldLayout.getHeaderName());
                    attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                    attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                    List fileList = dataList.stream().map(data -> {
                        String createDate;
                        AttachmentFile file = new AttachmentFile();
                        file.setFileId((String)data.get("id"));
                        if (data.get("size") instanceof Double) {
                            Double size = (Double)data.get("size");
                            file.setFileSize(Long.valueOf(size.longValue()));
                        } else if (data.get("size") instanceof Long) {
                            file.setFileSize((Long)data.get("size"));
                        } else if (data.get("size") instanceof String) {
                            file.setFileSize(Long.valueOf(Long.parseLong((String)data.get("size"))));
                        }
                        file.setUploader((String)data.get("upload_user_name"));
                        file.setFileName((String)data.get("name"));
                        String string = createDate = data.get("create_date") == null ? "" : String.valueOf(data.get("create_date"));
                        if (StringUtils.hasLength((String)createDate)) {
                            createDate = createDate.replaceAll("/", "-");
                        }
                        file.setUploadTime(createDate);
                        file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String)((String)data.get("name"))));
                        file.setViewable(Boolean.valueOf(true));
                        JSONObject attribute = fieldLayout.getAttribute();
                        String type = attribute.getString("type");
                        if (AttachmentViewTypeEnum.OUTER.name().equals(type)) {
                            file.setShareUrl((String)data.get("url"));
                        } else if (AttachmentViewTypeEnum.ERP.name().equals(type)) {
                            file.setViewable(Boolean.valueOf(false));
                        }
                        return file;
                    }).collect(Collectors.toList());
                    attachment.setFileList(fileList);
                    if (fieldLayout.getImportant().booleanValue()) {
                        importantFieldList.add(componentWrapper);
                    } else {
                        unImportantFieldList.add(componentWrapper);
                    }
                }
            } else {
                String value = "";
                if (!CollectionUtils.isEmpty((Collection)fieldLayout.getFields())) {
                    List fields = fieldLayout.getFields();
                    AtomicReference<String> valueAtomic = new AtomicReference<String>("");
                    fields.forEach(field -> {
                        Object valueObj;
                        if (field.getShow().booleanValue() && (valueObj = uiBotModel.getPageData().get((Object)field.getSchema())) != null) {
                            String fieldValue = String.valueOf(valueObj);
                            valueAtomic.updateAndGet(v -> v + fieldValue + "-");
                        }
                    });
                    value = valueAtomic.get();
                    if (StringUtils.hasLength((String)value)) {
                        value = value.substring(0, value.length() - 1);
                    }
                } else {
                    Object valueObj = uiBotModel.getPageData().get((Object)fieldLayout.getSchema());
                    if (valueObj != null) {
                        value = String.valueOf(valueObj);
                    }
                }
                if (StringUtils.hasLength((String)value)) {
                    String supplierNameType;
                    CardOneField field2 = CardOneField.create((String)fieldLayout.getHeaderName(), (String)fieldLayout.getType(), (String)value, (Integer)FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
                    BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)field2, "FIELD", fieldLayout.getSchema());
                    field2.setSchema(fieldLayout.getSchema());
                    if (uiBotModel.getPageData().get((Object)"__SUPPLIER_FULL_NAME") != null && "SUPPLIER_FULL_NAME".equals(fieldLayout.getSchema()) && "1".equalsIgnoreCase(supplierNameType = uiBotModel.getPageData().get((Object)"__SUPPLIER_FULL_NAME").toString())) {
                        Tag tag = Tag.createNewHintStateTag((String)LocaleUtil.getMobileTextByKey((String)locale, (String)"\u65b0"));
                        field2.addTag(tag);
                    }
                    if (fieldLayout.getImportant().booleanValue()) {
                        importantFieldList.add(componentWrapper);
                    } else {
                        unImportantFieldList.add(componentWrapper);
                    }
                }
            }
        });
        ArrayList fieldList = new ArrayList();
        fieldList.addAll(importantFieldList);
        fieldList.addAll(unImportantFieldList);
        importantColumnTags.forEach(columnTag -> fieldList.forEach(field -> {
            if (columnTag.getSchema().equals(field.getSchema())) {
                cardOne.addContent(field);
                importantFieldList.remove(field);
                unImportantFieldList.remove(field);
            }
        }));
        for (BaseMobileComponentWrapper field : importantFieldList) {
            if (cardOne.getContent().size() < 4) {
                cardOne.addContent(field);
                continue;
            }
            cardOne.addHideContent(field);
        }
        for (BaseMobileComponentWrapper field : unImportantFieldList) {
            if (cardOne.getContent().size() < 4) {
                cardOne.addContent(field);
                continue;
            }
            cardOne.addHideContent(field);
        }
        return cardOne;
    }

    private void addTableSum(UiBotModel uiBotModel, UiBotModel pcUiBotModel) {
        ArrayList parentLayoutTypeList = new ArrayList();
        ArrayList<String> targetLayoutTypeList = new ArrayList<String>();
        targetLayoutTypeList.add("ATHENA_TABLE");
        UiBotModel tableUiBotModel = pcUiBotModel.searchPcTargetModel(targetLayoutTypeList, parentLayoutTypeList, true);
        if (CollectionUtils.isEmpty((Collection)tableUiBotModel.getLayout())) {
            return;
        }
        UiBotLayout tableLayout = (UiBotLayout)tableUiBotModel.getLayout().get(0);
        Map setting = tableLayout.getSetting();
        if (CollectionUtils.isEmpty((Map)setting) || setting.get("groupSummary") == null) {
            return;
        }
        Map groupSummary = (Map)setting.get("groupSummary");
        if (groupSummary.get("options") == null) {
            return;
        }
        List options = (List)groupSummary.get("options");
        if (CollectionUtils.isEmpty((Collection)options)) {
            return;
        }
        boolean hasParentSchema = StringUtils.hasLength((String)tableUiBotModel.getParentSchema());
        List mapList = (List)tableUiBotModel.getPageData().getBizDataByPathAndSchema(tableLayout.getPath(), tableLayout.getSchema(), hasParentSchema);
        if (CollectionUtils.isEmpty((Collection)mapList)) {
            return;
        }
        for (Map option : options) {
            String schema = (String)option.get("schema");
            String mode = (String)option.get("mode");
            String title = (String)option.get("title");
            if (!"sum".equalsIgnoreCase(mode)) continue;
            UiBotLayout layout = new UiBotLayout();
            layout.setSchema(schema);
            layout.setHeaderName(title);
            uiBotModel.getLayout().add(layout);
            AtomicReference<Double> value = new AtomicReference<Double>(0.0);
            mapList.forEach(map -> {
                if (map.get(schema) instanceof Double) {
                    value.updateAndGet(v -> {
                        BigDecimal bigDecimalVal = new BigDecimal(String.valueOf(v)).add(new BigDecimal(String.valueOf(map.get(schema))));
                        return bigDecimalVal.doubleValue();
                    });
                }
            });
            uiBotModel.getPageData().put((Object)schema, (Object)value.get());
        }
    }

    private void handleOldData(UiBotModel pcUiBotModel, CardOne cardOne) {
        Optional<UiBotLayout> optLayout = pcUiBotModel.getLayout().stream().filter(layout -> layout.getType() != null && layout.getType().equalsIgnoreCase((String)this.componentMap.get(this.getMobileComponentType()))).findFirst();
        if (!optLayout.isPresent()) {
            return;
        }
        UiBotLayout layout2 = optLayout.get();
        String schema = layout2.getSchema();
        Map data = (Map)pcUiBotModel.getPageData().get((Object)schema);
        if (null == data) {
            logger.debug("pagedata.{} is null, use constructed empty data", (Object)schema);
            data = Collections.emptyMap();
        }
        Map tempData = data;
        layout2.decomposeFieldsWithApprovalDescription(null).forEach(fieldLayout -> {
            String fieldType = fieldLayout.getType();
            String fieldValue = "";
            String fieldLabel = StringUtils.hasLength((String)fieldLayout.getTitle()) ? fieldLayout.getTitle() : fieldLayout.getHeaderName();
            fieldValue = this.labelFieldAnalyzer.analyze(fieldLayout, (JSONObject)JSONObject.toJSON((Object)tempData), pcUiBotModel.getPageData(), Boolean.valueOf(true));
            BaseMobileComponentWrapper componentWrapper = new BaseMobileComponentWrapper((BaseMobileComponent)Field.create((String)fieldLabel, (String)fieldType, (String)fieldValue), "FIELD");
            if (fieldLayout.getImportant().booleanValue()) {
                cardOne.addContent(componentWrapper);
            } else {
                cardOne.addHideContent(componentWrapper);
            }
        });
    }
}

