/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.graphicdisplay;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.search.Pic;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class GraphicDisplay
extends BaseMobileComponent
implements Serializable {
    public static final String COMPONENT_TYPE = "GRAPHIC_DISPLAY";
    private static final long serialVersionUID = 6622889757470813949L;
    private List<SmartPreciseSearchField> fields;
    @JsonProperty(value="pic")
    @JSONField(name="pic")
    private List<Pic> pics;
    private String title;
    private String subTitle;
    private Action action;
    private Integer style = 1;

    public static GraphicDisplay create(ZTBDriverVehicle driverVehicle, Integer style, DigiwinDmcProxyService digiwinDmcProxyService) {
        GraphicDisplay graphicDisplay = new GraphicDisplay();
        graphicDisplay.setTitle(driverVehicle.getLicensePlateNo());
        graphicDisplay.setSubTitle("+" + driverVehicle.getLoadedItemCount());
        graphicDisplay.setStyle(style);
        ArrayList<Pic> pics = new ArrayList<Pic>(1);
        Pic pic = new Pic();
        if (StringUtils.hasLength((String)driverVehicle.getPicFileId())) {
            ShareInfo shareInfo = digiwinDmcProxyService.shareFile(driverVehicle.getPicFileId(), "srm-loading");
            pic.setPicUrl(shareInfo.getUrl());
        }
        pics.add(pic);
        graphicDisplay.setPics(pics);
        ArrayList<SmartPreciseSearchField> fields = new ArrayList<SmartPreciseSearchField>(3);
        fields.add(SmartPreciseSearchField.create((String)driverVehicle.getVehicleType(), (Integer)2));
        fields.add(SmartPreciseSearchField.create((String)driverVehicle.getVehicleLength(), (Integer)2));
        if (StringUtils.hasLength((String)driverVehicle.getDriverMobile())) {
            fields.add(SmartPreciseSearchField.create((String)driverVehicle.getDriverMobile(), (Integer)2, (Integer)58908));
        }
        graphicDisplay.setFields(fields);
        Action action = new Action();
        action.setRawData(JsonUtil.objectToJavaObject((Object)driverVehicle, Map.class));
        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_DELIVERY_LOADED_ITEM.toString());
        graphicDisplay.setAction(action);
        return graphicDisplay;
    }

    public static GraphicDisplay createNoSubTitle(ZTBDriverVehicle driverVehicle, Integer style, DigiwinDmcProxyService digiwinDmcProxyService) {
        GraphicDisplay graphicDisplay = new GraphicDisplay();
        graphicDisplay.setTitle(driverVehicle.getLicensePlateNo());
        graphicDisplay.setStyle(style);
        ArrayList<Pic> pics = new ArrayList<Pic>(1);
        Pic pic = new Pic();
        if (StringUtils.hasLength((String)driverVehicle.getPicFileId())) {
            ShareInfo shareInfo = digiwinDmcProxyService.shareFile(driverVehicle.getPicFileId(), "srm-loading");
            pic.setPicUrl(shareInfo.getUrl());
        }
        pics.add(pic);
        graphicDisplay.setPics(pics);
        ArrayList<SmartPreciseSearchField> fields = new ArrayList<SmartPreciseSearchField>(3);
        fields.add(SmartPreciseSearchField.create((String)driverVehicle.getVehicleType(), (Integer)2));
        fields.add(SmartPreciseSearchField.create((String)driverVehicle.getVehicleLength(), (Integer)2));
        if (StringUtils.hasLength((String)driverVehicle.getDriverMobile())) {
            fields.add(SmartPreciseSearchField.create((String)driverVehicle.getDriverMobile(), (Integer)2, (Integer)58908));
        }
        graphicDisplay.setFields(fields);
        Action action = new Action();
        action.setRawData(JsonUtil.objectToJavaObject((Object)driverVehicle, Map.class));
        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_DELIVERY_LOADED_ITEM.toString());
        graphicDisplay.setAction(action);
        return graphicDisplay;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public List<SmartPreciseSearchField> getFields() {
        return this.fields;
    }

    public List<Pic> getPics() {
        return this.pics;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public Action getAction() {
        return this.action;
    }

    public Integer getStyle() {
        return this.style;
    }

    public void setFields(List<SmartPreciseSearchField> fields) {
        this.fields = fields;
    }

    @JsonProperty(value="pic")
    public void setPics(List<Pic> pics) {
        this.pics = pics;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setStyle(Integer style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphicDisplay)) {
            return false;
        }
        GraphicDisplay other = (GraphicDisplay)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$style = this.getStyle();
        Integer other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)this$style).equals(other$style)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List this$pics = this.getPics();
        List other$pics = other.getPics();
        if (this$pics == null ? other$pics != null : !((Object)this$pics).equals(other$pics)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subTitle = this.getSubTitle();
        String other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GraphicDisplay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List $pics = this.getPics();
        result = result * 59 + ($pics == null ? 43 : ((Object)$pics).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    public String toString() {
        return "GraphicDisplay(fields=" + this.getFields() + ", pics=" + this.getPics() + ", title=" + this.getTitle() + ", subTitle=" + this.getSubTitle() + ", action=" + this.getAction() + ", style=" + this.getStyle() + ")";
    }

    public GraphicDisplay() {
    }

    public GraphicDisplay(List<SmartPreciseSearchField> fields, List<Pic> pics, String title, String subTitle, Action action, Integer style) {
        this.fields = fields;
        this.pics = pics;
        this.title = title;
        this.subTitle = subTitle;
        this.action = action;
        this.style = style;
    }
}

