/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.index;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.UserIntegrity;
import com.digiwin.mobile.mobileuibot.proxy.mdc.model.EocSetInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class NonSuperAdminTips
extends BaseMobileComponent {
    private static final long serialVersionUID = -2654397009082649892L;
    public static final String COMPONENT_TYPE = "NONSUPERADMIN_TIPS";
    private String title;
    private List<String> subTitle;
    private Map<String, List<String>> tips;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void initSetting(LocaleService localeService, String locale, ApiRawData rawData) {
        if (StringUtils.hasLength((String)this.title)) {
            this.title = localeService.getLanguageValue(locale, this.title);
        }
        if (!CollectionUtils.isEmpty((Map)this.tips)) {
            Boolean superAdmin = rawData.getBoolean("superAdmin");
            EocSetInfo eocSetInfo = (EocSetInfo)rawData.getObject("eocSetInfo", EocSetInfo.class);
            UserIntegrity userIntegrity = (UserIntegrity)rawData.getObject("userIntegrity", UserIntegrity.class);
            this.subTitle = superAdmin != false ? (List)this.tips.get("tip4") : (eocSetInfo.getRemindUnitSetting() != false && userIntegrity.getUserIntegrity() == false ? (List)this.tips.get("tip1") : (eocSetInfo.getRemindUnitSetting() != false && userIntegrity.getUserIntegrity() != false ? (List)this.tips.get("tip2") : (eocSetInfo.getRemindUnitSetting() == false && userIntegrity.getUserIntegrity() == false ? (List)this.tips.get("tip3") : (List)this.tips.get("tip1"))));
        }
        if (!CollectionUtils.isEmpty((Collection)this.subTitle)) {
            this.subTitle = this.subTitle.stream().map(s -> localeService.getLanguageValue(locale, s)).collect(Collectors.toList());
        }
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getSubTitle() {
        return this.subTitle;
    }

    public Map<String, List<String>> getTips() {
        return this.tips;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubTitle(List<String> subTitle) {
        this.subTitle = subTitle;
    }

    public void setTips(Map<String, List<String>> tips) {
        this.tips = tips;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NonSuperAdminTips)) {
            return false;
        }
        NonSuperAdminTips other = (NonSuperAdminTips)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List this$subTitle = this.getSubTitle();
        List other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !((Object)this$subTitle).equals(other$subTitle)) {
            return false;
        }
        Map this$tips = this.getTips();
        Map other$tips = other.getTips();
        return !(this$tips == null ? other$tips != null : !((Object)this$tips).equals(other$tips));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NonSuperAdminTips;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : ((Object)$subTitle).hashCode());
        Map $tips = this.getTips();
        result = result * 59 + ($tips == null ? 43 : ((Object)$tips).hashCode());
        return result;
    }

    public String toString() {
        return "NonSuperAdminTips(title=" + this.getTitle() + ", subTitle=" + this.getSubTitle() + ", tips=" + this.getTips() + ")";
    }
}

