/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.attachment;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.ComponentChoiceTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.FileMaxSize;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgressWorkItemAttachment;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachmentData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableAttachmentColumnAttribute;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailFixedNameEnum;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Attachment<T extends AttachmentRawData>
extends BaseInputMobileComponent
implements Serializable {
    private static final long serialVersionUID = -7260016907362158686L;
    public static final String COMPONENT_TYPE = "ATTACHMENT";
    protected List<AttachmentFile> fileList = new ArrayList();
    protected FileMaxSize fileMaxSize;
    protected Long maxSize;
    protected T rawData;
    protected String title;
    protected Integer titleStyleType;
    protected Integer type = 2;
    protected Integer styleType = AttachmentStyleTypeEnum.TITLE_NORMAL.getValue();
    protected Integer limit = 99;
    protected String fileChoice = ComponentChoiceTypeEnum.MULTIPLE_CHOICE.getValue();
    protected Boolean isArray;
    Boolean isFold = false;
    Integer foldNumber = 3;
    Boolean defaultExpand = false;
    protected List<Integer> uploadTypes = new /* Unavailable Anonymous Inner Class!! */;
    protected DataSource dataSource;

    public List<Integer> getUploadTypes() {
        if (CollectionUtils.isEmpty((Collection)this.uploadTypes)) {
            this.uploadTypes = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this.uploadTypes;
    }

    public static <T extends Attachment> T create(Class<T> clazz, String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList, Map<String, Object> bizData, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, List<Rule> mobileValidateRuleList, Boolean disableAam) {
        Object data = bizData.get(column.getSchema());
        UiBotAttachment uiBotAttachment = (UiBotAttachment)JsonUtil.objectToJavaObject((Object)data, UiBotAttachment.class);
        Attachment attachment = null;
        try {
            attachment = Attachment.setAttachmentRawData(attachment, clazz, (UiBotAttachment)uiBotAttachment, (String)locale, (UiBotTableColumn)column, columnRuleList, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (Boolean)disableAam, null);
            Optional<UiBotRule> optColumnRequiredRule = columnRuleList.stream().filter(uiBotRule -> null != uiBotRule.getSchema() && "required".equalsIgnoreCase(uiBotRule.getKey()) && "EDIT".equalsIgnoreCase(uiBotRule.getScope())).findFirst();
            if (attachment != null) {
                attachment.setRequired(Boolean.valueOf(optColumnRequiredRule.isPresent()));
                attachment.setTitle(column.getHeaderName());
                attachment.setType(column.canUpload() ? AttachmentTypeEnum.READ_AND_WRITE.getValue() : AttachmentTypeEnum.READ_ONLY.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)attachment;
    }

    public static <T extends Attachment> T create(Class<T> clazz, String locale, UiBotTableColumn column, Map<String, Object> bizData) {
        Object data = bizData.get(column.getSchema());
        UiBotAttachment uiBotAttachment = (UiBotAttachment)JsonUtil.objectToJavaObject((Object)data, UiBotAttachment.class);
        Attachment attachment = null;
        try {
            UiBotTableAttachmentColumnAttribute columnAttribute = column.getAttribute();
            attachment = (Attachment)clazz.newInstance();
            for (UiBotAttachmentData uibotAttachData : uiBotAttachment.getData()) {
                attachment.getFileList().add(AttachmentFile.create((String)locale, (UiBotAttachmentData)uibotAttachData));
            }
            attachment.setRequired(Boolean.valueOf(true));
            attachment.setTitle(column.getHeaderName());
            attachment.setType(column.canUpload() ? AttachmentTypeEnum.READ_AND_WRITE.getValue() : AttachmentTypeEnum.READ_ONLY.getValue());
            AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
            attachmentRawDataDigiwinAthena.setDisableAam(Optional.ofNullable(column).map(UiBotTableColumn::getAttribute).map(UiBotTableAttachmentColumnAttribute::getDisableAam).orElse(true));
            attachmentRawDataDigiwinAthena.setUploadCategory(Optional.ofNullable(column).map(UiBotTableColumn::getAttribute).map(UiBotTableAttachmentColumnAttribute::getUploadCategory).orElse(""));
            attachmentRawDataDigiwinAthena.setUploadCategoryId("");
            attachmentRawDataDigiwinAthena.setPath("");
            attachmentRawDataDigiwinAthena.setRowDataKey("");
            attachmentRawDataDigiwinAthena.setBuckets(Optional.ofNullable(column).map(UiBotTableColumn::getAttribute).map(UiBotTableAttachmentColumnAttribute::getBuckets).orElse("Athena"));
            attachment.setRawData((AttachmentRawData)attachmentRawDataDigiwinAthena);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)attachment;
    }

    public static Attachment<AttachmentRawDataDigiwinAthena> create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule) {
        Attachment attachment = new Attachment();
        attachment.setSchema(uiBotFieldLayout.getSchema());
        attachment.setTitle(uiBotFieldLayout.getHeaderName());
        attachment.setType(AttachmentTypeEnum.READ_AND_WRITE.getValue());
        attachment.setRequired(Boolean.valueOf(false));
        if (uiBotRule != null) {
            attachment.setRequired(Boolean.valueOf("required".equalsIgnoreCase(uiBotRule.getKey())));
        }
        AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        if (uiBotFieldLayout.getAttribute() != null) {
            attachment.setFileMaxSize(new FileMaxSize(uiBotFieldLayout.getAttribute().getLong("fileMaxSfize")));
            attachmentRawDataDigiwinAthena.setDisableAam(uiBotFieldLayout.getAttribute().getBoolean("disableAam"));
            attachmentRawDataDigiwinAthena.setUploadCategory(uiBotFieldLayout.getAttribute().getString("uploadCategory"));
        }
        attachmentRawDataDigiwinAthena.setUploadCategoryId("");
        attachmentRawDataDigiwinAthena.setPath("");
        attachmentRawDataDigiwinAthena.setRowDataKey("");
        attachment.setRawData((AttachmentRawData)attachmentRawDataDigiwinAthena);
        return attachment;
    }

    public static Attachment<AttachmentRawDataDigiwinAthena> create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule, String bucket) {
        Attachment attachment = new Attachment();
        attachment.setSchema(uiBotFieldLayout.getSchema());
        attachment.setTitle(uiBotFieldLayout.getHeaderName());
        attachment.setType(AttachmentTypeEnum.READ_AND_WRITE.getValue());
        attachment.setFileMaxSize(new FileMaxSize(uiBotFieldLayout.getAttribute().getLong("fileMaxSize")));
        attachment.setRequired(Boolean.valueOf(false));
        if (uiBotRule != null) {
            attachment.setRequired(Boolean.valueOf("required".equalsIgnoreCase(uiBotRule.getKey())));
        }
        AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        attachmentRawDataDigiwinAthena.setDisableAam(uiBotFieldLayout.getAttribute().getBoolean("disableAam"));
        attachmentRawDataDigiwinAthena.setUploadCategory(uiBotFieldLayout.getAttribute().getString("uploadCategory"));
        attachmentRawDataDigiwinAthena.setUploadCategoryId("");
        attachmentRawDataDigiwinAthena.setPath("");
        attachmentRawDataDigiwinAthena.setRowDataKey("");
        attachmentRawDataDigiwinAthena.setBuckets(bucket);
        attachment.setRawData((AttachmentRawData)attachmentRawDataDigiwinAthena);
        return attachment;
    }

    public static Attachment createWithOneFile(AttachmentFile attachmentFile) {
        Attachment attachment = new Attachment();
        if (null != attachmentFile) {
            attachment.getFileList().add(attachmentFile);
        }
        return attachment;
    }

    public static Attachment create(UiBotLayout uiBotLayout, Map<String, Object> data, String locale, DigiwinDmcProxyService digiwinDmcProxyService, Boolean isComplete) {
        Attachment attachment = new Attachment();
        attachment.setTitle((String)uiBotLayout.getmLabelText().get(locale));
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_NORMAL.getValue());
        Map pcAttachment = (Map)data.get(uiBotLayout.getSchema());
        if (pcAttachment != null && pcAttachment.get("data") != null) {
            List attachmentDataList = (List)pcAttachment.get("data");
            if (attachmentDataList != null && attachmentDataList.size() > 0) {
                List attachmentFiles = attachment.getFileList();
                for (Map attachmentData : attachmentDataList) {
                    attachment.setRequired(Boolean.valueOf(false));
                    AttachmentFile attachmentFile = new AttachmentFile();
                    String fileName = (String)attachmentData.get("name");
                    String id = (String)attachmentData.get("id");
                    attachmentFile.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String)fileName));
                    attachmentFile.setUploader((String)attachmentData.get("upload_user_name"));
                    attachmentFile.setFileSize(Long.valueOf(((Integer)attachmentData.get("size")).intValue()));
                    attachmentFile.setFileName(fileName);
                    attachmentFile.setFileId(id);
                    attachmentFile.setUploadTime((String)attachmentData.get("create_date"));
                    attachmentFiles.add(attachmentFile);
                }
                attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                attachment.setHidden(Boolean.valueOf(false));
                attachment.setEnable(Boolean.valueOf(isComplete == false));
            } else {
                if (digiwinDmcProxyService != null && "attachment".equals(uiBotLayout.getSchema())) {
                    return null;
                }
                if (isComplete.booleanValue() && "actualAttachment".equals(uiBotLayout.getSchema())) {
                    return null;
                }
                attachment.setHidden(Boolean.valueOf(true));
                attachment.setEnable(Boolean.valueOf(isComplete == false));
                attachment.setRequired(Boolean.valueOf(false));
                if (isComplete.booleanValue()) {
                    attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                } else {
                    attachment.setType(AttachmentTypeEnum.READ_AND_WRITE.getValue());
                }
            }
        } else {
            attachment.setEnable(Boolean.valueOf(isComplete == false));
            attachment.setEnable(Boolean.valueOf(false));
            attachment.setRequired(Boolean.valueOf(false));
            if (isComplete.booleanValue()) {
                attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
            } else {
                attachment.setType(AttachmentTypeEnum.READ_AND_WRITE.getValue());
            }
        }
        if ("actualAttachment".equals(uiBotLayout.getSchema())) {
            attachment.setHidden(Boolean.valueOf(false));
            attachment.setEnable(Boolean.valueOf(isComplete == false));
        }
        attachment.setFileMaxSize(new FileMaxSize(Long.valueOf(0x6400000L)));
        attachment.setPlaceholder("\u5927\u5c0f\u9650\u5236100MB");
        attachment.setErrorMessage("\u4e0a\u4f20\u5931\u8d25");
        return attachment;
    }

    public static Attachment createAbnormalReasonAttachment(Map<String, Object> attachments, String title) {
        List fileInfoList = (List)attachments.get("data");
        ArrayList<AttachmentFile> fileList = new ArrayList<AttachmentFile>();
        for (Map fileInfo : fileInfoList) {
            String fileExtension = null != AttachmentUtil.getAttachmentFileSuffix((String)((String)fileInfo.get("name"))) ? AttachmentUtil.getAttachmentFileSuffix((String)((String)fileInfo.get("name"))) : "pdf";
            String fileId = null != fileInfo.get("id") ? String.valueOf(fileInfo.get("id")) : "";
            String fileName = null != fileInfo.get("name") ? String.valueOf(fileInfo.get("name")) : "";
            String shareUrl = null != fileInfo.get("file_download_url") ? String.valueOf(fileInfo.get("file_download_url")) : "";
            String uploadTime = null != fileInfo.get("create_date") ? String.valueOf(fileInfo.get("create_date")) : "";
            String uploader = null != fileInfo.get("upload_user_name") ? String.valueOf(fileInfo.get("upload_user_name")) : "";
            String fileSize = null != fileInfo.get("size") ? String.valueOf(fileInfo.get("size")) : "0";
            AttachmentFile attachmentFile = AttachmentFile.create((String)fileExtension, (String)fileId, (String)fileName, (Long)Double.valueOf(fileSize).longValue(), (String)shareUrl, (String)uploadTime, (String)uploader);
            fileList.add(attachmentFile);
        }
        Attachment attachment = new Attachment();
        attachment.setFileList(fileList);
        attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        attachment.setTitle(title);
        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        return attachment;
    }

    public static Attachment create(String title, Integer styleType, Integer titleStyleType, Integer type, Boolean abnormalReturns) {
        Attachment attachment = new Attachment();
        attachment.setFileList(Collections.emptyList());
        attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
        attachment.setStyleType(styleType);
        attachment.setTitle(title);
        attachment.setTitleStyleType(titleStyleType);
        attachment.setType(type);
        attachment.setFileMaxSize(new FileMaxSize(Long.valueOf(0x1400000L)));
        attachment.setLimit(Integer.valueOf(10));
        attachment.setHidden(Boolean.valueOf(!ObjectUtils.isNotEmpty((Object)abnormalReturns) || !BooleanUtils.isTrue((Boolean)abnormalReturns)));
        return attachment;
    }

    public static Attachment uibotAttachmentparseAttachment(UiBotAttachment uiBotAttachment, String locale, String title) {
        Attachment attachment = new Attachment();
        attachment.setTitle(title);
        for (UiBotAttachmentData uibotAttachData : uiBotAttachment.getData()) {
            attachment.getFileList().add(AttachmentFile.create((String)locale, (UiBotAttachmentData)uibotAttachData));
        }
        attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        return attachment;
    }

    public static Attachment uibotAttachmentparseAttachment(List<DigiwinAtmcTaskProgressWorkItemAttachment> digiwinAtmcTaskProgressWorkItemAttachmentList, String locale, String title) {
        Attachment attachment = new Attachment();
        attachment.setTitle(title);
        for (DigiwinAtmcTaskProgressWorkItemAttachment digiwinAtmcTaskProgressWorkItemAttachment : digiwinAtmcTaskProgressWorkItemAttachmentList) {
            attachment.getFileList().add(AttachmentFile.create((String)locale, (DigiwinAtmcTaskProgressWorkItemAttachment)digiwinAtmcTaskProgressWorkItemAttachment));
        }
        attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        return attachment;
    }

    public static Attachment createTbdsFiles(List<Map<String, Object>> files, String title) {
        ArrayList<AttachmentFile> fileList = new ArrayList<AttachmentFile>();
        for (Map<String, Object> fileInfo : files) {
            String fileExtension = "0".equals(fileInfo.get("resource_type")) ? "jpg" : "mp4";
            String fileId = null != fileInfo.get("source_id") ? String.valueOf(fileInfo.get("source_id")) : "";
            String fileName = null != fileInfo.get("source_id") ? String.valueOf(fileInfo.get("source_id")) : "";
            String uploadTime = null != fileInfo.get("create_time") ? String.valueOf(fileInfo.get("create_time")) : "";
            String uploader = null != fileInfo.get("create_name") ? String.valueOf(fileInfo.get("create_name")) : "";
            String fileSize = null != fileInfo.get("file_size") ? String.valueOf(fileInfo.get("file_size")) : "0";
            String videoCoverId = null != fileInfo.get("video_cover_id") ? String.valueOf(fileInfo.get("video_cover_id")) : "";
            String shareUrl = AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/tbds/preview/" + fileId;
            AttachmentFile attachmentFile = AttachmentFile.create((String)fileExtension, (String)fileId, (String)fileName, (Long)Long.valueOf(fileSize), (String)shareUrl, (String)uploadTime, (String)uploader);
            if (StringUtils.isNotEmpty((CharSequence)videoCoverId)) {
                String videoCoverUrl = AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/tbds/preview/" + videoCoverId;
                attachmentFile.setPreviewUrl(videoCoverUrl);
                attachmentFile.setCoverId(videoCoverId);
            }
            fileList.add(attachmentFile);
        }
        Attachment attachment = new Attachment();
        attachment.setFileList(fileList);
        attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_NORMAL.getValue());
        attachment.setTitle(title);
        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        return attachment;
    }

    public static Attachment createTbdsFiles(List<Map<String, Object>> files, Integer type, String title, Integer styleType, String bucketName, Integer titleStyleType) {
        ArrayList<AttachmentFile> fileList = new ArrayList<AttachmentFile>();
        for (Map<String, Object> fileInfo : files) {
            Long fileSize;
            String uploader;
            String fileId = null != fileInfo.get("id") ? String.valueOf(fileInfo.get("id")) : "";
            String fileName = null != fileInfo.get("name") ? String.valueOf(fileInfo.get("name")) : "";
            String fileExtension = FileUtil.getFileExtension((String)fileName);
            String uploadTime = null != fileInfo.get("create_date") ? String.valueOf(fileInfo.get("create_date")) : "";
            String string = uploader = null != fileInfo.get("upload_user_name") ? String.valueOf(fileInfo.get("upload_user_name")) : "";
            if (fileInfo.get("size") instanceof Double) {
                Double fileSizeDouble = null != fileInfo.get("size") ? (Double)fileInfo.get("size") : 0.0;
                fileSize = fileSizeDouble.longValue();
            } else {
                String fileSizeString = null != fileInfo.get("file_size") ? String.valueOf(fileInfo.get("file_size")) : "0";
                fileSize = Long.valueOf(fileSizeString);
            }
            String shareUrl = AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/" + bucketName + "/preview/" + fileId;
            AttachmentFile attachmentFile = AttachmentFile.create((String)fileExtension, (String)fileId, (String)fileName, (Long)fileSize, (String)shareUrl, (String)uploadTime, (String)uploader);
            fileList.add(attachmentFile);
        }
        Attachment attachment = new Attachment();
        attachment.setFileList(fileList);
        attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
        attachment.setStyleType(styleType);
        attachment.setTitle(title);
        attachment.setTitleStyleType(titleStyleType);
        attachment.setType(type);
        return attachment;
    }

    public String returnComponentType() {
        return "ATTACHMENT";
    }

    public static <T extends Attachment> T setAttachmentRawData(T oldAttachment, Class<T> clazz, UiBotAttachment uiBotAttachment, String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, Boolean disableAam, String path) {
        UiBotTableAttachmentColumnAttribute columnAttribute = column.getAttribute();
        try {
            oldAttachment = (Attachment)clazz.newInstance();
            for (UiBotAttachmentData uibotAttachData : uiBotAttachment.getData()) {
                oldAttachment.getFileList().add(AttachmentFile.create((String)locale, (UiBotAttachmentData)uibotAttachData));
            }
            if (columnAttribute != null) {
                oldAttachment.setFileMaxSize(new FileMaxSize(columnAttribute.getFileMaxSize()));
            }
            if (path == null && !columnRuleList.isEmpty()) {
                path = columnRuleList.get(0).getPath();
            }
            AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
            rawDataDigiwinAthena.setPath(path);
            rawDataDigiwinAthena.setRowDataKey(uiBotAttachment.getRowDataKey());
            rawDataDigiwinAthena.setRowData(uiBotAttachment.getRowData());
            rawDataDigiwinAthena.setTmActivityId(digiwinAtmcBacklogDetail.getTmActivityId());
            rawDataDigiwinAthena.setTmTaskId(digiwinAtmcBacklogDetail.getTmTaskId());
            rawDataDigiwinAthena.setBuckets(column.getBuckets());
            if (columnAttribute != null) {
                rawDataDigiwinAthena.setUploadCategory(columnAttribute.getUploadCategory());
            } else if (column.getOcrType() == 0) {
                rawDataDigiwinAthena.setUploadCategory("employeeInduction_identityCard");
            } else if (column.getOcrType() == 1) {
                rawDataDigiwinAthena.setUploadCategory("employeeInduction_wagesCard");
            }
            rawDataDigiwinAthena.setDisableAam(disableAam);
            oldAttachment.setRawData((AttachmentRawData)rawDataDigiwinAthena);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return oldAttachment;
    }

    public UiBotAttachment parseToUiBotAttachment(Attachment attachment, DigiwinDmcProxyService digiwinDmcProxyService) {
        AttachmentRawDataDigiwinAthena attachmentRawData = (AttachmentRawDataDigiwinAthena)attachment.getRawData();
        UiBotAttachment uiBotAttachment = new UiBotAttachment();
        String uploadCategoryId = ObjectUtils.isEmpty((Object)attachmentRawData) ? "" : Optional.ofNullable(attachmentRawData.getUploadCategoryId()).orElse(digiwinDmcProxyService.getDirIdByName(attachmentRawData.getUploadCategory()));
        attachment.getFileList().removeIf(e -> "DELETE".equals(((AttachmentFile)e).getStatus()));
        attachment.getFileList().forEach(obj -> {
            AttachmentFile attachmentFile = (AttachmentFile)obj;
            UiBotAttachmentData uiBotAttachmentData = new UiBotAttachmentData();
            uiBotAttachmentData.setId(attachmentFile.getFileId());
            uiBotAttachmentData.setName(attachmentFile.getFileName());
            uiBotAttachmentData.setUploadUserName(attachmentFile.getUploader());
            uiBotAttachmentData.setCreateDate(attachmentFile.getUploadTime());
            uiBotAttachmentData.setSize(Double.valueOf(Optional.ofNullable(attachmentFile.getFileSize()).orElse(new Long(0L)).doubleValue()));
            uiBotAttachmentData.setUibotStatus(attachmentFile.getStatus());
            uiBotAttachmentData.setCategory(attachmentRawData.getUploadCategory());
            uiBotAttachmentData.setCategoryId(Optional.ofNullable(uploadCategoryId).orElse(""));
            uiBotAttachmentData.setRowDataKey(attachmentRawData.getRowDataKey());
            uiBotAttachmentData.setRowData(attachmentRawData.getRowData());
            uiBotAttachmentData.setShareUrl(attachmentFile.getShareUrl());
            uiBotAttachmentData.setBase64Data(attachmentFile.getBase64Data());
            uiBotAttachmentData.setCoverBase64Data(attachmentFile.getCoverBase64Data());
            uiBotAttachmentData.setFileExtension(attachmentFile.getFileExtension());
            uiBotAttachmentData.setBase64DataId(attachmentFile.getBase64DataId());
            uiBotAttachmentData.setApprovalCreateDate(attachmentFile.getUploadTime());
            uiBotAttachment.addData(uiBotAttachmentData);
        });
        uiBotAttachment.setRowDataKey(attachmentRawData.getRowDataKey());
        uiBotAttachment.setRowData(attachmentRawData.getRowData());
        return uiBotAttachment;
    }

    public UiBotAttachment parseToUiBotAttachmentNotFilterDelete(Attachment attachment, DigiwinDmcProxyService digiwinDmcProxyService) {
        AttachmentRawDataDigiwinAthena attachmentRawData = (AttachmentRawDataDigiwinAthena)attachment.getRawData();
        UiBotAttachment uiBotAttachment = new UiBotAttachment();
        String uploadCategoryId = ObjectUtils.isEmpty((Object)attachmentRawData) ? "" : Optional.ofNullable(attachmentRawData.getUploadCategoryId()).orElse(digiwinDmcProxyService.getDirIdByName(attachmentRawData.getUploadCategory()));
        attachment.getFileList().forEach(obj -> {
            AttachmentFile attachmentFile = (AttachmentFile)obj;
            UiBotAttachmentData uiBotAttachmentData = new UiBotAttachmentData();
            uiBotAttachmentData.setId(attachmentFile.getFileId());
            uiBotAttachmentData.setName(attachmentFile.getFileName());
            uiBotAttachmentData.setUploadUserName(attachmentFile.getUploader());
            uiBotAttachmentData.setCreateDate(attachmentFile.getUploadTime());
            uiBotAttachmentData.setSize(Double.valueOf(Optional.ofNullable(attachmentFile.getFileSize()).orElse(new Long(0L)).doubleValue()));
            uiBotAttachmentData.setUibotStatus(attachmentFile.getStatus());
            uiBotAttachmentData.setCategory(attachmentRawData.getUploadCategory());
            uiBotAttachmentData.setCategoryId(Optional.ofNullable(uploadCategoryId).orElse(""));
            uiBotAttachmentData.setRowDataKey(attachmentRawData.getRowDataKey());
            uiBotAttachmentData.setRowData(attachmentRawData.getRowData());
            uiBotAttachmentData.setShareUrl(attachmentFile.getShareUrl());
            uiBotAttachmentData.setApprovalCreateDate(attachmentFile.getUploadTime());
            uiBotAttachmentData.setBase64Data(attachmentFile.getBase64Data());
            uiBotAttachmentData.setFileExtension(attachmentFile.getFileExtension());
            uiBotAttachmentData.setBase64DataId(attachmentFile.getBase64DataId());
            uiBotAttachmentData.setCoverBase64Data(attachmentFile.getCoverBase64Data());
            if ("DELETE".equals(attachmentFile.getStatus())) {
                uiBotAttachmentData.setUibotStatus("DELETE");
            }
            uiBotAttachment.addData(uiBotAttachmentData);
        });
        uiBotAttachment.setRowDataKey(attachmentRawData.getRowDataKey());
        uiBotAttachment.setRowData(attachmentRawData.getRowData());
        return uiBotAttachment;
    }

    public static Attachment createSolution(String locale, String iamUserToken, Map<String, Object> detailInfo) {
        Map knowledgeCustomize = (Map)detailInfo.get("knowledge_customize");
        String solutionName = String.valueOf(knowledgeCustomize.get("solution_name"));
        List questionAcceptanceInfoList = (List)knowledgeCustomize.get("question_acceptance_info");
        ArrayList<AttachmentFile> fileList = new ArrayList<AttachmentFile>();
        for (Map questionAcceptanceInfo : questionAcceptanceInfoList) {
            String fileExtension = null != questionAcceptanceInfo.get("file_extension") ? String.valueOf(questionAcceptanceInfo.get("file_extension")) : "pdf";
            String fileId = null != questionAcceptanceInfo.get("print_report_id") ? String.valueOf(questionAcceptanceInfo.get("print_report_id")) : "";
            String fileName = null != questionAcceptanceInfo.get("file_name") ? String.valueOf(questionAcceptanceInfo.get("file_name")) : solutionName;
            String shareUrl = null != questionAcceptanceInfo.get("print_report_preview_url") ? String.valueOf(questionAcceptanceInfo.get("print_report_preview_url")) : "";
            String uploadTime = null != questionAcceptanceInfo.get("create_time") ? String.valueOf(questionAcceptanceInfo.get("create_time")) : "";
            String uploader = null != questionAcceptanceInfo.get("create_name") ? String.valueOf(questionAcceptanceInfo.get("create_name")) : "";
            String fileSize = null != questionAcceptanceInfo.get("file_size") ? String.valueOf(questionAcceptanceInfo.get("file_size")) : "0";
            AttachmentFile attachmentFile = AttachmentFile.create((String)fileExtension, (String)fileId, (String)fileName, (Long)Long.valueOf(fileSize), (String)shareUrl, (String)uploadTime, (String)uploader);
            fileList.add(attachmentFile);
        }
        Attachment attachment = new Attachment();
        attachment.setFileList(fileList);
        attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_NORMAL.getValue());
        attachment.setTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)SearchItemDetailFixedNameEnum.QUESTION_SOLUTION.getValue()));
        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        return attachment;
    }

    public static Attachment createActualAttachment(String locale, String iamUserToken, Map<String, Object> detailInfo) {
        List fileInfoList = (List)detailInfo.get("file_info");
        ArrayList<AttachmentFile> fileList = new ArrayList<AttachmentFile>();
        for (Map fileInfo : fileInfoList) {
            String fileExtension = null != fileInfo.get("file_extension") ? String.valueOf(fileInfo.get("file_extension")) : "pdf";
            String fileId = null != fileInfo.get("id") ? String.valueOf(fileInfo.get("id")) : "";
            String fileName = null != fileInfo.get("file_name") ? String.valueOf(fileInfo.get("file_name")) : "";
            String shareUrl = null != fileInfo.get("file_download_url") ? String.valueOf(fileInfo.get("file_download_url")) : "";
            String uploadTime = null != fileInfo.get("create_time") ? String.valueOf(fileInfo.get("create_time")) : "";
            String uploader = null != fileInfo.get("create_name") ? String.valueOf(fileInfo.get("create_name")) : "";
            String fileSize = null != fileInfo.get("file_size") ? String.valueOf(fileInfo.get("file_size")) : "0";
            AttachmentFile attachmentFile = AttachmentFile.create((String)fileExtension, (String)fileId, (String)fileName, (Long)Long.valueOf(fileSize), (String)shareUrl, (String)uploadTime, (String)uploader);
            fileList.add(attachmentFile);
        }
        Attachment attachment = new Attachment();
        attachment.setFileList(fileList);
        attachment.setRawData((AttachmentRawData)new AttachmentRawDataDigiwinAthena());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_NORMAL.getValue());
        attachment.setTitle(LocaleUtil.getMobileTextByKey((String)locale, (String)SearchItemDetailFixedNameEnum.SEARCH_ITEM_DETAIL_ATTACHMENT.getValue()));
        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        return attachment;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.resetCmptMultipleDataSourceData(cmptContext, executeContext, this.dataSource, data);
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.customizePcmBudgetProjectApprovals(mobilePath, schema, data, executeContext, mobilePageRawData);
        if (this.fileMaxSize != null) {
            this.fileMaxSize.MB2B();
        }
        UiBotAttachment uiBotAttachment = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(r -> {
            if (r instanceof Map) {
                this.isArray = false;
                return (UiBotAttachment)JsonUtil.objectToJavaObject((Object)r, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            if (r instanceof UiBotAttachment) {
                this.isArray = false;
                return (UiBotAttachment)r;
            }
            if (r instanceof List) {
                this.isArray = true;
                if (!CollectionUtils.isEmpty((Collection)((List)r))) {
                    return (UiBotAttachment)((List)JsonUtil.objectToJavaObject((Object)r, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).get(0);
                }
            }
            return null;
        }).orElse(new UiBotAttachment());
        for (UiBotAttachmentData uibotAttachData : uiBotAttachment.getData()) {
            this.fileList.add(AttachmentFile.create((String)executeContext.getLocale(), (UiBotAttachmentData)uibotAttachData));
        }
        AttachmentRawDataDigiwinAthena rawData = Optional.ofNullable((AttachmentRawDataDigiwinAthena)this.getRawData()).orElse(new AttachmentRawDataDigiwinAthena());
        AttachmentRawDataDigiwinAthena newRawData = new AttachmentRawDataDigiwinAthena();
        newRawData.setPath("");
        newRawData.setRowDataKey(uiBotAttachment.getRowDataKey());
        newRawData.setRowData(uiBotAttachment.getRowData());
        newRawData.setTmActivityId(executeContext.getTmActivityId());
        newRawData.setTmTaskId(executeContext.getTmProjectId());
        newRawData.setBuckets(rawData.getBuckets());
        newRawData.setUploadCategory(Optional.ofNullable(rawData.getUploadCategory()).orElse(""));
        newRawData.setDisableAam(Optional.ofNullable(rawData.getDisableAam()).orElse(true));
        this.rawData = newRawData;
        this.specialHandle(executeContext, mobilePath, schema, data);
    }

    private void specialHandle(PcUiBotExecuteContext executeContext, String mobilePath, String schema, Map<String, Object> data) {
        if ("UT_InspectionResultsRegistration".equalsIgnoreCase(executeContext.getTmActivityId()) && "video_attachment".equals(schema)) {
            this.setSupportImageAndVideoType();
        }
        if ("questionIdentify".equalsIgnoreCase(executeContext.getTmActivityId())) {
            Object attachmentInfo;
            if ("problem_review_attachment".equals(schema)) {
                this.isArray = true;
            }
            if (ObjectUtils.isNotEmpty((Object)(attachmentInfo = UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema))) && attachmentInfo instanceof List && !CollectionUtils.isEmpty((Collection)((List)attachmentInfo))) {
                List attachmentFileList;
                List attachmentInfoList = (List)attachmentInfo;
                if ("attachment_info".equals(schema)) {
                    attachmentFileList = attachmentInfoList.stream().filter(e -> !CollectionUtils.isEmpty((Map)e)).map(e -> {
                        AttachmentFile attachmentFile = new AttachmentFile();
                        attachmentFile.setFileId(MapUtils.getString((Map)e, (Object)"attachment_id"));
                        attachmentFile.setFileName(MapUtils.getString((Map)e, (Object)"attachment_name"));
                        attachmentFile.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String)MapUtils.getString((Map)e, (Object)"attachment_name")));
                        attachmentFile.setUploader(MapUtils.getString((Map)e, (Object)"upload_person_name"));
                        return attachmentFile;
                    }).collect(Collectors.toList());
                    AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = (AttachmentRawDataDigiwinAthena)JsonUtil.objectToJavaObject((Object)this.rawData, AttachmentRawDataDigiwinAthena.class);
                    List problemFeedbackFileIdList = attachmentFileList.stream().map(e -> e.getFileId()).collect(Collectors.toList());
                    HashMap problemFeedbackFileIdMap = new HashMap(1);
                    problemFeedbackFileIdMap.put("problemFeedbackFileIdList", problemFeedbackFileIdList);
                    attachmentRawDataDigiwinAthena.setExtendParam(problemFeedbackFileIdMap);
                    this.setRawData((AttachmentRawData)attachmentRawDataDigiwinAthena);
                    this.fileList = attachmentFileList;
                }
                if ("question_picture".equals(schema)) {
                    this.fileList = attachmentFileList = attachmentInfoList.stream().filter(e -> !CollectionUtils.isEmpty((Map)e)).map(e -> {
                        AttachmentFile attachmentFile = new AttachmentFile();
                        attachmentFile.setFileId(MapUtils.getString((Map)e, (Object)"picture_id"));
                        attachmentFile.setFileName(MapUtils.getString((Map)e, (Object)"picture_id"));
                        attachmentFile.setFileExtension("jpg");
                        return attachmentFile;
                    }).collect(Collectors.toList());
                }
            }
        }
    }

    private void customizePcmBudgetProjectApprovals(String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        String cmptSchema = "PCM_budgetProjectApprovals_DTD_attachment";
        if (!cmptSchema.equals(schema)) {
            return;
        }
        Map bpmData = Optional.ofNullable(executeContext.getBpmData()).orElse(new HashMap());
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("attachment_type", "1");
        parameter.put("project_no", (String)bpmData.get("project_no"));
        parameter.put("version_no", (String)bpmData.get("version_no"));
        if (bpmData.get("version_no") == null) {
            return;
        }
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create((String)"bm.pcsc.project.budget.attachment.get", parameter, (Map)((Map)JsonUtil.objectToJavaObject((Object)executeContext, Map.class)), (Map)((Map)JsonUtil.objectToJavaObject((Object)executeContext.getBusinessUnit(), Map.class)));
        DigiwinAthenaApiResponse athenaApiResponse = ((DigiwinAtdmProxyService)SpringContextHolder.getBean(DigiwinAtdmProxyService.class)).dataQueryByActionId(AppRequestContext.getContextEntity().getLocale(), AppRequestContext.getContextEntity().getIamUserToken(), JsonUtil.javaObjectToJsonString((Object)request), AppRequestContext.getContextEntity().getTenantId());
        if (athenaApiResponse == null) {
            return;
        }
        Map map = (Map)athenaApiResponse.getResponse();
        if (map == null) {
            return;
        }
        List budgetAttachmentInfoList = (List)map.get("budget_attachment_info");
        if (CollectionUtils.isEmpty((Collection)budgetAttachmentInfoList)) {
            return;
        }
        String attachment = (String)((Map)budgetAttachmentInfoList.get(0)).get("attachment");
        if (StringUtils.isEmpty((CharSequence)attachment)) {
            return;
        }
        List rawAttachment = (List)JsonUtil.jsonStringToObject((String)attachment, List.class);
        if (CollectionUtils.isEmpty((Collection)rawAttachment)) {
            return;
        }
        HashMap uiBotAttachment = new HashMap();
        uiBotAttachment.put("data", rawAttachment.stream().map(raw -> {
            UiBotAttachmentData uiBotAttachmentData = new UiBotAttachmentData();
            uiBotAttachmentData.setId((String)raw.get("id"));
            uiBotAttachmentData.setName((String)raw.get("fileName"));
            uiBotAttachmentData.setUploadUserName("");
            uiBotAttachmentData.setCreateDate(StringUtil.valueOf(raw.get("createDate")).replace("/", "-"));
            uiBotAttachmentData.setSize(new Double(StringUtil.valueOf((Object)raw.getOrDefault("totalSize", 0))));
            uiBotAttachmentData.setShareUrl("");
            return uiBotAttachmentData;
        }).collect(Collectors.toList()));
        data.put(cmptSchema, uiBotAttachment);
    }

    public static Attachment createAttachment(List<Map<String, Object>> fileInfoList, Attachment attachment, String title) {
        ArrayList<AttachmentFile> fileList = new ArrayList<AttachmentFile>();
        for (Map<String, Object> fileInfo : fileInfoList) {
            String fileExtension = null != AttachmentUtil.getAttachmentFileSuffix((String)((String)fileInfo.get("name"))) ? AttachmentUtil.getAttachmentFileSuffix((String)((String)fileInfo.get("name"))) : "pdf";
            String fileId = null != fileInfo.get("id") ? String.valueOf(fileInfo.get("id")) : "";
            String fileName = null != fileInfo.get("name") ? String.valueOf(fileInfo.get("name")) : "";
            String shareUrl = null != fileInfo.get("file_download_url") ? String.valueOf(fileInfo.get("file_download_url")) : "";
            String uploadTime = null != fileInfo.get("create_date") ? String.valueOf(fileInfo.get("create_date")) : "";
            String uploader = null != fileInfo.get("upload_user_name") ? String.valueOf(fileInfo.get("upload_user_name")) : "";
            String fileSize = null != fileInfo.get("size") ? String.valueOf(fileInfo.get("size")) : "0";
            AttachmentFile attachmentFile = AttachmentFile.create((String)fileExtension, (String)fileId, (String)fileName, (Long)Double.valueOf(fileSize).longValue(), (String)shareUrl, (String)uploadTime, (String)uploader);
            fileList.add(attachmentFile);
        }
        if (ObjectUtils.isEmpty((Object)attachment)) {
            attachment = new Attachment();
            attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
            attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
            attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        }
        attachment.setFileList(fileList);
        attachment.setTitle(title);
        return attachment;
    }

    public void setSupportImageAndVideoType() {
        this.uploadTypes = new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Attachment createManualReportingAttachment(String locale, UiBotTableColumn column, Map<String, Object> bizData, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        Attachment attachment = new Attachment();
        if ("sch-manual-task-delivery".equalsIgnoreCase(column.getType())) {
            attachment.setRequired(Boolean.valueOf(true));
            attachment.setType(AttachmentTypeEnum.READ_AND_WRITE.getValue());
        }
        if ("sch-manual-task-delivery-history".equalsIgnoreCase(column.getType())) {
            attachment.setRequired(Boolean.valueOf(false));
            attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        }
        Object data = bizData.get(column.getSchema());
        Attachment.translateDoubleTimeToString((Object)data, (String)"create_date");
        UiBotAttachment uiBotAttachment = (UiBotAttachment)JsonUtil.objectToJavaObject((Object)data, UiBotAttachment.class);
        if (ObjectUtils.isNotEmpty((Object)uiBotAttachment) && !CollectionUtils.isEmpty((Collection)uiBotAttachment.getData())) {
            for (UiBotAttachmentData uibotAttachData : uiBotAttachment.getData()) {
                attachment.getFileList().add(AttachmentFile.create((String)locale, (UiBotAttachmentData)uibotAttachData));
            }
        }
        attachment.setTitle(column.getHeaderName());
        attachment.setFileMaxSize(new FileMaxSize(Long.valueOf(0x6400000L)));
        attachment.setPlaceholder("\u5927\u5c0f\u9650\u5236100MB");
        attachment.setErrorMessage("\u4e0a\u4f20\u5931\u8d25");
        AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        rawDataDigiwinAthena.setPath("task_info");
        rawDataDigiwinAthena.setTmActivityId(digiwinAtmcBacklogDetail.getTmActivityId());
        rawDataDigiwinAthena.setTmTaskId(digiwinAtmcBacklogDetail.getTmTaskId());
        rawDataDigiwinAthena.setBuckets("SCH");
        rawDataDigiwinAthena.setUploadCategory("schManualAssignmentAttachment");
        rawDataDigiwinAthena.setDisableAam(Boolean.valueOf(true));
        attachment.setRawData((AttachmentRawData)rawDataDigiwinAthena);
        return attachment;
    }

    public static void translateDoubleTimeToString(Object data, String dateFieldName) {
        if (Objects.isNull(data)) {
            return;
        }
        List dataList = (List)MapUtil.getOrDefault((Map)((Map)data), (String)"data", Collections.emptyList());
        dataList.forEach(item -> {
            if (Objects.nonNull(item.get(dateFieldName))) {
                double createDate = MapUtils.getDouble((Map)item, (Object)dateFieldName);
                String translateCreateDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date((long)createDate));
                item.put(dateFieldName, translateCreateDate);
            }
        });
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        Attachment attachment = new Attachment();
        attachment.setComponentId(rawContent.getComponentId());
        attachment.setTitle(rawContent.getLabel());
        attachment.setEnable(rawContent.getEditable());
        attachment.setType(BooleanUtils.isTrue((Boolean)rawContent.getEditable()) ? AttachmentTypeEnum.READ_AND_WRITE.getValue() : AttachmentTypeEnum.READ_ONLY.getValue());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        Card.DesignerRawCard.Content.AttachmentObj attachmentObj = (Card.DesignerRawCard.Content.AttachmentObj)JsonUtil.objectToJavaObject((Object)rawContent.getSetting(), Card.DesignerRawCard.Content.AttachmentObj.class);
        if (attachmentObj != null) {
            attachment.setPlaceholder(attachmentObj.getPlaceholder());
            attachment.setLimit(attachmentObj.getLimit());
            attachment.setFileMaxSize(attachmentObj.getFileMaxSize());
            attachment.setUploadTypes(attachmentObj.getUploadTypes());
            attachment.setIsFold(attachmentObj.getIsFold());
            attachment.setFoldNumber(attachmentObj.getFoldNumber());
            attachment.setDefaultExpand(attachmentObj.getDefaultExpand());
            AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
            rawDataDigiwinAthena.setBuckets(attachmentObj.getBuckets());
            if (attachmentObj.getRawData() != null) {
                rawDataDigiwinAthena.setDisableAam(attachmentObj.getRawData().getDisableAam());
                rawDataDigiwinAthena.setUploadCategory(attachmentObj.getRawData().getUploadCategory());
            }
            attachment.setRawData((AttachmentRawData)rawDataDigiwinAthena);
        }
        attachment.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return attachment;
    }

    public void applyEditable(Boolean enable) {
        super.applyEditable(enable);
        this.type = BooleanUtils.isTrue((Boolean)enable) ? AttachmentTypeEnum.READ_AND_WRITE.getValue() : AttachmentTypeEnum.READ_ONLY.getValue();
    }

    public List<AttachmentFile> getFileList() {
        return this.fileList;
    }

    public FileMaxSize getFileMaxSize() {
        return this.fileMaxSize;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public T getRawData() {
        return (T)this.rawData;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getTitleStyleType() {
        return this.titleStyleType;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getStyleType() {
        return this.styleType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getFileChoice() {
        return this.fileChoice;
    }

    public Boolean getIsArray() {
        return this.isArray;
    }

    public Boolean getIsFold() {
        return this.isFold;
    }

    public Integer getFoldNumber() {
        return this.foldNumber;
    }

    public Boolean getDefaultExpand() {
        return this.defaultExpand;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setFileList(List<AttachmentFile> fileList) {
        this.fileList = fileList;
    }

    public void setFileMaxSize(FileMaxSize fileMaxSize) {
        this.fileMaxSize = fileMaxSize;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public void setRawData(T rawData) {
        this.rawData = rawData;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleStyleType(Integer titleStyleType) {
        this.titleStyleType = titleStyleType;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setStyleType(Integer styleType) {
        this.styleType = styleType;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setFileChoice(String fileChoice) {
        this.fileChoice = fileChoice;
    }

    public void setIsArray(Boolean isArray) {
        this.isArray = isArray;
    }

    public void setIsFold(Boolean isFold) {
        this.isFold = isFold;
    }

    public void setFoldNumber(Integer foldNumber) {
        this.foldNumber = foldNumber;
    }

    public void setDefaultExpand(Boolean defaultExpand) {
        this.defaultExpand = defaultExpand;
    }

    public void setUploadTypes(List<Integer> uploadTypes) {
        this.uploadTypes = uploadTypes;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$maxSize = this.getMaxSize();
        Long other$maxSize = other.getMaxSize();
        if (this$maxSize == null ? other$maxSize != null : !((Object)this$maxSize).equals(other$maxSize)) {
            return false;
        }
        Integer this$titleStyleType = this.getTitleStyleType();
        Integer other$titleStyleType = other.getTitleStyleType();
        if (this$titleStyleType == null ? other$titleStyleType != null : !((Object)this$titleStyleType).equals(other$titleStyleType)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$styleType = this.getStyleType();
        Integer other$styleType = other.getStyleType();
        if (this$styleType == null ? other$styleType != null : !((Object)this$styleType).equals(other$styleType)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Boolean this$isArray = this.getIsArray();
        Boolean other$isArray = other.getIsArray();
        if (this$isArray == null ? other$isArray != null : !((Object)this$isArray).equals(other$isArray)) {
            return false;
        }
        Boolean this$isFold = this.getIsFold();
        Boolean other$isFold = other.getIsFold();
        if (this$isFold == null ? other$isFold != null : !((Object)this$isFold).equals(other$isFold)) {
            return false;
        }
        Integer this$foldNumber = this.getFoldNumber();
        Integer other$foldNumber = other.getFoldNumber();
        if (this$foldNumber == null ? other$foldNumber != null : !((Object)this$foldNumber).equals(other$foldNumber)) {
            return false;
        }
        Boolean this$defaultExpand = this.getDefaultExpand();
        Boolean other$defaultExpand = other.getDefaultExpand();
        if (this$defaultExpand == null ? other$defaultExpand != null : !((Object)this$defaultExpand).equals(other$defaultExpand)) {
            return false;
        }
        List this$fileList = this.getFileList();
        List other$fileList = other.getFileList();
        if (this$fileList == null ? other$fileList != null : !((Object)this$fileList).equals(other$fileList)) {
            return false;
        }
        FileMaxSize this$fileMaxSize = this.getFileMaxSize();
        FileMaxSize other$fileMaxSize = other.getFileMaxSize();
        if (this$fileMaxSize == null ? other$fileMaxSize != null : !this$fileMaxSize.equals(other$fileMaxSize)) {
            return false;
        }
        AttachmentRawData this$rawData = this.getRawData();
        AttachmentRawData other$rawData = other.getRawData();
        if (this$rawData == null ? other$rawData != null : !this$rawData.equals(other$rawData)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$fileChoice = this.getFileChoice();
        String other$fileChoice = other.getFileChoice();
        if (this$fileChoice == null ? other$fileChoice != null : !this$fileChoice.equals(other$fileChoice)) {
            return false;
        }
        List this$uploadTypes = this.getUploadTypes();
        List other$uploadTypes = other.getUploadTypes();
        if (this$uploadTypes == null ? other$uploadTypes != null : !((Object)this$uploadTypes).equals(other$uploadTypes)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        return !(this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Attachment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $maxSize = this.getMaxSize();
        result = result * 59 + ($maxSize == null ? 43 : ((Object)$maxSize).hashCode());
        Integer $titleStyleType = this.getTitleStyleType();
        result = result * 59 + ($titleStyleType == null ? 43 : ((Object)$titleStyleType).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $styleType = this.getStyleType();
        result = result * 59 + ($styleType == null ? 43 : ((Object)$styleType).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Boolean $isArray = this.getIsArray();
        result = result * 59 + ($isArray == null ? 43 : ((Object)$isArray).hashCode());
        Boolean $isFold = this.getIsFold();
        result = result * 59 + ($isFold == null ? 43 : ((Object)$isFold).hashCode());
        Integer $foldNumber = this.getFoldNumber();
        result = result * 59 + ($foldNumber == null ? 43 : ((Object)$foldNumber).hashCode());
        Boolean $defaultExpand = this.getDefaultExpand();
        result = result * 59 + ($defaultExpand == null ? 43 : ((Object)$defaultExpand).hashCode());
        List $fileList = this.getFileList();
        result = result * 59 + ($fileList == null ? 43 : ((Object)$fileList).hashCode());
        FileMaxSize $fileMaxSize = this.getFileMaxSize();
        result = result * 59 + ($fileMaxSize == null ? 43 : $fileMaxSize.hashCode());
        AttachmentRawData $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : $rawData.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $fileChoice = this.getFileChoice();
        result = result * 59 + ($fileChoice == null ? 43 : $fileChoice.hashCode());
        List $uploadTypes = this.getUploadTypes();
        result = result * 59 + ($uploadTypes == null ? 43 : ((Object)$uploadTypes).hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        return result;
    }

    public String toString() {
        return "Attachment(fileList=" + this.getFileList() + ", fileMaxSize=" + this.getFileMaxSize() + ", maxSize=" + this.getMaxSize() + ", rawData=" + this.getRawData() + ", title=" + this.getTitle() + ", titleStyleType=" + this.getTitleStyleType() + ", type=" + this.getType() + ", styleType=" + this.getStyleType() + ", limit=" + this.getLimit() + ", fileChoice=" + this.getFileChoice() + ", isArray=" + this.getIsArray() + ", isFold=" + this.getIsFold() + ", foldNumber=" + this.getFoldNumber() + ", defaultExpand=" + this.getDefaultExpand() + ", uploadTypes=" + this.getUploadTypes() + ", dataSource=" + this.getDataSource() + ")";
    }

    public Attachment() {
    }

    public Attachment(List<AttachmentFile> fileList, FileMaxSize fileMaxSize, Long maxSize, T rawData, String title, Integer titleStyleType, Integer type, Integer styleType, Integer limit, String fileChoice, Boolean isArray, Boolean isFold, Integer foldNumber, Boolean defaultExpand, List<Integer> uploadTypes, DataSource dataSource) {
        this.fileList = fileList;
        this.fileMaxSize = fileMaxSize;
        this.maxSize = maxSize;
        this.rawData = rawData;
        this.title = title;
        this.titleStyleType = titleStyleType;
        this.type = type;
        this.styleType = styleType;
        this.limit = limit;
        this.fileChoice = fileChoice;
        this.isArray = isArray;
        this.isFold = isFold;
        this.foldNumber = foldNumber;
        this.defaultExpand = defaultExpand;
        this.uploadTypes = uploadTypes;
        this.dataSource = dataSource;
    }
}

