/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.calendar;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class InputCalendar
extends BaseInputMobileComponent
implements Serializable {
    private static final long serialVersionUID = 963291030278645004L;
    public static final String COMPONENT_TYPE = "INPUT_CALENDAR";
    private List<InputCalendarDate> dateValueList = new ArrayList();
    private InputCalendarDate maxDate = InputCalendarDate.create((String)"2121", (String)"12", (String)"31");
    private InputCalendarDate minDate = InputCalendarDate.create((String)"2000", (String)"01", (String)"01");
    private InputCalendarDate maxDateSelectable;
    private InputCalendarDate minDateSelectable;
    private String title;
    private Integer type;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY, value="text")
    @JSONField(serialize=false, deserialize=true, name="text")
    private String inputText;
    private String endSchema;
    private String endSchemaPath;
    private Integer styleType = InputCalendarStyleTypeEnum.DEFAULT.getValue();

    public static InputCalendar create(String title, Integer type, String value, Boolean required, Boolean hidden, Boolean enable, String errorMessage) {
        InputCalendar inputCalendar = new InputCalendar();
        inputCalendar.setTitle(title);
        inputCalendar.setType(type);
        inputCalendar.setErrorMessage(errorMessage);
        inputCalendar.setPlaceholder(errorMessage);
        if (StringUtils.hasLength((String)value) && !StringUtils.isEmpty((Object)value)) {
            String[] values = value.contains("-") ? value.split("-") : value.split("\\.");
            inputCalendar.getDateValueList().add(InputCalendarDate.create((String)values[0], (String)values[1], (String)values[2]));
        }
        if (value == null && !required.booleanValue()) {
            inputCalendar.setErrorMessage("-");
            inputCalendar.setPlaceholder("-");
        } else if (required.booleanValue()) {
            inputCalendar.setErrorMessage(errorMessage);
            inputCalendar.setPlaceholder(errorMessage);
        }
        inputCalendar.setMinDate(InputCalendarDate.create((String)"1900", (String)"01", (String)"01"));
        inputCalendar.setMinDateSelectable(InputCalendarDate.create((String)"1900", (String)"01", (String)"01"));
        inputCalendar.setRequired(required);
        inputCalendar.setHidden(hidden);
        inputCalendar.setEnable(enable);
        return inputCalendar;
    }

    public static InputCalendar create(String title, Integer type, InputCalendarDate minDateSelectable, InputCalendarDate maxDateSelectable, Boolean required, Boolean hidden, Boolean enable, String errorMessage) {
        InputCalendar inputCalendar = new InputCalendar();
        inputCalendar.setTitle(title);
        inputCalendar.setType(type);
        inputCalendar.setErrorMessage(errorMessage);
        inputCalendar.setPlaceholder(errorMessage);
        inputCalendar.setMaxDateSelectable(maxDateSelectable);
        inputCalendar.setMinDateSelectable(minDateSelectable);
        inputCalendar.setRequired(required);
        inputCalendar.setHidden(hidden);
        inputCalendar.setEnable(enable);
        return inputCalendar;
    }

    public static InputCalendar create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList, Map<String, Object> bizData, List<Rule> mobileRuleList, boolean enable, boolean required, ApiRequest apiRequest) {
        InputCalendar calendar = new InputCalendar();
        String dateData = (String)bizData.get(column.getSchema());
        if (null != dateData && !dateData.isEmpty()) {
            LocalDate localDate = DateTimeUtil.parseLocalDateUseDefaultPattern((String)dateData);
            calendar.addDateValue(DateTimeUtil.getFullYear((Integer)localDate.getYear()), DateTimeUtil.getFullMonth((Integer)localDate.getMonthValue()), DateTimeUtil.getFullDate((Integer)localDate.getDayOfMonth()));
        }
        calendar.setMinDate(InputCalendarDate.create((String)"2000", (String)"01", (String)"01"));
        calendar.setMaxDate(InputCalendarDate.create((String)"2121", (String)"12", (String)"31"));
        if ("project_info".equalsIgnoreCase(column.getPath()) && ("actual_start_date".equalsIgnoreCase(column.getSchema()) || "actual_finish_date".equalsIgnoreCase(column.getSchema()))) {
            calendar.setMaxDateSelectable(InputCalendarDate.createToday());
        }
        if ("task_info".equalsIgnoreCase(column.getPath()) && ("actual_finish_date".equalsIgnoreCase(column.getSchema()) || "actual_start_date".equalsIgnoreCase(column.getSchema()))) {
            calendar.setMaxDateSelectable(InputCalendarDate.createToday());
        }
        calendar.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9"));
        calendar.setRequired(Boolean.valueOf(required));
        calendar.setTitle(column.getHeaderName());
        calendar.setType(InputCalendarTypeEnum.SELECT_SINGLE_DATE.getValue());
        calendar.setErrorMessage(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u5b8c\u6210\u7387100%\u540e\u53ef\u586b"));
        calendar.setEnable(Boolean.valueOf(enable));
        calendar.addAllMobileRule(bizData, column.getSchema(), mobileRuleList, locale, apiRequest, Collections.emptyMap(), "");
        return calendar;
    }

    public static InputCalendar create(UiBotLayout uiBotFieldLayout, UiBotRule uiBotRule, String locale) {
        InputCalendar inputCalendar = new InputCalendar();
        inputCalendar.setSchema(uiBotFieldLayout.getSchema());
        inputCalendar.setTitle(uiBotFieldLayout.getHeaderName());
        inputCalendar.setType(InputCalendarTypeEnum.SELECT_SINGLE_DATE.getValue());
        inputCalendar.setMinDate(InputCalendarDate.create((String)"2000", (String)"01", (String)"01"));
        inputCalendar.setMaxDate(InputCalendarDate.create((String)"2121", (String)"12", (String)"31"));
        inputCalendar.setMinDateSelectable(InputCalendarDate.create((String)"2000", (String)"01", (String)"01"));
        inputCalendar.setMaxDateSelectable(InputCalendarDate.create((String)"2121", (String)"12", (String)"31"));
        inputCalendar.setEnable(Boolean.valueOf(true));
        inputCalendar.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9"));
        if (uiBotRule != null) {
            inputCalendar.setRequired(Boolean.valueOf("required".equalsIgnoreCase(uiBotRule.getKey())));
        } else {
            inputCalendar.setRequired(Boolean.valueOf(false));
        }
        return inputCalendar;
    }

    public static InputCalendar create(UiBotLayout groupLayout, List<String> values, Integer type) {
        InputCalendar inputCalendar = new InputCalendar();
        inputCalendar.setType(type);
        inputCalendar.setSchema(groupLayout.getSchema());
        inputCalendar.setTitle(StringUtils.hasLength((String)groupLayout.getHeaderName()) ? groupLayout.getHeaderName() : groupLayout.getPlaceholder());
        inputCalendar.setMinDate(InputCalendarDate.create((String)"2000", (String)"01", (String)"01"));
        inputCalendar.setMaxDate(InputCalendarDate.create((String)"2121", (String)"12", (String)"31"));
        inputCalendar.setMinDateSelectable(InputCalendarDate.create((String)"2000", (String)"01", (String)"01"));
        inputCalendar.setMaxDateSelectable(InputCalendarDate.create((String)"2121", (String)"12", (String)"31"));
        inputCalendar.setEnable(Boolean.valueOf(true));
        inputCalendar.setRequired(Boolean.valueOf(true));
        return inputCalendar;
    }

    public void addDateValue(String year, String month, String date) {
        this.dateValueList.add(InputCalendarDate.create((String)year, (String)month, (String)date));
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(Object::toString).orElse(null);
        if (StringUtils.hasLength((String)value)) {
            String[] values = value.contains("-") ? value.split("-") : value.split("\\.");
            this.dateValueList.add(InputCalendarDate.create((String)values[0], (String)values[1], (String)values[2]));
        }
    }

    public List<InputCalendarDate> getDateValueList() {
        return this.dateValueList;
    }

    public InputCalendarDate getMaxDate() {
        return this.maxDate;
    }

    public InputCalendarDate getMinDate() {
        return this.minDate;
    }

    public InputCalendarDate getMaxDateSelectable() {
        return this.maxDateSelectable;
    }

    public InputCalendarDate getMinDateSelectable() {
        return this.minDateSelectable;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getType() {
        return this.type;
    }

    public String getInputText() {
        return this.inputText;
    }

    public String getEndSchema() {
        return this.endSchema;
    }

    public String getEndSchemaPath() {
        return this.endSchemaPath;
    }

    public Integer getStyleType() {
        return this.styleType;
    }

    public void setDateValueList(List<InputCalendarDate> dateValueList) {
        this.dateValueList = dateValueList;
    }

    public void setMaxDate(InputCalendarDate maxDate) {
        this.maxDate = maxDate;
    }

    public void setMinDate(InputCalendarDate minDate) {
        this.minDate = minDate;
    }

    public void setMaxDateSelectable(InputCalendarDate maxDateSelectable) {
        this.maxDateSelectable = maxDateSelectable;
    }

    public void setMinDateSelectable(InputCalendarDate minDateSelectable) {
        this.minDateSelectable = minDateSelectable;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY, value="text")
    public void setInputText(String inputText) {
        this.inputText = inputText;
    }

    public void setEndSchema(String endSchema) {
        this.endSchema = endSchema;
    }

    public void setEndSchemaPath(String endSchemaPath) {
        this.endSchemaPath = endSchemaPath;
    }

    public void setStyleType(Integer styleType) {
        this.styleType = styleType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputCalendar)) {
            return false;
        }
        InputCalendar other = (InputCalendar)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$styleType = this.getStyleType();
        Integer other$styleType = other.getStyleType();
        if (this$styleType == null ? other$styleType != null : !((Object)this$styleType).equals(other$styleType)) {
            return false;
        }
        List this$dateValueList = this.getDateValueList();
        List other$dateValueList = other.getDateValueList();
        if (this$dateValueList == null ? other$dateValueList != null : !((Object)this$dateValueList).equals(other$dateValueList)) {
            return false;
        }
        InputCalendarDate this$maxDate = this.getMaxDate();
        InputCalendarDate other$maxDate = other.getMaxDate();
        if (this$maxDate == null ? other$maxDate != null : !this$maxDate.equals(other$maxDate)) {
            return false;
        }
        InputCalendarDate this$minDate = this.getMinDate();
        InputCalendarDate other$minDate = other.getMinDate();
        if (this$minDate == null ? other$minDate != null : !this$minDate.equals(other$minDate)) {
            return false;
        }
        InputCalendarDate this$maxDateSelectable = this.getMaxDateSelectable();
        InputCalendarDate other$maxDateSelectable = other.getMaxDateSelectable();
        if (this$maxDateSelectable == null ? other$maxDateSelectable != null : !this$maxDateSelectable.equals(other$maxDateSelectable)) {
            return false;
        }
        InputCalendarDate this$minDateSelectable = this.getMinDateSelectable();
        InputCalendarDate other$minDateSelectable = other.getMinDateSelectable();
        if (this$minDateSelectable == null ? other$minDateSelectable != null : !this$minDateSelectable.equals(other$minDateSelectable)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$inputText = this.getInputText();
        String other$inputText = other.getInputText();
        if (this$inputText == null ? other$inputText != null : !this$inputText.equals(other$inputText)) {
            return false;
        }
        String this$endSchema = this.getEndSchema();
        String other$endSchema = other.getEndSchema();
        if (this$endSchema == null ? other$endSchema != null : !this$endSchema.equals(other$endSchema)) {
            return false;
        }
        String this$endSchemaPath = this.getEndSchemaPath();
        String other$endSchemaPath = other.getEndSchemaPath();
        return !(this$endSchemaPath == null ? other$endSchemaPath != null : !this$endSchemaPath.equals(other$endSchemaPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputCalendar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $styleType = this.getStyleType();
        result = result * 59 + ($styleType == null ? 43 : ((Object)$styleType).hashCode());
        List $dateValueList = this.getDateValueList();
        result = result * 59 + ($dateValueList == null ? 43 : ((Object)$dateValueList).hashCode());
        InputCalendarDate $maxDate = this.getMaxDate();
        result = result * 59 + ($maxDate == null ? 43 : $maxDate.hashCode());
        InputCalendarDate $minDate = this.getMinDate();
        result = result * 59 + ($minDate == null ? 43 : $minDate.hashCode());
        InputCalendarDate $maxDateSelectable = this.getMaxDateSelectable();
        result = result * 59 + ($maxDateSelectable == null ? 43 : $maxDateSelectable.hashCode());
        InputCalendarDate $minDateSelectable = this.getMinDateSelectable();
        result = result * 59 + ($minDateSelectable == null ? 43 : $minDateSelectable.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $inputText = this.getInputText();
        result = result * 59 + ($inputText == null ? 43 : $inputText.hashCode());
        String $endSchema = this.getEndSchema();
        result = result * 59 + ($endSchema == null ? 43 : $endSchema.hashCode());
        String $endSchemaPath = this.getEndSchemaPath();
        result = result * 59 + ($endSchemaPath == null ? 43 : $endSchemaPath.hashCode());
        return result;
    }

    public String toString() {
        return "InputCalendar(dateValueList=" + this.getDateValueList() + ", maxDate=" + this.getMaxDate() + ", minDate=" + this.getMinDate() + ", maxDateSelectable=" + this.getMaxDateSelectable() + ", minDateSelectable=" + this.getMinDateSelectable() + ", title=" + this.getTitle() + ", type=" + this.getType() + ", inputText=" + this.getInputText() + ", endSchema=" + this.getEndSchema() + ", endSchemaPath=" + this.getEndSchemaPath() + ", styleType=" + this.getStyleType() + ")";
    }
}

