/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.cascade;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeDistrictTypeEnum;
import java.io.Serializable;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class InputCascadeDistrict
extends BaseInputMobileComponent
implements Serializable {
    public static final String COMPONENT_TYPE = "INPUT_CASCADE_DISTRICT";
    private static final long serialVersionUID = 8427512201222589114L;
    private String id;
    private String title;
    private String requestUrl;
    private Integer districtType = InputCascadeDistrictTypeEnum.ALL_PCA.getValue();
    private String province;
    private String city;
    private String area;
    private String street;

    public static InputCascadeDistrict create(String schema, String title, String locale, Map<String, Object> datas, boolean required, Integer type) {
        InputCascadeDistrict district = new InputCascadeDistrict();
        district.setSchema(schema);
        district.setTitle(title);
        district.setPlaceholder(LocaleUtil.getMobileTextByKey((String)locale, (String)"\u8bf7\u9009\u62e9"));
        district.setRequired(Boolean.valueOf(required));
        district.setDistrictType(type);
        if (!CollectionUtils.isEmpty(datas)) {
            district.setId(String.valueOf(datas.get("area_id")));
            district.setProvince((String)datas.get("province"));
            district.setCity((String)datas.get("city"));
            district.setArea((String)datas.get("area"));
        }
        return district;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public Integer getDistrictType() {
        return this.districtType;
    }

    public String getProvince() {
        return this.province;
    }

    public String getCity() {
        return this.city;
    }

    public String getArea() {
        return this.area;
    }

    public String getStreet() {
        return this.street;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public void setDistrictType(Integer districtType) {
        this.districtType = districtType;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputCascadeDistrict)) {
            return false;
        }
        InputCascadeDistrict other = (InputCascadeDistrict)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$districtType = this.getDistrictType();
        Integer other$districtType = other.getDistrictType();
        if (this$districtType == null ? other$districtType != null : !((Object)this$districtType).equals(other$districtType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$requestUrl = this.getRequestUrl();
        String other$requestUrl = other.getRequestUrl();
        if (this$requestUrl == null ? other$requestUrl != null : !this$requestUrl.equals(other$requestUrl)) {
            return false;
        }
        String this$province = this.getProvince();
        String other$province = other.getProvince();
        if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$area = this.getArea();
        String other$area = other.getArea();
        if (this$area == null ? other$area != null : !this$area.equals(other$area)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        return !(this$street == null ? other$street != null : !this$street.equals(other$street));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputCascadeDistrict;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $districtType = this.getDistrictType();
        result = result * 59 + ($districtType == null ? 43 : ((Object)$districtType).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $requestUrl = this.getRequestUrl();
        result = result * 59 + ($requestUrl == null ? 43 : $requestUrl.hashCode());
        String $province = this.getProvince();
        result = result * 59 + ($province == null ? 43 : $province.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : $area.hashCode());
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        return result;
    }

    public String toString() {
        return "InputCascadeDistrict(id=" + this.getId() + ", title=" + this.getTitle() + ", requestUrl=" + this.getRequestUrl() + ", districtType=" + this.getDistrictType() + ", province=" + this.getProvince() + ", city=" + this.getCity() + ", area=" + this.getArea() + ", street=" + this.getStreet() + ")";
    }
}

