/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.choosetaskprogress;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.choosetaskprogress.ChooseTaskProgress;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.bpm.service.DigiwinBpmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.taskengine.model.DigiwinTaskEngineWorkitem;
import com.digiwin.mobile.mobileuibot.proxy.taskengine.service.DigiwinTaskEngineProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressPerson;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="chooseTaskProgressParamAnalyzer")
public class ChooseTaskProgressParamAnalyzer
implements ComponentParamAnalyzer<ChooseTaskProgress, String> {
    private static final Logger logger = LoggerFactory.getLogger(ChooseTaskProgressParamAnalyzer.class);
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinBpmProxyService digiwinBpmProxyService;
    @Autowired
    private DigiwinTaskEngineProxyService digiwinTaskEngineProxyService;

    public String getComponentType() {
        return "CHOOSE_TASK_PROGRESS";
    }

    public Class<ChooseTaskProgress> getSubmitParamType() {
        return ChooseTaskProgress.class;
    }

    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof ChooseTaskProgress)) {
            logger.debug("submitParam is not instanceof ChooseTaskProgress component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return "";
        }
        ChooseTaskProgress chooseTaskProgress = (ChooseTaskProgress)submitParam;
        return Optional.ofNullable(chooseTaskProgress.getChosenId()).orElse("");
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
        Map extendedFields;
        Map data = (Map)apiRequest.getRawData().get((Object)"data");
        Map requestData = new HashMap();
        Map actionMap = (Map)apiRequest.getRawData().get((Object)"action");
        if (actionMap != null && (extendedFields = (Map)actionMap.get("extendedFields")) != null) {
            requestData = (Map)extendedFields.get("reexecuteData");
        }
        String dataFrom = null;
        if (actionMap != null && actionMap.get("executeContext") != null) {
            dataFrom = (String)((HashMap)actionMap.get("executeContext")).get("dataFrom");
        }
        ChooseTaskProgress chooseTaskProgress = new ChooseTaskProgress();
        if ("PTM".equalsIgnoreCase(dataFrom)) {
            List attachActions;
            String workitemId = Optional.ofNullable(actionMap.get("paras")).map(e -> {
                Map parasMap = (Map)e;
                return MapUtils.getString((Map)parasMap, (Object)"workitemId");
            }).orElse("");
            if (!StringUtils.hasLength((String)workitemId) && !CollectionUtils.isEmpty((Collection)(attachActions = (List)MapUtil.getOrDefault((Map)actionMap, (String)"attachActions", Collections.emptyList())))) {
                for (Map attachAction : attachActions) {
                    Optional<String> workitemIdOpt = Optional.ofNullable(attachAction.get("paras")).map(e -> {
                        Map parasMap = (Map)e;
                        return MapUtils.getString((Map)parasMap, (Object)"workitemId");
                    });
                    if (!workitemIdOpt.isPresent()) continue;
                    workitemId = workitemIdOpt.get();
                    break;
                }
            }
            if (!StringUtils.hasLength((String)workitemId)) {
                return;
            }
            List activities = null;
            activities = this.isBizDataEntryDriven(actionMap) ? this.digiwinTaskEngineProxyService.getPtmActivityList(apiRequest.getLocale(), apiRequest.getIamUserToken(), workitemId) : this.digiwinTaskEngineProxyService.getTaskEngineActivityList(apiRequest.getLocale(), apiRequest.getIamUserToken(), workitemId);
            if (!CollectionUtils.isEmpty((Collection)activities)) {
                List progressList = activities.stream().map(activity -> {
                    TaskProgress taskProgress = new TaskProgress();
                    taskProgress.setId(activity.getActivityId());
                    taskProgress.setName(activity.getActivityName());
                    taskProgress.setState(TaskProgressStateEnum.DONE.getValue());
                    List workitemList = activity.getWorkitemList();
                    if (!CollectionUtils.isEmpty((Collection)workitemList)) {
                        ArrayList<TaskProgressPerson> personList = new ArrayList<TaskProgressPerson>();
                        for (DigiwinTaskEngineWorkitem workitem : workitemList) {
                            TaskProgressPerson progressPerson = new TaskProgressPerson();
                            progressPerson.setName(this.digiwinEocProxyService.getEocPersonInfo(workitem.getPerformerId(), apiRequest.getIamUserToken(), 2).getName());
                            personList.add(progressPerson);
                        }
                        taskProgress.setPersonList(personList);
                    }
                    return taskProgress;
                }).collect(Collectors.toList());
                chooseTaskProgress.setTaskProgressList(progressList);
            }
        } else {
            List taskList = this.digiwinBpmProxyService.getRedoList(apiRequest.getLocale(), apiRequest.getIamUserToken(), requestData);
            if (taskList != null) {
                List progressList = taskList.stream().map(task -> {
                    TaskProgress taskProgress = new TaskProgress();
                    taskProgress.setId(task.getBpmActivityId());
                    taskProgress.setName(task.getBpmActivityName());
                    taskProgress.setState(TaskProgressStateEnum.DONE.getValue());
                    String pid = task.getPerformer();
                    ArrayList<TaskProgressPerson> personList = new ArrayList<TaskProgressPerson>();
                    TaskProgressPerson progressPerson = new TaskProgressPerson();
                    progressPerson.setName(this.digiwinEocProxyService.getEocPersonInfo(pid, apiRequest.getIamUserToken(), 2).getName());
                    personList.add(progressPerson);
                    taskProgress.setPersonList(personList);
                    return taskProgress;
                }).collect(Collectors.toList());
                chooseTaskProgress.setTaskProgressList(progressList);
            }
            pageData.put((Object)pageDataKey, (Object)chooseTaskProgress);
        }
        pageData.put((Object)pageDataKey, (Object)chooseTaskProgress);
    }

    private boolean isBizDataEntryDriven(Map<String, Object> actionMap) {
        if (actionMap == null) {
            return false;
        }
        Map executeContext = (Map)actionMap.get("executeContext");
        if (executeContext == null) {
            return false;
        }
        String category = StringUtil.valueOf(executeContext.get("category"));
        String pattern = StringUtil.valueOf(executeContext.get("pattern"));
        return TaskStringUtil.isBizDataEntryDriven((String)pattern, (String)category);
    }
}

