/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.ocr;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleMappingConfig;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.ocr.model.OcrData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableAttachmentColumnAttribute;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class InputOcr
extends Attachment<AttachmentRawDataDigiwinAthena>
implements Serializable {
    private static final long serialVersionUID = -5849206980500061509L;
    public static final String COMPONENT_TYPE = "INPUT_OCR";
    private Integer cardType;
    private List<OcrData> dataList;
    private String requestUrl;

    public static InputOcr create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList, Map<String, Object> bizData, List<Rule> mobileRuleList, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        InputOcr inputOcr = new InputOcr();
        inputOcr.setRequestUrl("/mobile/v1/proxy/ocr/identification");
        List columns = column.getColumns();
        boolean required = false;
        for (UiBotTableColumn tableColumn : columns) {
            required = mobileRuleList.stream().filter(rule -> rule.getSchema().equalsIgnoreCase(tableColumn.getSchema()) && rule.getCategory().equalsIgnoreCase(RuleCategoryEnum.VALIDATE.getCategory()) && rule.getType().equalsIgnoreCase(ValidateRuleTypeEnum.REQUIRED.getType())).findFirst().isPresent();
            if (!required) continue;
            break;
        }
        String seachField = "";
        String path = "";
        for (Rule rule2 : mobileRuleList) {
            if (rule2.getMappingConfig() == null || !column.getOcrType().equals(rule2.getMappingConfig().getCardType())) continue;
            RuleMappingConfig mappingConfig = rule2.getMappingConfig();
            if (!StringUtils.isEmpty((Object)mappingConfig.getPlaceholder())) {
                inputOcr.setPlaceholder(mappingConfig.getPlaceholder());
            }
            seachField = mappingConfig.getSearchFieldType();
            inputOcr.setSchema(rule2.getSchema());
            inputOcr.setCardType(mappingConfig.getCardType());
            inputOcr.setDataList(mappingConfig.getDataList());
            if (rule2.getPath() == null) break;
            path = rule2.getPath();
            break;
        }
        boolean disableAam = Optional.ofNullable(column.getAttribute()).map(UiBotTableAttachmentColumnAttribute::getDisableAam).orElse(false);
        Object data = bizData.get(column.getSchema());
        UiBotAttachment uiBotAttachment = (UiBotAttachment)JsonUtil.objectToJavaObject((Object)data, UiBotAttachment.class);
        inputOcr.setRawData((AttachmentRawData)((AttachmentRawDataDigiwinAthena)Attachment.setAttachmentRawData((Attachment)new Attachment(), Attachment.class, (UiBotAttachment)uiBotAttachment, (String)locale, (UiBotTableColumn)column, columnRuleList, (DigiwinAtmcBacklogDetail)digiwinAtmcBacklogDetail, (Boolean)disableAam, (String)path).getRawData()));
        block2: for (OcrData ocrData : inputOcr.getDataList()) {
            for (UiBotTableColumn column1 : columns) {
                if (seachField.equals(column1.getType())) {
                    inputOcr.setTitle(column1.getHeaderName());
                }
                if (!ocrData.getMobileField().equals(column1.getSchema())) continue;
                ocrData.setFieldTitle(column1.getHeaderName());
                continue block2;
            }
        }
        for (OcrData ocrData : inputOcr.getDataList()) {
            ocrData.setFieldTitle(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)ocrData.getFieldTitle()));
        }
        return inputOcr;
    }

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public Integer getCardType() {
        return this.cardType;
    }

    public List<OcrData> getDataList() {
        return this.dataList;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setCardType(Integer cardType) {
        this.cardType = cardType;
    }

    public void setDataList(List<OcrData> dataList) {
        this.dataList = dataList;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputOcr)) {
            return false;
        }
        InputOcr other = (InputOcr)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$cardType = this.getCardType();
        Integer other$cardType = other.getCardType();
        if (this$cardType == null ? other$cardType != null : !((Object)this$cardType).equals(other$cardType)) {
            return false;
        }
        List this$dataList = this.getDataList();
        List other$dataList = other.getDataList();
        if (this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList)) {
            return false;
        }
        String this$requestUrl = this.getRequestUrl();
        String other$requestUrl = other.getRequestUrl();
        return !(this$requestUrl == null ? other$requestUrl != null : !this$requestUrl.equals(other$requestUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputOcr;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cardType = this.getCardType();
        result = result * 59 + ($cardType == null ? 43 : ((Object)$cardType).hashCode());
        List $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        String $requestUrl = this.getRequestUrl();
        result = result * 59 + ($requestUrl == null ? 43 : $requestUrl.hashCode());
        return result;
    }

    public String toString() {
        return "InputOcr(cardType=" + this.getCardType() + ", dataList=" + this.getDataList() + ", requestUrl=" + this.getRequestUrl() + ")";
    }

    public InputOcr(Integer cardType, List<OcrData> dataList, String requestUrl) {
        this.cardType = cardType;
        this.dataList = dataList;
        this.requestUrl = requestUrl;
    }

    public InputOcr() {
    }
}

