/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.singleselect;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinEspEnumerateResponse;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotFieldOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditorOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SingleSelectList
extends BaseInputMobileComponent
implements Serializable {
    private static final long serialVersionUID = 630883404159875793L;
    public static final String COMPONENT_TYPE = "SINGLE_SELECT_LIST";
    private List<SingleSelectListOption> optionList = new ArrayList();
    private Integer style;
    private String title;
    private String selectId;
    private String text;
    private Integer type = 1;
    private String url;
    private Map<String, Object> rawData;
    private List<String> selectIdList = new ArrayList();
    private List<String> textList = new ArrayList();
    private Boolean isShowDesc = false;
    private List<String> descPics;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public static SingleSelectList createOnTexts(String title, String url, List<String> selectIdList, List<String> textList, Map<String, Object> rawData, Integer type) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(type);
        selectList.setType(type);
        selectList.setUrl(url);
        selectList.setTextList(textList);
        selectList.setSelectIdList(selectIdList);
        selectList.setRawData(rawData);
        selectList.setRequired(Boolean.valueOf(true));
        return selectList;
    }

    public static SingleSelectList createOnText(String title, String url, String selectId, String text, Map<String, Object> rawData, Integer type, RelationRule relationRule) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setType(type);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setUrl(url);
        selectList.setSelectId(selectId);
        selectList.setText(text);
        selectList.setRawData(rawData);
        selectList.setRelationRule(relationRule);
        selectList.setRequired(Boolean.valueOf(true));
        return selectList;
    }

    public static SingleSelectList createByZtbEnum(List<DigiwinEspEnumerateResponse> enumerateInfo, String title, String selectId, String text) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(Boolean.valueOf(true));
        List optionList = selectList.getOptionList();
        for (DigiwinEspEnumerateResponse enumerateResponse : enumerateInfo) {
            SingleSelectListOption option = new SingleSelectListOption();
            option.setId(enumerateResponse.getEnumerateNo());
            option.setText(enumerateResponse.getEnumerateName());
            optionList.add(option);
        }
        selectList.setText(text);
        selectList.setSelectId(text);
        return selectList;
    }

    public static SingleSelectList createByAPC(List<Map<String, Object>> datas, String title, String selectId, String text, String local, boolean required, boolean enable) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(Boolean.valueOf(required));
        selectList.setEnable(Boolean.valueOf(enable));
        List optionList = selectList.getOptionList();
        for (Map<String, Object> data : datas) {
            SingleSelectListOption option = new SingleSelectListOption();
            option.setId((String)data.get("layout_no"));
            option.setText((String)data.get("layout_name"));
            if (ObjectUtils.nullSafeEquals((Object)selectId, (Object)data.get("layout_no"))) {
                option.setSelected(Boolean.valueOf(true));
            }
            optionList.add(option);
        }
        selectList.setText(text);
        selectList.setSelectId(selectId);
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
        selectList.setPlaceholder(localeService.getLanguageValue(local, "\u8bf7\u9009\u62e9"));
        ArrayList<CommonRule> ruleList = new ArrayList<CommonRule>(1);
        RelationRule rule = new RelationRule();
        CommonRule commonRule = new CommonRule();
        commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
        commonRule.setTargetSchema("area_name");
        commonRule.setTargetSelectId("");
        commonRule.setTargetText("");
        commonRule.setTargetSelectList(Collections.emptyList());
        ruleList.add(commonRule);
        rule.setRuleList(ruleList);
        selectList.setRelationRule(rule);
        return selectList;
    }

    public static SingleSelectList createByTbds(List<Map<String, Object>> datas, String idSchema, String valueSchema, String title, String selectId, String text, boolean required, boolean enable) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(Boolean.valueOf(required));
        selectList.setEnable(Boolean.valueOf(enable));
        List optionList = selectList.getOptionList();
        for (Map<String, Object> data : datas) {
            SingleSelectListOption option = new SingleSelectListOption();
            option.setId((String)data.get(idSchema));
            option.setText((String)data.get(valueSchema));
            if (selectId.equalsIgnoreCase((String)data.get(idSchema))) {
                option.setSelected(Boolean.valueOf(true));
            }
            optionList.add(option);
        }
        selectList.setText(text);
        selectList.setSelectId(selectId);
        return selectList;
    }

    @Deprecated
    public static SingleSelectList create(String title, String url) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setUrl(url);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(Boolean.valueOf(true));
        return selectList;
    }

    public static SingleSelectList create(String title, String url, Boolean isShowDesc, List<String> descPics) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setUrl(url);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(Boolean.valueOf(true));
        selectList.setIsShowDesc(Optional.ofNullable(isShowDesc).orElse(false));
        selectList.setDescPics((List)Optional.ofNullable(descPics).orElse(new ArrayList()));
        return selectList;
    }

    @Deprecated
    public static SingleSelectList create(String title, String url, String text) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setUrl(url);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setText(text);
        selectList.setSelectId(text);
        selectList.setRequired(Boolean.valueOf(true));
        return selectList;
    }

    public static SingleSelectList create(String title, String url, String text, Boolean isShowDesc, List<String> descPics) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setUrl(url);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setText(text);
        selectList.setSelectId(text);
        selectList.setRequired(Boolean.valueOf(true));
        selectList.setIsShowDesc(Optional.ofNullable(isShowDesc).orElse(false));
        selectList.setDescPics((List)Optional.ofNullable(descPics).orElse(new ArrayList()));
        return selectList;
    }

    public static SingleSelectList create(ParseFieldData fieldData, List<UiBotRule> ruleList, int style) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(fieldData.getLabel());
        selectList.setStyle(Integer.valueOf(style));
        if (ruleList != null && ruleList.size() > 0) {
            ruleList.stream().filter(uiBotRule -> fieldData.getSchema().equalsIgnoreCase(uiBotRule.getSchema())).forEach(uiBotRule -> {
                if (ValidateRuleTypeEnum.REQUIRED.getType().equalsIgnoreCase(uiBotRule.getKey())) {
                    selectList.setRequired(Boolean.valueOf("required".equalsIgnoreCase(uiBotRule.getKey())));
                }
            });
        }
        List options = fieldData.getOptions();
        for (UiBotTableColumnEditorOption option : options) {
            SingleSelectListOption listOption = new SingleSelectListOption();
            listOption.setId(String.valueOf(option.getValue()));
            listOption.setText(option.getTitle());
            if (String.valueOf(option.getValue()).equals(String.valueOf(fieldData.getData()))) {
                listOption.setSelected(Boolean.valueOf(true));
            }
            selectList.optionList.add(listOption);
        }
        return selectList;
    }

    public static SingleSelectList create(UiBotLayout layout, String selectId, boolean required) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(layout.getHeaderName() == null ? layout.getPlaceholder() : layout.getHeaderName());
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(Boolean.valueOf(required));
        selectList.setSelectId(selectId);
        List optionList = selectList.getOptionList();
        List options = layout.getOptions();
        for (UiBotFieldOption option : options) {
            SingleSelectListOption selectListOption = new SingleSelectListOption();
            String id = (String)option.getValue();
            String text = option.getTitle();
            selectListOption.setId(id);
            if (selectId.equals(id)) {
                selectList.setText(text);
                selectListOption.setSelected(Boolean.valueOf(true));
            }
            selectListOption.setText(text);
            optionList.add(selectListOption);
        }
        return selectList;
    }

    public static SingleSelectList createSingleSelectList(List<SingleSelectListOption> optionList, String title, String selectId, String text, String local, boolean required, boolean enable) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(Boolean.valueOf(required));
        selectList.setEnable(Boolean.valueOf(enable));
        selectList.setSelectId(selectId);
        selectList.setText(text);
        selectList.setOptionList(optionList);
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
        selectList.setPlaceholder(localeService.getLanguageValue(local, "\u8bf7\u9009\u62e9"));
        return selectList;
    }

    public static SingleSelectList createMultiSelectList(List<SingleSelectListOption> optionList, String title, List<String> selectIdList, List<String> textList, String local, boolean required, boolean enable) {
        SingleSelectList selectList = new SingleSelectList();
        selectList.setTitle(title);
        selectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
        selectList.setRequired(Boolean.valueOf(required));
        selectList.setEnable(Boolean.valueOf(enable));
        selectList.setSelectIdList(selectIdList);
        selectList.setTextList(textList);
        selectList.setOptionList(optionList);
        selectList.setType(Integer.valueOf(2));
        LocaleService localeService = (LocaleService)SpringContextHolder.getBean(LocaleService.class);
        selectList.setPlaceholder(localeService.getLanguageValue(local, "\u8bf7\u9009\u62e9"));
        return selectList;
    }

    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        if (2 == this.type) {
            List valList = (List)JsonUtil.objectToJavaObject((Object)UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema), List.class);
            if (CollectionUtils.isEmpty((Collection)valList)) {
                if (!CollectionUtils.isEmpty((Collection)this.optionList)) {
                    this.selectIdList = this.optionList.stream().filter(option -> !ObjectUtils.isEmpty((Object)option.getSelected()) && BooleanUtils.isTrue((Boolean)option.getSelected())).map(option -> option.getId()).collect(Collectors.toList());
                }
                if (!BooleanUtils.isTrue((Boolean)this.enable)) {
                    this.text = "-";
                }
            } else {
                this.textList = this.optionList.stream().filter(e -> valList.contains(e.getId())).map(e -> e.getText()).collect(Collectors.toList());
                this.selectIdList = valList;
            }
        } else {
            String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, (String)mobilePath, (String)schema)).map(Object::toString).orElse(null);
            if (StringUtils.hasLength((String)value)) {
                this.selectId = value;
                if (!CollectionUtils.isEmpty((Collection)this.optionList)) {
                    Optional<SingleSelectListOption> found = Optional.empty();
                    for (SingleSelectListOption r : this.optionList) {
                        if (value.equals(r.getId())) {
                            r.setSelected(Boolean.valueOf(true));
                            found = Optional.of(r);
                            continue;
                        }
                        r.setSelected(Boolean.valueOf(false));
                    }
                    this.text = found.map(SingleSelectListOption::getText).orElse("");
                }
            } else {
                if (!CollectionUtils.isEmpty((Collection)this.optionList)) {
                    this.optionList.stream().filter(option -> !ObjectUtils.isEmpty((Object)option.getSelected()) && BooleanUtils.isTrue((Boolean)option.getSelected())).forEachOrdered(option -> {
                        this.selectId = option.getId();
                        this.text = option.getText();
                    });
                }
                if (!BooleanUtils.isTrue((Boolean)this.enable)) {
                    this.text = "-";
                }
            }
        }
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)this.placeholder)) {
            this.placeholder = ModuleUtils.localeService.getLanguageValue(executeContext.getLocale(), "\u8bf7\u9009\u62e9");
        }
    }

    public List<SingleSelectListOption> getOptionList() {
        return this.optionList;
    }

    public Integer getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getText() {
        return this.text;
    }

    public Integer getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, Object> getRawData() {
        return this.rawData;
    }

    public List<String> getSelectIdList() {
        return this.selectIdList;
    }

    public List<String> getTextList() {
        return this.textList;
    }

    public Boolean getIsShowDesc() {
        return this.isShowDesc;
    }

    public List<String> getDescPics() {
        return this.descPics;
    }

    public void setOptionList(List<SingleSelectListOption> optionList) {
        this.optionList = optionList;
    }

    public void setStyle(Integer style) {
        this.style = style;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSelectId(String selectId) {
        this.selectId = selectId;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRawData(Map<String, Object> rawData) {
        this.rawData = rawData;
    }

    public void setSelectIdList(List<String> selectIdList) {
        this.selectIdList = selectIdList;
    }

    public void setTextList(List<String> textList) {
        this.textList = textList;
    }

    public void setIsShowDesc(Boolean isShowDesc) {
        this.isShowDesc = isShowDesc;
    }

    public void setDescPics(List<String> descPics) {
        this.descPics = descPics;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleSelectList)) {
            return false;
        }
        SingleSelectList other = (SingleSelectList)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$style = this.getStyle();
        Integer other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)this$style).equals(other$style)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Boolean this$isShowDesc = this.getIsShowDesc();
        Boolean other$isShowDesc = other.getIsShowDesc();
        if (this$isShowDesc == null ? other$isShowDesc != null : !((Object)this$isShowDesc).equals(other$isShowDesc)) {
            return false;
        }
        List this$optionList = this.getOptionList();
        List other$optionList = other.getOptionList();
        if (this$optionList == null ? other$optionList != null : !((Object)this$optionList).equals(other$optionList)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$selectId = this.getSelectId();
        String other$selectId = other.getSelectId();
        if (this$selectId == null ? other$selectId != null : !this$selectId.equals(other$selectId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map this$rawData = this.getRawData();
        Map other$rawData = other.getRawData();
        if (this$rawData == null ? other$rawData != null : !((Object)this$rawData).equals(other$rawData)) {
            return false;
        }
        List this$selectIdList = this.getSelectIdList();
        List other$selectIdList = other.getSelectIdList();
        if (this$selectIdList == null ? other$selectIdList != null : !((Object)this$selectIdList).equals(other$selectIdList)) {
            return false;
        }
        List this$textList = this.getTextList();
        List other$textList = other.getTextList();
        if (this$textList == null ? other$textList != null : !((Object)this$textList).equals(other$textList)) {
            return false;
        }
        List this$descPics = this.getDescPics();
        List other$descPics = other.getDescPics();
        return !(this$descPics == null ? other$descPics != null : !((Object)this$descPics).equals(other$descPics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SingleSelectList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Boolean $isShowDesc = this.getIsShowDesc();
        result = result * 59 + ($isShowDesc == null ? 43 : ((Object)$isShowDesc).hashCode());
        List $optionList = this.getOptionList();
        result = result * 59 + ($optionList == null ? 43 : ((Object)$optionList).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $selectId = this.getSelectId();
        result = result * 59 + ($selectId == null ? 43 : $selectId.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : ((Object)$rawData).hashCode());
        List $selectIdList = this.getSelectIdList();
        result = result * 59 + ($selectIdList == null ? 43 : ((Object)$selectIdList).hashCode());
        List $textList = this.getTextList();
        result = result * 59 + ($textList == null ? 43 : ((Object)$textList).hashCode());
        List $descPics = this.getDescPics();
        result = result * 59 + ($descPics == null ? 43 : ((Object)$descPics).hashCode());
        return result;
    }

    public String toString() {
        return "SingleSelectList(optionList=" + this.getOptionList() + ", style=" + this.getStyle() + ", title=" + this.getTitle() + ", selectId=" + this.getSelectId() + ", text=" + this.getText() + ", type=" + this.getType() + ", url=" + this.getUrl() + ", rawData=" + this.getRawData() + ", selectIdList=" + this.getSelectIdList() + ", textList=" + this.getTextList() + ", isShowDesc=" + this.getIsShowDesc() + ", descPics=" + this.getDescPics() + ")";
    }
}

