/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.input.singletext;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="inputSingleParamAnalyzer")
public class InputSingleParamAnalyzer
implements ComponentParamAnalyzer<InputSingleText, String> {
    private static final Logger logger = LoggerFactory.getLogger(InputSingleParamAnalyzer.class);
    @Autowired
    private LocaleService localeService;

    public String getComponentType() {
        return "INPUT_SINGLE";
    }

    public Class<InputSingleText> getSubmitParamType() {
        return InputSingleText.class;
    }

    public String analyzeSubmitParam(Object submitParam) {
        if (!(submitParam instanceof InputSingleText)) {
            logger.debug("submitParam is not instanceof InputSingleText component...The data of it is: {}", (Object)JsonUtil.javaObjectToJsonString((Object)submitParam));
            return "";
        }
        InputSingleText inputSingleText = (InputSingleText)submitParam;
        return Optional.ofNullable(inputSingleText.getText()).orElse("");
    }

    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData, Object ... args) {
        Map displayParam = (Map)pageData.get((Object)pageDataKey);
        String placeholder = (String)displayParam.get("placeholder");
        Boolean required = (Boolean)displayParam.get("required");
        String text = (String)displayParam.get("text");
        String title = (String)displayParam.get("title");
        displayParam.put("placeholder", this.localeService.getLanguageValue(apiRequest.getLocale(), placeholder));
        displayParam.put("title", this.localeService.getLanguageValue(apiRequest.getLocale(), title));
    }
}

