/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseLayoutMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.layout.ComponentLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class AppEntrance
extends BaseLayoutMobileComponent {
    private static final long serialVersionUID = -8430157681299956778L;
    public static final String COMPONENT_TYPE = "APP_ENTRANCE";
    private Integer appLayoutType;
    private List<AppFunctionTouchable> appList = new ArrayList();
    private Integer direction;
    private String title;
    private Integer titleStyle;

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public ComponentLayoutTypeEnum getComponentLayoutType() {
        return ComponentLayoutTypeEnum.GRID;
    }

    public void initSetting(String locale) {
        super.initSetting(locale);
        this.setTitle(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)this.getTitle()));
        if (null != this.getAppList() && !this.getAppList().isEmpty()) {
            this.getAppList().forEach(buttonApp -> {
                buttonApp.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)buttonApp.getName()));
                this.setAppRequestUrl(buttonApp);
                this.setAppJumpPageTitle(locale, buttonApp);
                this.setAppToastMsg(locale, buttonApp);
            });
        }
    }

    private void setAppToastMsg(String locale, AppFunctionTouchable buttonApp) {
        String toastMsg = Optional.ofNullable(buttonApp.getAction()).map(Action::getToastMsg).orElse("");
        if (!toastMsg.isEmpty()) {
            buttonApp.getAction().setToastMsg(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)toastMsg));
        }
    }

    private void setAppRequestUrl(AppFunctionTouchable buttonApp) {
        String requestUrl = Optional.ofNullable(buttonApp.getAction()).map(Action::getRequestUrl).orElse("");
        if (!requestUrl.isEmpty()) {
            if (!requestUrl.startsWith("http")) {
                requestUrl = AppContext.getBaseUrl() + requestUrl;
            }
            buttonApp.getAction().setRequestUrl(requestUrl);
        }
    }

    private void setAppJumpPageTitle(String locale, AppFunctionTouchable buttonApp) {
        String jumpPageTitle = Optional.ofNullable(buttonApp.getAction()).map(Action::getJumpPageTitle).orElse("");
        if (!jumpPageTitle.isEmpty()) {
            buttonApp.getAction().setJumpPageTitle(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)jumpPageTitle));
        }
    }

    public Integer getAppLayoutType() {
        return this.appLayoutType;
    }

    public List<AppFunctionTouchable> getAppList() {
        return this.appList;
    }

    public Integer getDirection() {
        return this.direction;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getTitleStyle() {
        return this.titleStyle;
    }

    public void setAppLayoutType(Integer appLayoutType) {
        this.appLayoutType = appLayoutType;
    }

    public void setAppList(List<AppFunctionTouchable> appList) {
        this.appList = appList;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleStyle(Integer titleStyle) {
        this.titleStyle = titleStyle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppEntrance)) {
            return false;
        }
        AppEntrance other = (AppEntrance)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$appLayoutType = this.getAppLayoutType();
        Integer other$appLayoutType = other.getAppLayoutType();
        if (this$appLayoutType == null ? other$appLayoutType != null : !((Object)this$appLayoutType).equals(other$appLayoutType)) {
            return false;
        }
        Integer this$direction = this.getDirection();
        Integer other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)this$direction).equals(other$direction)) {
            return false;
        }
        Integer this$titleStyle = this.getTitleStyle();
        Integer other$titleStyle = other.getTitleStyle();
        if (this$titleStyle == null ? other$titleStyle != null : !((Object)this$titleStyle).equals(other$titleStyle)) {
            return false;
        }
        List this$appList = this.getAppList();
        List other$appList = other.getAppList();
        if (this$appList == null ? other$appList != null : !((Object)this$appList).equals(other$appList)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppEntrance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $appLayoutType = this.getAppLayoutType();
        result = result * 59 + ($appLayoutType == null ? 43 : ((Object)$appLayoutType).hashCode());
        Integer $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)$direction).hashCode());
        Integer $titleStyle = this.getTitleStyle();
        result = result * 59 + ($titleStyle == null ? 43 : ((Object)$titleStyle).hashCode());
        List $appList = this.getAppList();
        result = result * 59 + ($appList == null ? 43 : ((Object)$appList).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "AppEntrance(appLayoutType=" + this.getAppLayoutType() + ", appList=" + this.getAppList() + ", direction=" + this.getDirection() + ", title=" + this.getTitle() + ", titleStyle=" + this.getTitleStyle() + ")";
    }

    public AppEntrance(Integer appLayoutType, List<AppFunctionTouchable> appList, Integer direction, String title, Integer titleStyle) {
        this.appLayoutType = appLayoutType;
        this.appList = appList;
        this.direction = direction;
        this.title = title;
        this.titleStyle = titleStyle;
    }

    public AppEntrance() {
    }
}

