/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.list.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelGroupGroup;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.LayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class PersonnelGroup
extends BaseMobileComponent {
    private static final long serialVersionUID = -7728343580346569650L;
    public static final String COMPONENT_TYPE = "PERSONNEL_GROUP";
    private String title = "";
    private Integer layoutType = LayoutTypeEnum.VERTICAL.getValue();
    private List<PersonnelGroupGroup> groupList = new ArrayList();

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public PersonnelGroup convert(ApiRequest apiRequest, List<WoOpReportInfo> allReportList, Map<String, Object> rawData) {
        if (CollectionUtils.isEmpty(allReportList)) {
            return this;
        }
        this.layoutType = LayoutTypeEnum.VERTICAL.getValue();
        this.groupList = allReportList.stream().collect(Collectors.groupingBy(WoOpReportInfo::getTeamNo)).values().stream().sorted((o1, o2) -> {
            Collator collator = "zh_CN".equals(apiRequest.getLocale()) ? Collator.getInstance(Locale.SIMPLIFIED_CHINESE) : Collator.getInstance(Locale.TRADITIONAL_CHINESE);
            return collator.compare(((WoOpReportInfo)o1.get(0)).getTeamName(), ((WoOpReportInfo)o2.get(0)).getTeamName());
        }).map(teamList -> new PersonnelGroupGroup().convert(apiRequest, teamList, rawData)).collect(Collectors.toList());
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getLayoutType() {
        return this.layoutType;
    }

    public List<PersonnelGroupGroup> getGroupList() {
        return this.groupList;
    }

    public PersonnelGroup setTitle(String title) {
        this.title = title;
        return this;
    }

    public PersonnelGroup setLayoutType(Integer layoutType) {
        this.layoutType = layoutType;
        return this;
    }

    public PersonnelGroup setGroupList(List<PersonnelGroupGroup> groupList) {
        this.groupList = groupList;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonnelGroup)) {
            return false;
        }
        PersonnelGroup other = (PersonnelGroup)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$layoutType = this.getLayoutType();
        Integer other$layoutType = other.getLayoutType();
        if (this$layoutType == null ? other$layoutType != null : !((Object)this$layoutType).equals(other$layoutType)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List this$groupList = this.getGroupList();
        List other$groupList = other.getGroupList();
        return !(this$groupList == null ? other$groupList != null : !((Object)this$groupList).equals(other$groupList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PersonnelGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $layoutType = this.getLayoutType();
        result = result * 59 + ($layoutType == null ? 43 : ((Object)$layoutType).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List $groupList = this.getGroupList();
        result = result * 59 + ($groupList == null ? 43 : ((Object)$groupList).hashCode());
        return result;
    }

    public String toString() {
        return "PersonnelGroup(title=" + this.getTitle() + ", layoutType=" + this.getLayoutType() + ", groupList=" + this.getGroupList() + ")";
    }
}

