/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.list.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelGroupGroupData;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.LayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class PersonnelGroupGroup
implements Serializable {
    private static final long serialVersionUID = -5506055554925817130L;
    private String title = "";
    private Integer total = 0;
    private Integer layoutType = LayoutTypeEnum.HORIZONTAL.getValue();
    private List<PersonnelGroupGroupData> dataList = new ArrayList();

    public PersonnelGroupGroup convert(ApiRequest apiRequest, List<WoOpReportInfo> teamList, Map<String, Object> rawData) {
        if (CollectionUtils.isEmpty(teamList)) {
            return this;
        }
        this.title = teamList.get(0).getTeamName();
        this.total = teamList.size();
        this.layoutType = LayoutTypeEnum.HORIZONTAL.getValue();
        Map<PersonnelStateEnum, List<WoOpReportInfo>> map = teamList.stream().collect(Collectors.groupingBy(WoOpReportInfo::getStateEnum));
        this.dataList = new ArrayList();
        this.dataList.add(new PersonnelGroupGroupData().convert(apiRequest, PersonnelStateEnum.ONLINE, map.get(PersonnelStateEnum.ONLINE)).createAction(PersonnelStateEnum.ONLINE, teamList, rawData));
        this.dataList.add(new PersonnelGroupGroupData().convert(apiRequest, PersonnelStateEnum.OFFLINE, map.get(PersonnelStateEnum.OFFLINE)).createAction(PersonnelStateEnum.OFFLINE, teamList, rawData));
        this.dataList.add(new PersonnelGroupGroupData().convert(apiRequest, PersonnelStateEnum.EXCEPT, map.get(PersonnelStateEnum.EXCEPT)).createAction(PersonnelStateEnum.EXCEPT, teamList, rawData));
        this.dataList.add(new PersonnelGroupGroupData().convert(apiRequest, PersonnelStateEnum.SUPPORT, map.get(PersonnelStateEnum.SUPPORT)).createAction(PersonnelStateEnum.SUPPORT, teamList, rawData));
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getTotal() {
        return this.total;
    }

    public Integer getLayoutType() {
        return this.layoutType;
    }

    public List<PersonnelGroupGroupData> getDataList() {
        return this.dataList;
    }

    public PersonnelGroupGroup setTitle(String title) {
        this.title = title;
        return this;
    }

    public PersonnelGroupGroup setTotal(Integer total) {
        this.total = total;
        return this;
    }

    public PersonnelGroupGroup setLayoutType(Integer layoutType) {
        this.layoutType = layoutType;
        return this;
    }

    public PersonnelGroupGroup setDataList(List<PersonnelGroupGroupData> dataList) {
        this.dataList = dataList;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonnelGroupGroup)) {
            return false;
        }
        PersonnelGroupGroup other = (PersonnelGroupGroup)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$total = this.getTotal();
        Integer other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Integer this$layoutType = this.getLayoutType();
        Integer other$layoutType = other.getLayoutType();
        if (this$layoutType == null ? other$layoutType != null : !((Object)this$layoutType).equals(other$layoutType)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List this$dataList = this.getDataList();
        List other$dataList = other.getDataList();
        return !(this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PersonnelGroupGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Integer $layoutType = this.getLayoutType();
        result = result * 59 + ($layoutType == null ? 43 : ((Object)$layoutType).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        return result;
    }

    public String toString() {
        return "PersonnelGroupGroup(title=" + this.getTitle() + ", total=" + this.getTotal() + ", layoutType=" + this.getLayoutType() + ", dataList=" + this.getDataList() + ")";
    }
}

