/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.list.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelStateGroup;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.LayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class PersonnelState
extends BaseMobileComponent {
    private static final long serialVersionUID = -7728343580346569650L;
    public static final String COMPONENT_TYPE = "PERSONNEL_STATE";
    private String title = "";
    private Integer layoutType = LayoutTypeEnum.VERTICAL.getValue();
    private List<PersonnelStateGroup> stateList = new ArrayList();

    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    public PersonnelState convert(ApiRequest apiRequest, LocaleService localeService, PersonnelStateEnum stateEnum, List<WoOpReportInfo> reportList) {
        if (CollectionUtils.isEmpty(reportList)) {
            return this;
        }
        this.layoutType = LayoutTypeEnum.VERTICAL.getValue();
        this.stateList = reportList.stream().collect(Collectors.groupingBy(WoOpReportInfo::getTeamNo)).values().stream().sorted((o1, o2) -> {
            Collator collator = "zh_CN".equalsIgnoreCase(apiRequest.getLocale()) ? Collator.getInstance(Locale.SIMPLIFIED_CHINESE) : Collator.getInstance(Locale.TRADITIONAL_CHINESE);
            return collator.compare(((WoOpReportInfo)o1.get(0)).getTeamName(), ((WoOpReportInfo)o2.get(0)).getTeamName());
        }).map(teamList -> new PersonnelStateGroup().convert(apiRequest, localeService, stateEnum, teamList)).collect(Collectors.toList());
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getLayoutType() {
        return this.layoutType;
    }

    public List<PersonnelStateGroup> getStateList() {
        return this.stateList;
    }

    public PersonnelState setTitle(String title) {
        this.title = title;
        return this;
    }

    public PersonnelState setLayoutType(Integer layoutType) {
        this.layoutType = layoutType;
        return this;
    }

    public PersonnelState setStateList(List<PersonnelStateGroup> stateList) {
        this.stateList = stateList;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonnelState)) {
            return false;
        }
        PersonnelState other = (PersonnelState)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$layoutType = this.getLayoutType();
        Integer other$layoutType = other.getLayoutType();
        if (this$layoutType == null ? other$layoutType != null : !((Object)this$layoutType).equals(other$layoutType)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List this$stateList = this.getStateList();
        List other$stateList = other.getStateList();
        return !(this$stateList == null ? other$stateList != null : !((Object)this$stateList).equals(other$stateList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PersonnelState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $layoutType = this.getLayoutType();
        result = result * 59 + ($layoutType == null ? 43 : ((Object)$layoutType).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List $stateList = this.getStateList();
        result = result * 59 + ($stateList == null ? 43 : ((Object)$stateList).hashCode());
        return result;
    }

    public String toString() {
        return "PersonnelState(title=" + this.getTitle() + ", layoutType=" + this.getLayoutType() + ", stateList=" + this.getStateList() + ")";
    }
}

