/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mobile.mobileuibot.core.component.navbar.index;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.AppInfo;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBarPersonState;
import com.digiwin.mobile.mobileuibot.core.component.search.UniSearch;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndexNavBar
extends BaseMobileComponent
implements Serializable {
    private static final long serialVersionUID = 7492504878094457523L;
    public static final String COMPONENT_TYPE = "INDEX_NAVBAR";
    private List<BottomButtonDigiwinAthena> customButtonList;
    private BaseMobileComponentPerson person;
    private List<IndexNavBarPersonState> personState;
    private Boolean scannerEnable;
    private String welcomeText;
    private String hintTitle;
    private String hintBody;
    private Boolean placeholderEnable;
    private UniSearch uniSearch;
    private BottomButtonDigiwinAthena shortcutButton;
    private BottomButtonDigiwinAthena addressbBookButton;

    public String returnComponentType() {
        return "INDEX_NAVBAR";
    }

    public void initSetting(String locale, AppInfo appInfo) {
        String[] verson;
        if (null != this.getCustomButtonList()) {
            for (BottomButtonDigiwinAthena buttonDigiwinAthena : this.customButtonList) {
                if (buttonDigiwinAthena.getName() != null) {
                    buttonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)buttonDigiwinAthena.getName()));
                }
                this.setRequestUrl(buttonDigiwinAthena);
                List children = buttonDigiwinAthena.getChildren();
                if (children == null || children.size() <= 0) continue;
                for (BottomButtonDigiwinAthena button : children) {
                    if (button.getName() != null) {
                        button.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)button.getName()));
                    }
                    if (button.getSubName() != null) {
                        button.setSubName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)button.getSubName()));
                    }
                    if (button.getAction() != null) {
                        Action action = button.getAction();
                        if (action.getJumpPageTitle() != null) {
                            action.setJumpPageTitle(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)action.getJumpPageTitle()));
                        }
                        if (StringUtils.hasLength((String)action.getToastMsg())) {
                            action.setToastMsg(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)action.getToastMsg()));
                        }
                    }
                    this.setRequestUrl(button);
                }
            }
        }
        if (null != this.getPerson() && StringUtils.hasLength((String)this.person.getName())) {
            this.person.setName(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)this.person.getName()));
        }
        if (null != this.getPersonState()) {
            for (IndexNavBarPersonState indexNavBarPersonState : this.getPersonState()) {
                if (null == indexNavBarPersonState.getText()) continue;
                indexNavBarPersonState.setText(LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)indexNavBarPersonState.getText()));
            }
        }
        Boolean usePlaceholder = false;
        if (appInfo != null && appInfo.getAppVersion() != null && (verson = appInfo.getAppVersion().split("\\.")).length > 0) {
            try {
                usePlaceholder = IndexNavBar.compareVersion((String)appInfo.getAppVersion(), (String)"1.7.6") >= 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.placeholderEnable != null && this.placeholderEnable.booleanValue() && usePlaceholder.booleanValue()) {
            if (null != this.getHintTitle()) {
                this.hintTitle = LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)this.hintTitle);
                this.hintBody = LocaleUtil.getMobileTextByDatabaseKey((String)locale, (String)this.hintBody);
            } else {
                this.hintTitle = "";
                this.hintBody = "";
            }
        } else {
            this.hintTitle = "";
            this.hintBody = "";
        }
        if (null != this.getUniSearch()) {
            this.getUniSearch().initSetting(locale);
        }
    }

    private static int compareVersion(String version1, String version2) throws Exception {
        if (!StringUtils.hasLength((String)version1) || !StringUtils.hasLength((String)version2)) {
            throw new Exception("compareVersion error:illegal params.");
        }
        String[] versionArray1 = version1.split("\\.");
        String[] versionArray2 = version2.split("\\.");
        int minLength = Math.min(versionArray1.length, versionArray2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }

    public static boolean notOptimizedRawData(AppInfo appInfo) {
        String[] verson;
        boolean usePlaceholder = false;
        if (appInfo != null && appInfo.getAppVersion() != null && (verson = appInfo.getAppVersion().split("\\.")).length > 0) {
            try {
                usePlaceholder = IndexNavBar.compareVersion((String)appInfo.getAppVersion(), (String)"1.50.0") < 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return usePlaceholder;
    }

    private void setRequestUrl(BottomButtonDigiwinAthena button) {
        Action action = button.getAction();
        if (action == null || action.getRequestUrl() == null || action.getRequestUrl().length() == 0) {
            return;
        }
        action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
    }

    public void initShortcutButton(ApiRequest apiRequest, ProjectService projectService, LocaleService localeService) {
        if (CollectionUtils.isEmpty((Collection)this.customButtonList)) {
            return;
        }
        this.shortcutButton = new BottomButtonDigiwinAthena();
        this.shortcutButton.setIconData(((BottomButtonDigiwinAthena)this.customButtonList.get(0)).getIconData());
        List launchableProjectList = projectService.getLaunchableProjectList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (CollectionUtils.isEmpty((Collection)launchableProjectList)) {
            Action action = new Action();
            action.setToastMsg(localeService.getLanguageValue(apiRequest.getLocale(), "\u65e0\u53ef\u53d1\u8d77\u7684\u9879\u76ee\uff01"));
            action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
            this.shortcutButton.setAction(action);
            return;
        }
        if (launchableProjectList.size() == 1) {
            LaunchableProject project = (LaunchableProject)launchableProjectList.get(0);
            Action action = new Action();
            action.setDataId(project.getCreateSuffix());
            if (BooleanUtils.isTrue((Boolean)project.getIsDesigner())) {
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                action.setJumpPageTitle(project.getName());
                HashMap<String, String> rawData = new HashMap<String, String>(2);
                rawData.put("project_introduce", project.getDesc());
                rawData.put("project_name", project.getName());
                rawData.put("dataId", project.getCreateSuffix());
                action.setRawData(rawData);
            } else {
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                action.setJumpPageTitle(project.getName());
            }
            this.shortcutButton.setAction(action);
            return;
        }
        List children = ((BottomButtonDigiwinAthena)this.customButtonList.get(0)).getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        this.shortcutButton.setAction(((BottomButtonDigiwinAthena)children.get(0)).getAction());
    }

    public List<BottomButtonDigiwinAthena> getCustomButtonList() {
        return this.customButtonList;
    }

    public BaseMobileComponentPerson getPerson() {
        return this.person;
    }

    public List<IndexNavBarPersonState> getPersonState() {
        return this.personState;
    }

    public Boolean getScannerEnable() {
        return this.scannerEnable;
    }

    public String getWelcomeText() {
        return this.welcomeText;
    }

    public String getHintTitle() {
        return this.hintTitle;
    }

    public String getHintBody() {
        return this.hintBody;
    }

    public Boolean getPlaceholderEnable() {
        return this.placeholderEnable;
    }

    public UniSearch getUniSearch() {
        return this.uniSearch;
    }

    public BottomButtonDigiwinAthena getShortcutButton() {
        return this.shortcutButton;
    }

    public BottomButtonDigiwinAthena getAddressbBookButton() {
        return this.addressbBookButton;
    }

    public void setCustomButtonList(List<BottomButtonDigiwinAthena> customButtonList) {
        this.customButtonList = customButtonList;
    }

    public void setPerson(BaseMobileComponentPerson person) {
        this.person = person;
    }

    public void setPersonState(List<IndexNavBarPersonState> personState) {
        this.personState = personState;
    }

    public void setScannerEnable(Boolean scannerEnable) {
        this.scannerEnable = scannerEnable;
    }

    public void setWelcomeText(String welcomeText) {
        this.welcomeText = welcomeText;
    }

    public void setHintTitle(String hintTitle) {
        this.hintTitle = hintTitle;
    }

    public void setHintBody(String hintBody) {
        this.hintBody = hintBody;
    }

    public void setPlaceholderEnable(Boolean placeholderEnable) {
        this.placeholderEnable = placeholderEnable;
    }

    public void setUniSearch(UniSearch uniSearch) {
        this.uniSearch = uniSearch;
    }

    public void setShortcutButton(BottomButtonDigiwinAthena shortcutButton) {
        this.shortcutButton = shortcutButton;
    }

    public void setAddressbBookButton(BottomButtonDigiwinAthena addressbBookButton) {
        this.addressbBookButton = addressbBookButton;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexNavBar)) {
            return false;
        }
        IndexNavBar other = (IndexNavBar)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$scannerEnable = this.getScannerEnable();
        Boolean other$scannerEnable = other.getScannerEnable();
        if (this$scannerEnable == null ? other$scannerEnable != null : !((Object)this$scannerEnable).equals(other$scannerEnable)) {
            return false;
        }
        Boolean this$placeholderEnable = this.getPlaceholderEnable();
        Boolean other$placeholderEnable = other.getPlaceholderEnable();
        if (this$placeholderEnable == null ? other$placeholderEnable != null : !((Object)this$placeholderEnable).equals(other$placeholderEnable)) {
            return false;
        }
        List this$customButtonList = this.getCustomButtonList();
        List other$customButtonList = other.getCustomButtonList();
        if (this$customButtonList == null ? other$customButtonList != null : !((Object)this$customButtonList).equals(other$customButtonList)) {
            return false;
        }
        BaseMobileComponentPerson this$person = this.getPerson();
        BaseMobileComponentPerson other$person = other.getPerson();
        if (this$person == null ? other$person != null : !this$person.equals(other$person)) {
            return false;
        }
        List this$personState = this.getPersonState();
        List other$personState = other.getPersonState();
        if (this$personState == null ? other$personState != null : !((Object)this$personState).equals(other$personState)) {
            return false;
        }
        String this$welcomeText = this.getWelcomeText();
        String other$welcomeText = other.getWelcomeText();
        if (this$welcomeText == null ? other$welcomeText != null : !this$welcomeText.equals(other$welcomeText)) {
            return false;
        }
        String this$hintTitle = this.getHintTitle();
        String other$hintTitle = other.getHintTitle();
        if (this$hintTitle == null ? other$hintTitle != null : !this$hintTitle.equals(other$hintTitle)) {
            return false;
        }
        String this$hintBody = this.getHintBody();
        String other$hintBody = other.getHintBody();
        if (this$hintBody == null ? other$hintBody != null : !this$hintBody.equals(other$hintBody)) {
            return false;
        }
        UniSearch this$uniSearch = this.getUniSearch();
        UniSearch other$uniSearch = other.getUniSearch();
        if (this$uniSearch == null ? other$uniSearch != null : !this$uniSearch.equals(other$uniSearch)) {
            return false;
        }
        BottomButtonDigiwinAthena this$shortcutButton = this.getShortcutButton();
        BottomButtonDigiwinAthena other$shortcutButton = other.getShortcutButton();
        if (this$shortcutButton == null ? other$shortcutButton != null : !this$shortcutButton.equals(other$shortcutButton)) {
            return false;
        }
        BottomButtonDigiwinAthena this$addressbBookButton = this.getAddressbBookButton();
        BottomButtonDigiwinAthena other$addressbBookButton = other.getAddressbBookButton();
        return !(this$addressbBookButton == null ? other$addressbBookButton != null : !this$addressbBookButton.equals(other$addressbBookButton));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexNavBar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $scannerEnable = this.getScannerEnable();
        result = result * 59 + ($scannerEnable == null ? 43 : ((Object)$scannerEnable).hashCode());
        Boolean $placeholderEnable = this.getPlaceholderEnable();
        result = result * 59 + ($placeholderEnable == null ? 43 : ((Object)$placeholderEnable).hashCode());
        List $customButtonList = this.getCustomButtonList();
        result = result * 59 + ($customButtonList == null ? 43 : ((Object)$customButtonList).hashCode());
        BaseMobileComponentPerson $person = this.getPerson();
        result = result * 59 + ($person == null ? 43 : $person.hashCode());
        List $personState = this.getPersonState();
        result = result * 59 + ($personState == null ? 43 : ((Object)$personState).hashCode());
        String $welcomeText = this.getWelcomeText();
        result = result * 59 + ($welcomeText == null ? 43 : $welcomeText.hashCode());
        String $hintTitle = this.getHintTitle();
        result = result * 59 + ($hintTitle == null ? 43 : $hintTitle.hashCode());
        String $hintBody = this.getHintBody();
        result = result * 59 + ($hintBody == null ? 43 : $hintBody.hashCode());
        UniSearch $uniSearch = this.getUniSearch();
        result = result * 59 + ($uniSearch == null ? 43 : $uniSearch.hashCode());
        BottomButtonDigiwinAthena $shortcutButton = this.getShortcutButton();
        result = result * 59 + ($shortcutButton == null ? 43 : $shortcutButton.hashCode());
        BottomButtonDigiwinAthena $addressbBookButton = this.getAddressbBookButton();
        result = result * 59 + ($addressbBookButton == null ? 43 : $addressbBookButton.hashCode());
        return result;
    }

    public String toString() {
        return "IndexNavBar(customButtonList=" + this.getCustomButtonList() + ", person=" + this.getPerson() + ", personState=" + this.getPersonState() + ", scannerEnable=" + this.getScannerEnable() + ", welcomeText=" + this.getWelcomeText() + ", hintTitle=" + this.getHintTitle() + ", hintBody=" + this.getHintBody() + ", placeholderEnable=" + this.getPlaceholderEnable() + ", uniSearch=" + this.getUniSearch() + ", shortcutButton=" + this.getShortcutButton() + ", addressbBookButton=" + this.getAddressbBookButton() + ")";
    }

    public IndexNavBar() {
    }

    public IndexNavBar(List<BottomButtonDigiwinAthena> customButtonList, BaseMobileComponentPerson person, List<IndexNavBarPersonState> personState, Boolean scannerEnable, String welcomeText, String hintTitle, String hintBody, Boolean placeholderEnable, UniSearch uniSearch, BottomButtonDigiwinAthena shortcutButton, BottomButtonDigiwinAthena addressbBookButton) {
        this.customButtonList = customButtonList;
        this.person = person;
        this.personState = personState;
        this.scannerEnable = scannerEnable;
        this.welcomeText = welcomeText;
        this.hintTitle = hintTitle;
        this.hintBody = hintBody;
        this.placeholderEnable = placeholderEnable;
        this.uniSearch = uniSearch;
        this.shortcutButton = shortcutButton;
        this.addressbBookButton = addressbBookButton;
    }
}

